/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.sql;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.PrimaryKeyColumn;
import org.openforis.collect.relational.model.PrimaryKeyConstraint;
import org.openforis.collect.relational.model.ReferentialConstraint;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.Table;
import org.openforis.collect.relational.model.UniquenessConstraint;
import org.openforis.collect.relational.print.RDBPrintJob;
import org.openforis.collect.relational.sql.SqlWriter;
import org.openforis.collect.relational.util.SQLUtils;

public class SqlSchemaWriter
extends SqlWriter {
    private boolean includeForeignKeysInCreateTable;

    public SqlSchemaWriter(Writer writer, RelationalSchema schema) {
        this(writer, schema, RDBPrintJob.RdbDialect.STANDARD, true);
    }

    public SqlSchemaWriter(Writer writer, RelationalSchema schema, RDBPrintJob.RdbDialect dialect) {
        this(writer, schema, dialect, true);
    }

    public SqlSchemaWriter(Writer writer, RelationalSchema schema, RDBPrintJob.RdbDialect dialect, boolean includeForeignKeysInCreateTable) {
        this(writer, schema, dialect, includeForeignKeysInCreateTable, "yyyy-MM-dd HH:mm");
    }

    public SqlSchemaWriter(Writer writer, RelationalSchema schema, RDBPrintJob.RdbDialect dialect, boolean includeForeignKeysInCreateTable, String dataTimeFormat) {
        super(writer, schema, dialect, dataTimeFormat);
        this.includeForeignKeysInCreateTable = includeForeignKeysInCreateTable;
    }

    public void write() throws Throwable {
        if (!this.isSchemaless()) {
            this.writer.write("CREATE SCHEMA ");
            this.writer.write(SQLUtils.doubleQuote(this.schema.getName()));
            this.writer.write(59);
            this.writer.write(10);
        }
        for (Table<?> table : this.schema.getTables()) {
            this.writeTable(table);
        }
        if (!this.includeForeignKeysInCreateTable) {
            this.writeAddForeignKeysWithAlterTable();
        }
        this.writer.flush();
    }

    private void writeTable(Table<?> table) throws IOException {
        this.writer.write("CREATE TABLE ");
        if (!this.isSchemaless()) {
            this.writer.write(SQLUtils.doubleQuote(this.schema.getName()));
            this.writer.write(46);
        }
        this.writer.write(SQLUtils.doubleQuote(table.getName()));
        this.writer.write(" (");
        this.writer.write(10);
        List<Column<?>> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                this.writer.write(44);
                this.writer.write(10);
            }
            Column<?> column = columns.get(i);
            this.writeColumn(column);
        }
        if (this.includeForeignKeysInCreateTable && !table.getReferentialContraints().isEmpty()) {
            this.writer.write(44);
            this.writer.write(10);
            List<ReferentialConstraint> fks = table.getReferentialContraints();
            for (int i = 0; i < fks.size(); ++i) {
                ReferentialConstraint fk = fks.get(i);
                this.writer.write(9);
                this.writeForeignKeyConstraint(fk);
                if (i >= fks.size() - 1) continue;
                this.writer.write(", \n");
            }
        }
        this.writer.write(10);
        this.writer.write(");");
        this.writer.write(10);
    }

    private void writeColumn(Column<?> column) throws IOException {
        this.writer.write(9);
        this.writer.write(SQLUtils.doubleQuote(column.getName()));
        this.writer.write(32);
        this.writer.write(column.getType().getName());
        if (column.getLength() != null) {
            this.writer.write(40);
            this.writer.write(column.getLength().toString());
            this.writer.write(41);
        }
        if (!column.isNullable()) {
            this.writer.write(" NOT NULL");
        }
        if (column instanceof PrimaryKeyColumn) {
            this.writer.write(" PRIMARY KEY");
        }
    }

    private void writeAddForeignKeysWithAlterTable() throws IOException {
        for (Table<?> table : this.schema.getTables()) {
            List<ReferentialConstraint> fks = table.getReferentialContraints();
            if (fks.isEmpty()) continue;
            this.writer.write("ALTER TABLE ");
            this.writer.write(this.getQualifiedTableName(table));
            this.writer.write(10);
            for (int i = 0; i < fks.size(); ++i) {
                ReferentialConstraint fk = fks.get(i);
                this.writer.write(9);
                this.writer.write(" ADD CONSTRAINT ");
                this.writer.write(fk.getName());
                this.writeForeignKeyConstraint(fk);
                if (i < fks.size() - 1) {
                    this.writer.write(", \n");
                    continue;
                }
                this.writer.write(";");
            }
            this.writer.write(10);
        }
    }

    private void writeForeignKeyConstraint(ReferentialConstraint fk) throws IOException {
        this.writer.write(" FOREIGN KEY ");
        this.writer.write(40);
        this.writeColumnNameSet(fk.getColumns());
        this.writer.write(41);
        this.writer.write(" REFERENCES ");
        UniquenessConstraint referencedKey = fk.getReferencedKey();
        Table<?> referencedTable = referencedKey.getTable();
        this.writer.write(this.getQualifiedTableName(referencedTable));
        PrimaryKeyConstraint referencedTablePK = referencedTable.getPrimaryKeyConstraint();
        this.writer.write(40);
        this.writeColumnNameSet(referencedTablePK.getColumns());
        this.writer.write(")");
    }

    private void writeColumnNameSet(List<Column<?>> referencedColumns) throws IOException {
        for (int i = 0; i < referencedColumns.size(); ++i) {
            if (i > 0) {
                this.writer.write(44);
            }
            this.writer.write(SQLUtils.doubleQuote(referencedColumns.get(i).getName()));
        }
    }

    private String getQualifiedTableName(Table<?> table) {
        StringBuffer sb = new StringBuffer();
        if (!this.isSchemaless()) {
            sb.append(SQLUtils.doubleQuote(this.schema.getName()));
            sb.append('.');
        }
        sb.append(SQLUtils.doubleQuote(table.getName()));
        return sb.toString();
    }
}

