/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.data.internal;

import java.math.BigInteger;
import java.util.List;
import org.openforis.collect.relational.data.DataExtractor;
import org.openforis.collect.relational.data.Dataset;
import org.openforis.collect.relational.data.Row;
import org.openforis.collect.relational.data.internal.CodeValueFKColumnValueExtractor;
import org.openforis.collect.relational.data.internal.CoordinateLatLonColumnValueExtractor;
import org.openforis.collect.relational.data.internal.DataTableDataColumnValueExtractor;
import org.openforis.collect.relational.model.CodeValueFKColumn;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.CoordinateLatLonColumn;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataPrimaryKeyColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.Table;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.model.Entity;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Record;
import org.openforis.idm.path.Path;

public class DataTableDataExtractor
extends DataExtractor {
    private static final int NODE_ID_MAX_VALUE = Integer.MAX_VALUE;
    private DataTable table;
    private Record record;
    private List<Node<?>> nodes;
    private int total;
    private int nextIndex;

    public DataTableDataExtractor(DataTable table, Record record) {
        this.table = table;
        this.record = record;
        this.init();
    }

    private void init() {
        this.nodes = this.record.findNodesByPath(this.table.getNodeDefinition().getPath());
        this.total = this.nodes.size();
        this.nextIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.total;
    }

    @Override
    public Row next() {
        Node<?> source = this.nodes.get(this.nextIndex++);
        Row row = this.extractRow(source);
        return row;
    }

    @Override
    public Table<?> getTable() {
        return this.table;
    }

    public Dataset extractData(Node<?> source) {
        Dataset data = new Dataset();
        this.extractDataInternal(this.table, source, data);
        return data;
    }

    private void extractDataInternal(DataTable table, Node<?> source, Dataset data) {
        Row row = this.extractRow(source);
        data.addRow(row);
        for (DataTable childTable : table.getChildTables()) {
            Path path = childTable.getRelativePath();
            List children = path.evaluate(source);
            for (Node child : children) {
                this.extractDataInternal(childTable, child, data);
            }
        }
    }

    private Row extractRow(Node<?> source) {
        List columns = this.table.getColumns();
        Row row = new Row(this.table);
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            Object val = this.extractColumnValue(source, col);
            row.setValue(i, val);
        }
        return row;
    }

    private Object extractColumnValue(Node<?> context, Column<?> column) {
        if (column instanceof DataPrimaryKeyColumn) {
            return DataTableDataExtractor.getTableArtificialPK(context);
        }
        if (column instanceof CodeValueFKColumn) {
            CodeValueFKColumnValueExtractor valueExtractor = new CodeValueFKColumnValueExtractor(this.table, (CodeValueFKColumn)column);
            return valueExtractor.extractValue(context);
        }
        if (column instanceof CoordinateLatLonColumn) {
            return new CoordinateLatLonColumnValueExtractor(this.table, (CoordinateLatLonColumn)column).extractValue(context);
        }
        if (column instanceof DataAncestorFKColumn) {
            EntityDefinition referencedEntityDefinition = this.table.getReferencedEntityDefinition((DataAncestorFKColumn)column);
            Entity ancestor = context.getAncestorByDefinition(referencedEntityDefinition);
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Referenced ancestor entity not found for column %s inside table %s", column.getName(), this.table.getName()));
            }
            return DataTableDataExtractor.getTableArtificialPK(ancestor);
        }
        if (column instanceof DataColumn) {
            DataTableDataColumnValueExtractor<DataColumn> valueExtractor = new DataTableDataColumnValueExtractor<DataColumn>(this.table, (DataColumn)column);
            return valueExtractor.extractValue(context);
        }
        throw new IllegalArgumentException("Unsupported column type: " + column.getClass().getName());
    }

    public static BigInteger getTableArtificialPK(Node<?> node) {
        return DataTableDataExtractor.getTableArtificialPK(node.getRecord().getId(), node.getDefinition(), node.getInternalId());
    }

    public static BigInteger getTableArtificialPK(int recordId, NodeDefinition nodeDef, int nodeId) {
        if (nodeDef instanceof EntityDefinition && ((EntityDefinition)nodeDef).isRoot()) {
            return BigInteger.valueOf(recordId);
        }
        return BigInteger.valueOf(nodeId).add(BigInteger.valueOf(recordId).multiply(BigInteger.valueOf(Integer.MAX_VALUE)));
    }
}

