/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import org.openforis.collect.relational.model.AbstractTable;
import org.openforis.collect.relational.model.CodeListCodeColumn;
import org.openforis.collect.relational.model.Column;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.LanguageSpecificTextMap;

public class CodeTable
extends AbstractTable<CodeListItem> {
    private CodeList codeList;
    private CodeTable parent;
    private String defaultCode;
    private LanguageSpecificTextMap defaultCodeLabels;

    CodeTable(String prefix, String baseName, CodeList codeList, CodeTable parent, String defaultCode, LanguageSpecificTextMap defaultCodeLabels) {
        super(prefix, baseName);
        this.codeList = codeList;
        this.parent = parent;
        this.defaultCode = defaultCode;
        this.defaultCodeLabels = defaultCodeLabels;
    }

    public CodeList getCodeList() {
        return this.codeList;
    }

    public CodeTable getParent() {
        return this.parent;
    }

    public String getDefaultCode() {
        return this.defaultCode;
    }

    public LanguageSpecificTextMap getDefaultCodeLabels() {
        return this.defaultCodeLabels;
    }

    public String getDefaultCodeLabel(String langCode, String defaultLanguage) {
        if (this.defaultCodeLabels == null) {
            return null;
        }
        return this.defaultCodeLabels.getText(langCode, defaultLanguage);
    }

    public Integer getLevelIdx() {
        Integer result = null;
        if (this.codeList.isHierarchical()) {
            result = 0;
            CodeTable cp = this.parent;
            while (cp != null) {
                Integer n = result;
                result = result + 1;
                cp = cp.parent;
            }
        }
        return result;
    }

    public CodeListCodeColumn getCodeColumn() {
        for (Column column : this.getColumns()) {
            if (!(column instanceof CodeListCodeColumn)) continue;
            return (CodeListCodeColumn)column;
        }
        return null;
    }
}

