/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.Table;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Survey;

public final class RelationalSchema {
    private Survey survey;
    private String name;
    private Map<String, Table<?>> tablesByName;
    private Map<Integer, DataTable> dataTableByDefinitionId;
    private Map<CodeListTableKey, CodeTable> codeListTables;
    private Map<String, DataTable> rootDataTables;

    RelationalSchema(Survey survey, String name) throws CollectRdbException {
        this.survey = survey;
        this.name = name;
        this.tablesByName = new LinkedHashMap();
        this.codeListTables = new LinkedHashMap<CodeListTableKey, CodeTable>();
        this.rootDataTables = new HashMap<String, DataTable>();
        this.dataTableByDefinitionId = new HashMap<Integer, DataTable>();
    }

    public Survey getSurvey() {
        return this.survey;
    }

    public String getName() {
        return this.name;
    }

    public List<Table<?>> getTables() {
        ArrayList tableList = new ArrayList(this.tablesByName.values());
        return Collections.unmodifiableList(tableList);
    }

    public List<DataTable> getDataTables() {
        ArrayList<DataTable> result = new ArrayList<DataTable>();
        for (DataTable dataTable : this.getRootDataTables()) {
            result.add(dataTable);
            int rootDefId = dataTable.getNodeDefinition().getId();
            result.addAll(this.getDescendantTablesForDefinition(rootDefId));
        }
        return result;
    }

    public List<? extends DataTable> getDescendantTablesForDefinition(int definitionId) {
        ArrayList<DataTable> result = new ArrayList<DataTable>();
        LinkedList<DataTable> queue = new LinkedList<DataTable>();
        queue.add(this.getDataTableByDefinitionId(definitionId));
        while (!queue.isEmpty()) {
            DataTable table = (DataTable)queue.poll();
            result.add(table);
            queue.addAll(table.getChildTables());
        }
        return result.subList(1, result.size());
    }

    public Collection<DataTable> getRootDataTables() {
        return this.rootDataTables.values();
    }

    public DataTable getRootDataTable(String rootEntityName) {
        return this.rootDataTables.get(rootEntityName);
    }

    public Table<?> getTable(String name) {
        Table<?> table = this.tablesByName.get(name);
        if (table == null) {
            throw new IllegalArgumentException("Table not found: " + name);
        }
        return table;
    }

    public List<CodeTable> getCodeListTables() {
        ArrayList<CodeTable> tableList = new ArrayList<CodeTable>(this.codeListTables.values());
        return Collections.unmodifiableList(tableList);
    }

    public CodeTable getCodeListTable(CodeAttributeDefinition attrDef) {
        return this.getCodeListTable(attrDef.getList(), attrDef.getListLevelIndex());
    }

    public CodeTable getCodeListTable(CodeList list, Integer levelIdx) {
        CodeListTableKey key = new CodeListTableKey(list.getId(), levelIdx);
        return this.codeListTables.get(key);
    }

    public boolean containsTable(String name) {
        return this.tablesByName.containsKey(name);
    }

    void addTable(Table<?> table) {
        String name = table.getName();
        this.tablesByName.put(name, table);
        if (table instanceof DataTable) {
            DataTable dataTable = (DataTable)table;
            NodeDefinition defn = dataTable.getNodeDefinition();
            this.dataTableByDefinitionId.put(defn.getId(), dataTable);
            if (dataTable.getParent() == null) {
                this.rootDataTables.put(defn.getName(), dataTable);
            }
        } else if (table instanceof CodeTable) {
            CodeTable codeListTable = (CodeTable)table;
            CodeList codeList = codeListTable.getCodeList();
            CodeListTableKey key = new CodeListTableKey(codeList.getId(), codeListTable.getLevelIdx());
            this.codeListTables.put(key, codeListTable);
        }
    }

    void assignAncestorTable(EntityDefinition entityDefn) {
        int nodeId = entityDefn.getId();
        while (!entityDefn.isMultiple()) {
            entityDefn = entityDefn.getParentEntityDefinition();
        }
        this.dataTableByDefinitionId.put(nodeId, this.dataTableByDefinitionId.get(entityDefn.getId()));
    }

    public DataTable getDataTable(NodeDefinition nodeDefinition) {
        int id = nodeDefinition.getId();
        return this.getDataTableByDefinitionId(id);
    }

    public DataTable getDataTableByDefinitionId(int id) {
        return this.dataTableByDefinitionId.get(id);
    }

    private static class CodeListTableKey {
        private int listId;
        private Integer levelIdx;

        CodeListTableKey(int listId, Integer levelIdx) {
            this.listId = listId;
            this.levelIdx = levelIdx;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.levelIdx == null ? 0 : this.levelIdx.hashCode());
            result = 31 * result + this.listId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodeListTableKey other = (CodeListTableKey)obj;
            if (this.levelIdx == null ? other.levelIdx != null : !this.levelIdx.equals(other.levelIdx)) {
                return false;
            }
            return this.listId == other.listId;
        }
    }
}

