/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.PrimaryKeyConstraint;
import org.openforis.collect.relational.model.ReferentialConstraint;
import org.openforis.collect.relational.model.Table;
import org.openforis.collect.relational.model.UniquenessConstraint;
import org.openforis.idm.metamodel.EntityDefinition;

abstract class AbstractTable<T>
implements Table<T> {
    private String prefix;
    private String baseName;
    private LinkedHashMap<String, Column<?>> columns;
    private PrimaryKeyConstraint primaryKeyConstraint;
    private List<ReferentialConstraint> referentialConstraints;

    AbstractTable(String prefix, String baseName) {
        this.prefix = prefix;
        this.baseName = baseName;
        this.columns = new LinkedHashMap();
        this.referentialConstraints = new ArrayList<ReferentialConstraint>();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getName() {
        return this.prefix + this.baseName;
    }

    void addColumn(Column<?> column) {
        String columnName = column.getName();
        this.columns.put(columnName, column);
    }

    @Override
    public Column<?> getColumn(String name) {
        Column<?> column = this.columns.get(name);
        if (column == null) {
            throw new IllegalArgumentException("Column '" + name + "' not found in table '" + this.getName() + "'");
        }
        return column;
    }

    void setPrimaryKeyConstraint(PrimaryKeyConstraint primaryKeyConstraint) {
        this.primaryKeyConstraint = primaryKeyConstraint;
    }

    void addConstraint(ReferentialConstraint constraint) {
        this.referentialConstraints.add(constraint);
    }

    @Override
    public List<Column<?>> getColumns() {
        ArrayList columnList = new ArrayList(this.columns.values());
        return Collections.unmodifiableList(columnList);
    }

    @Override
    public PrimaryKeyConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    @Override
    public List<ReferentialConstraint> getReferentialContraints() {
        return Collections.unmodifiableList(this.referentialConstraints);
    }

    public List<ReferentialConstraint> getReferentialConstraintsByColumn(Column<?> column) {
        ArrayList<ReferentialConstraint> result = new ArrayList<ReferentialConstraint>();
        block0: for (ReferentialConstraint constraint : this.referentialConstraints) {
            for (Column<?> constraingColumn : constraint.getColumns()) {
                if (!constraingColumn.getName().equals(column.getName())) continue;
                result.add(constraint);
                continue block0;
            }
        }
        return result;
    }

    public EntityDefinition getReferencedEntityDefinition(DataAncestorFKColumn fkColumn) {
        DataTable referencedTable = this.getReferencedTable(fkColumn);
        EntityDefinition referencedEntityDef = (EntityDefinition)referencedTable.getNodeDefinition();
        return referencedEntityDef;
    }

    public DataTable getReferencedTable(Column<?> fkColumn) {
        List<ReferentialConstraint> constraints = this.getReferentialConstraintsByColumn(fkColumn);
        for (ReferentialConstraint constraint : constraints) {
            UniquenessConstraint referencedKey = constraint.getReferencedKey();
            if (!(referencedKey instanceof PrimaryKeyConstraint)) continue;
            DataTable referencedTable = (DataTable)referencedKey.getTable();
            return referencedTable;
        }
        throw new IllegalArgumentException(String.format("Referenced table not found for column %s in table %s", fkColumn.getName(), this.getName()));
    }

    public boolean containsColumn(String name) {
        return this.columns.containsKey(name);
    }

    public String toString() {
        return this.getName();
    }
}

