/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.sql;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Statement;
import org.jooq.SQLDialect;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.relational.RelationalSchemaCreator;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.print.RDBPrintJob;
import org.openforis.collect.relational.sql.SqlSchemaWriter;

public class SQLRelationalSchemaCreator
implements RelationalSchemaCreator {
    @Override
    public void createRelationalSchema(RelationalSchema schema, Connection conn) {
        CollectDSLContext dsl = new CollectDSLContext(conn);
        RDBPrintJob.RdbDialect rdbDialect = this.getRdbDialect(dsl);
        StringWriter writer = new StringWriter();
        SqlSchemaWriter schemaWriter = new SqlSchemaWriter(writer, schema, rdbDialect);
        try {
            schemaWriter.write();
            String sql = ((Object)writer).toString();
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Error generating schema on db for rdb schema %s", schema.getName()), e);
        }
    }

    private RDBPrintJob.RdbDialect getRdbDialect(CollectDSLContext dsl) {
        RDBPrintJob.RdbDialect rdbDialect;
        SQLDialect dialect = dsl.getDialect();
        switch (dialect) {
            case SQLITE: {
                rdbDialect = RDBPrintJob.RdbDialect.SQLITE;
                break;
            }
            default: {
                rdbDialect = RDBPrintJob.RdbDialect.STANDARD;
            }
        }
        return rdbDialect;
    }

    @Override
    public void addConstraints(RelationalSchema schema, Connection conn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addIndexes(RelationalSchema schema, Connection conn) {
        throw new UnsupportedOperationException();
    }
}

