/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.jooq;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.jooq.CollectCreateIndexStep;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.CreateTableAsStep;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.impl.DSL;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.RelationalSchemaCreator;
import org.openforis.collect.relational.model.CodeListCodeColumn;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.PrimaryKeyConstraint;
import org.openforis.collect.relational.model.ReferentialConstraint;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.Table;

public class JooqRelationalSchemaCreator
implements RelationalSchemaCreator {
    @Override
    public void createRelationalSchema(RelationalSchema schema, Connection conn) throws CollectRdbException {
        CollectDSLContext dsl = new CollectDSLContext(conn);
        for (Table<?> table : schema.getTables()) {
            org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
            CreateTableAsStep createTableStep = dsl.createTable(jooqTable);
            Query createTableFinalQuery = (Query)createTableStep;
            for (Column<?> column : table.getColumns()) {
                DataType dataType = dsl.getDataType(column.getType().getJavaType());
                Integer length = column.getLength();
                if (length != null) {
                    dataType.length(length.intValue());
                }
                createTableFinalQuery = createTableStep.column(column.getName(), dataType);
            }
            createTableFinalQuery.execute();
        }
        this.createDataTableViews(schema, conn);
    }

    @Override
    public void addConstraints(RelationalSchema schema, Connection conn) {
        CollectDSLContext dsl = new CollectDSLContext(conn);
        if (!dsl.isSQLite()) {
            this.addPKConstraints(schema, dsl);
        }
        if (dsl.isForeignKeySupported()) {
            this.createForeignKeys(schema, dsl);
        }
    }

    @Override
    public void addIndexes(RelationalSchema schema, Connection conn) {
        CollectDSLContext dsl = new CollectDSLContext(conn);
        if (dsl.isSQLite()) {
            this.addCodeListsCodeIndexes(schema, dsl);
            this.addPKIndexes(schema, dsl);
            this.addFKIndexes(schema, dsl);
        }
    }

    private void createDataTableViews(RelationalSchema schema, Connection conn) {
        List<DataTable> dataTables = schema.getDataTables();
        for (DataTable dataTable : dataTables) {
            this.createDataTableView(schema, dataTable, conn);
        }
    }

    private void createDataTableView(RelationalSchema schema, DataTable dataTable, Connection conn) {
        CollectDSLContext dsl = new CollectDSLContext(conn);
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<org.jooq.Table<Record>> tables = new ArrayList<org.jooq.Table<Record>>();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        DataTable currentTable = dataTable;
        while (currentTable != null) {
            org.jooq.Table<Record> currentJooqTable = this.jooqTable(schema, currentTable, !dsl.isSchemaLess());
            tables.add(currentJooqTable);
            List columns = currentTable.getColumns();
            for (Column column : columns) {
                if (column instanceof DataAncestorFKColumn) continue;
                fields.add(DSL.field((Name)DSL.name((String[])new String[]{currentJooqTable.getName(), column.getName()})));
            }
            DataTable parentTable = currentTable.getParent();
            if (parentTable != null) {
                Condition parentTableJoinCondition = DSL.field((String)(currentJooqTable.getName() + "." + currentTable.getParentFKColumn().getName())).eq(DSL.field((String)(parentTable.getName() + "." + parentTable.getPrimaryKeyColumn().getName())));
                conditions.add(parentTableJoinCondition);
            }
            currentTable = parentTable;
        }
        SelectConditionStep select = dsl.select(fields).from(tables).where(conditions);
        Name name = dsl.isSchemaLess() ? DSL.name((String[])new String[]{dataTable.getName() + "_view"}) : DSL.name((String[])new String[]{schema.getName(), dataTable.getName() + "_view"});
        dsl.createView(DSL.table((Name)name), fields.toArray(new Field[fields.size()])).as((Select)select).execute();
    }

    private void addCodeListsCodeIndexes(RelationalSchema schema, CollectDSLContext dsl) {
        for (Table<?> table : schema.getTables()) {
            if (!(table instanceof CodeTable)) continue;
            CodeTable codeTable = (CodeTable)table;
            org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
            CodeListCodeColumn codeColumn = codeTable.getCodeColumn();
            CollectCreateIndexStep createIndexStep = dsl.createIndex(table.getName() + "_code_idx");
            if (codeTable.getLevelIdx() == null || codeTable.getLevelIdx() == 0) {
                createIndexStep.unique();
            }
            createIndexStep.on(jooqTable, new Field[]{DSL.field((String)codeColumn.getName())}).execute();
        }
    }

    private void addPKConstraints(RelationalSchema schema, CollectDSLContext dsl) {
        for (Table<?> table : schema.getTables()) {
            org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
            PrimaryKeyConstraint pkConstraint = table.getPrimaryKeyConstraint();
            String pkColumnName = pkConstraint.getPrimaryKeyColumn().getName();
            String pkConstraintName = table.getName() + "_pk";
            dsl.alterTable(jooqTable).add((Constraint)DSL.constraint((String)pkConstraintName).primaryKey(new String[]{pkColumnName})).execute();
        }
    }

    private void addPKIndexes(RelationalSchema schema, CollectDSLContext dsl) {
        for (Table<?> table : schema.getTables()) {
            org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
            PrimaryKeyConstraint pkConstraint = table.getPrimaryKeyConstraint();
            String pkColumnName = pkConstraint.getPrimaryKeyColumn().getName();
            String pkConstraintName = table.getName() + "_pk";
            dsl.createIndex(pkConstraintName).unique().on(jooqTable, new Field[]{DSL.field((String)pkColumnName)}).execute();
        }
    }

    private void addFKIndexes(RelationalSchema schema, CollectDSLContext dsl) {
        for (Table<?> table : schema.getTables()) {
            if (!(table instanceof DataTable)) continue;
            org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
            int idxCount = 1;
            for (ReferentialConstraint referentialConstraint : table.getReferentialContraints()) {
                String idxName = String.format("%s_%d_idx", table.getName(), idxCount);
                dsl.createIndex(idxName).on(jooqTable, this.toJooqFields(referentialConstraint.getColumns())).execute();
                ++idxCount;
            }
        }
    }

    private void createForeignKeys(RelationalSchema schema, CollectDSLContext dsl) {
        for (Table<?> table : schema.getTables()) {
            List<ReferentialConstraint> fks = table.getReferentialContraints();
            for (ReferentialConstraint fk : fks) {
                Field<?>[] fields = this.toJooqFields(fk.getColumns());
                org.jooq.Table<Record> jooqTable = this.jooqTable(schema, table, !dsl.isSchemaLess());
                org.jooq.Table<Record> referencedJooqTable = this.jooqTable(schema, fk.getReferencedKey().getTable(), !dsl.isSchemaLess());
                List<Column<?>> referencedColumns = fk.getReferencedKey().getColumns();
                dsl.alterTable(jooqTable).add((Constraint)DSL.constraint((String)fk.getName()).foreignKey(fields).references(referencedJooqTable, this.toJooqFields(referencedColumns))).execute();
            }
        }
    }

    private Field<?>[] toJooqFields(List<Column<?>> columns) {
        ArrayList<Field> fields = new ArrayList<Field>(columns.size());
        for (Column<?> column : columns) {
            fields.add(DSL.field((String)column.getName()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private org.jooq.Table<Record> jooqTable(RelationalSchema schema, Table<?> table, boolean renderSchema) {
        if (renderSchema) {
            return DSL.table((Name)DSL.name((String[])new String[]{schema.getName(), table.getName()}));
        }
        return DSL.table((Name)DSL.name((String[])new String[]{table.getName()}));
    }
}

