/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.data.internal;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.relational.data.internal.ColumnValueExtractor;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.sql.RDBJdbcType;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Date;
import org.openforis.idm.model.DateAttribute;
import org.openforis.idm.model.Field;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Time;
import org.openforis.idm.model.TimeAttribute;

public class DataTableDataColumnValueExtractor<C extends DataColumn>
extends ColumnValueExtractor<DataTable, C> {
    private static final Logger LOG = LogManager.getLogger(DataTableDataColumnValueExtractor.class);

    public DataTableDataColumnValueExtractor(DataTable table, C column) {
        super(table, column);
    }

    @Override
    public Object extractValue(Node<?> context) {
        Node<?> valNode = this.extractValueNode(context);
        Object val = this.extractNodeValue(valNode);
        if (RDBJdbcType.VARCHAR == ((DataColumn)this.column).getType() && val != null) {
            Integer colLength = ((DataColumn)this.column).getLength();
            int valLength = val.toString().length();
            if (valLength > colLength) {
                LOG.warn(String.format("Record: %d. Value of node %s (%s) has a length of %d characters and exceeds the maximum allowed (%d), so it has been truncated", context.getRecord().getId(), valNode.getPath(), val, valLength, colLength));
                val = ((String)val).substring(0, colLength);
            }
        }
        if (DataTableDataColumnValueExtractor.isNullOrNaN(val)) {
            return ((DataColumn)this.column).getDefaultValue();
        }
        return val;
    }

    protected Node<?> extractValueNode(Node<?> context) {
        List vals = ((DataColumn)this.column).getRelativePath().evaluate(context);
        if (vals.size() > 1) {
            LOG.warn(String.format("Record: %s - path %s returned more than one value", ((CollectRecord)context.getRecord()).getRootEntityKeyValues(), ((DataColumn)this.column).getRelativePath()));
        }
        if (vals.isEmpty()) {
            return null;
        }
        return (Node)vals.get(0);
    }

    private Object extractNodeValue(Node<?> valNode) {
        if (valNode == null) {
            return null;
        }
        try {
            if (valNode instanceof Field) {
                return ((Field)valNode).getValue();
            }
            if (valNode instanceof DateAttribute) {
                Date date = ((DateAttribute)valNode).getValue();
                return date.toJavaDate();
            }
            if (valNode instanceof TimeAttribute) {
                Time time = ((TimeAttribute)valNode).getValue();
                return time.toXmlTime();
            }
            if (valNode instanceof Attribute) {
                return ((Attribute)valNode).getValue();
            }
            throw new RuntimeException("Unknown data node type " + valNode.getClass());
        }
        catch (Exception e) {
            String messageFormat = "Error converting attribute value in record: %d - node: %s";
            String message = String.format(messageFormat, valNode.getRecord().getId(), valNode.getPath());
            LOG.error(message);
            System.out.println(message);
            return null;
        }
    }

    private static boolean isNullOrNaN(Object val) {
        return val == null || val instanceof Double && Double.isNaN((Double)val) || val instanceof Float && Float.isNaN(((Float)val).floatValue());
    }
}

