/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.model.AbstractColumn;
import org.openforis.collect.relational.model.AbstractTable;
import org.openforis.collect.relational.model.AncestorKeyColumn;
import org.openforis.collect.relational.model.CodeColumn;
import org.openforis.collect.relational.model.CodeLabelColumn;
import org.openforis.collect.relational.model.CodeListCodeColumn;
import org.openforis.collect.relational.model.CodeListDescriptionColumn;
import org.openforis.collect.relational.model.CodeParentKeyColumn;
import org.openforis.collect.relational.model.CodePrimaryKeyColumn;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.CodeValueFKColumn;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.CoordinateLatitudeColumn;
import org.openforis.collect.relational.model.CoordinateLongitudeColumn;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataPrimaryKeyColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.PrimaryKeyConstraint;
import org.openforis.collect.relational.model.ReferentialConstraint;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.RelationalSchemaConfig;
import org.openforis.collect.relational.model.Table;
import org.openforis.collect.relational.sql.RDBJdbcType;
import org.openforis.collect.relational.util.CodeListTables;
import org.openforis.collect.relational.util.Constants;
import org.openforis.collect.relational.util.DataTables;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FieldDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.SurveyContext;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.TimeAttributeDefinition;
import org.openforis.idm.path.Path;
import org.openforis.idm.path.PathElement;

public class RelationalSchemaGenerator {
    private RelationalSchemaConfig config;
    private ColumnNameGenerator columnNameGenerator;

    public RelationalSchemaGenerator() {
        this(RelationalSchemaConfig.createDefault());
    }

    public RelationalSchemaGenerator(RelationalSchemaConfig config) {
        this.config = config;
        this.columnNameGenerator = new ColumnNameGenerator(config.isUniqueColumnNames(), config.getOtherColumnSuffix());
    }

    public RelationalSchema generateSchema(Survey survey, String schemaName) throws CollectRdbException {
        RelationalSchema rs = new RelationalSchema(survey, schemaName);
        this.addCodeListTables(rs);
        this.addDataTables(rs);
        return rs;
    }

    private void addCodeListTables(RelationalSchema rs) throws CollectRdbException {
        Survey survey = rs.getSurvey();
        List codeLists = survey.getCodeLists();
        for (CodeList codeList : codeLists) {
            this.addCodeListTable(rs, codeList);
        }
    }

    private void addDataTables(RelationalSchema rs) throws CollectRdbException {
        Survey survey = rs.getSurvey();
        Schema schema = survey.getSchema();
        List roots = schema.getRootEntityDefinitions();
        for (EntityDefinition root : roots) {
            Path relativePath = Path.relative((String[])new String[]{root.getName()});
            this.addDataObjects(rs, null, (NodeDefinition)root, relativePath);
        }
    }

    private void addCodeListTable(RelationalSchema rs, CodeList codeList) throws CollectRdbException {
        if (!codeList.isExternal()) {
            List hierarchy = codeList.getHierarchy();
            if (hierarchy.size() == 0) {
                CodeTable table = this.createCodeListTable(rs, codeList, null, null);
                rs.addTable(table);
            }
            CodeTable parent = null;
            for (int hierarchyIdx = 0; hierarchyIdx < hierarchy.size(); ++hierarchyIdx) {
                CodeTable table = this.createCodeListTable(rs, codeList, parent, hierarchyIdx);
                rs.addTable(table);
                parent = table;
            }
        }
    }

    protected CodeTable createCodeListTable(RelationalSchema rs, CodeList codeList, CodeTable parent, Integer hierarchyIdx) throws CollectRdbException {
        AbstractColumn col;
        String colName;
        String tableName = CodeListTables.getTableName(this.config, codeList, hierarchyIdx);
        CodeTable table = new CodeTable(this.config.getCodeListTablePrefix(), tableName, codeList, parent, this.config.getDefaultCode(), this.config.getDefaultCodeLabels());
        if (rs.containsTable(tableName)) {
            throw new CollectRdbException("Duplicate table '" + tableName + "' for CodeList " + codeList.getName());
        }
        CodePrimaryKeyColumn pkColumn = new CodePrimaryKeyColumn(CodeListTables.getIdColumnName(this.config, table.getName()));
        table.addColumn(pkColumn);
        this.addPKConstraint(table, pkColumn);
        CodeListCodeColumn codeColumn = new CodeListCodeColumn(CodeListTables.getCodeColumnName(codeList, hierarchyIdx));
        table.addColumn(codeColumn);
        if (parent != null) {
            CodeParentKeyColumn parentIdColumn = new CodeParentKeyColumn(CodeListTables.getIdColumnName(this.config, parent.getName()));
            this.addColumn(table, parentIdColumn);
            String fkConstraintName = this.config.getFkConstraintPrefix() + table.getBaseName() + "_" + parent.getBaseName();
            PrimaryKeyConstraint parentPkConstraint = parent.getPrimaryKeyConstraint();
            ReferentialConstraint fkConstraint = new ReferentialConstraint(fkConstraintName, table, parentPkConstraint, parentIdColumn);
            table.addConstraint(fkConstraint);
        }
        Survey survey = codeList.getSurvey();
        String columnName = CodeListTables.getLabelColumnName(this.config, codeList, hierarchyIdx);
        AbstractColumn col2 = new CodeLabelColumn(survey.getDefaultLanguage(), columnName);
        this.addColumn(table, col2);
        for (String langCode : survey.getLanguages()) {
            colName = CodeListTables.getLabelColumnName(this.config, codeList, hierarchyIdx, langCode);
            col = new CodeLabelColumn(langCode, colName);
            this.addColumn(table, col);
        }
        String colName2 = CodeListTables.getDescriptionColumnName(this.config, codeList, hierarchyIdx);
        col2 = new CodeListDescriptionColumn(survey.getDefaultLanguage(), colName2);
        this.addColumn(table, col2);
        for (String langCode : survey.getLanguages()) {
            colName = CodeListTables.getDescriptionColumnName(this.config, codeList, hierarchyIdx, langCode);
            col = new CodeListDescriptionColumn(langCode, colName);
            table.addColumn(col);
        }
        return table;
    }

    private void addDataObjects(RelationalSchema rs, DataTable table, NodeDefinition defn, Path relativePath) throws CollectRdbException {
        if (defn instanceof EntityDefinition) {
            if (defn.isMultiple()) {
                table = this.createDataTable(rs, table, defn, relativePath);
                rs.addTable(table);
            } else {
                rs.assignAncestorTable((EntityDefinition)defn);
            }
            EntityDefinition entityDefn = (EntityDefinition)defn;
            for (NodeDefinition child : entityDefn.getChildDefinitions()) {
                Path childPath = defn.isMultiple() ? Path.relative((String[])new String[]{child.getName()}) : relativePath.appendElement(child.getName());
                this.addDataObjects(rs, table, child, childPath);
            }
        } else if (defn instanceof AttributeDefinition) {
            AttributeDefinition attrDefn = (AttributeDefinition)defn;
            CollectSurvey survey = (CollectSurvey)defn.getSurvey();
            CollectAnnotations annotations = survey.getAnnotations();
            if (!attrDefn.isCalculated() || annotations.isIncludedInDataExport(defn)) {
                if (defn.isMultiple()) {
                    table = this.createDataTable(rs, table, defn, relativePath);
                    rs.addTable(table);
                    relativePath = Path.relative((String[])new String[]{"."});
                }
                this.addDataColumns(rs, table, (AttributeDefinition)defn, relativePath);
            }
        }
    }

    private DataTable createDataTable(RelationalSchema rs, DataTable parentTable, NodeDefinition defn, Path relativePath) throws CollectRdbException {
        String name = this.generateDataTableName(rs, parentTable, defn);
        DataTable table = new DataTable(this.config.getDataTablePrefix(), name, parentTable, defn, relativePath);
        if (rs.containsTable(name)) {
            throw new CollectRdbException("Duplicate table '" + name + "' for " + defn.getPath());
        }
        this.addPKColumn(table);
        if (this.config.isAncestorKeyColumnsIncluded()) {
            this.addAncestorKeyColumns(table);
        }
        if (parentTable != null) {
            int parentLevel = 1;
            this.addForeignKey(table, parentTable, parentLevel);
            parentTable.addChildTable(table);
            if (this.config.isAncestorFKColumnsIncluded()) {
                List<DataTable> ancestorTables = parentTable.getAncestors();
                for (int i = 0; i < ancestorTables.size(); ++i) {
                    DataTable ancestorTable = ancestorTables.get(i);
                    int level = parentLevel + (i + 1);
                    this.addForeignKey(table, ancestorTable, level);
                    ancestorTable = ancestorTable.getParent();
                }
            }
        }
        return table;
    }

    private void addForeignKey(DataTable fromTable, DataTable toTable, int level) {
        int parentDefId = toTable.getNodeDefinition().getId();
        DataAncestorFKColumn fkColumn = new DataAncestorFKColumn(this.getTablePKColumnName(toTable), parentDefId, level);
        fromTable.addColumn(fkColumn);
        this.addForeignKeyConstraint(fromTable, toTable, fkColumn);
    }

    private void addForeignKeyConstraint(DataTable table, DataTable referencedTable, Column<?> fkColumn) {
        String fkConstraintName = this.config.getFkConstraintPrefix() + table.getBaseName() + "_" + referencedTable.getBaseName();
        PrimaryKeyConstraint referencedTablePKConstraint = referencedTable.getPrimaryKeyConstraint();
        ReferentialConstraint fkConstraint = new ReferentialConstraint(fkConstraintName, table, referencedTablePKConstraint, fkColumn);
        table.addConstraint(fkConstraint);
    }

    protected void addPKColumn(DataTable table) {
        String name = this.getTablePKColumnName(table);
        DataPrimaryKeyColumn pkColumn = new DataPrimaryKeyColumn(name);
        table.addColumn(pkColumn);
        this.addPKConstraint(table, pkColumn);
    }

    private String getTablePKColumnName(AbstractTable<?> table) {
        String result = String.format("%s%s%s", this.config.getIdColumnPrefix(), table.getName(), this.config.getIdColumnSuffix());
        return result;
    }

    protected void addAncestorKeyColumns(DataTable table) throws CollectRdbException {
        NodeDefinition nodeDefn = table.getNodeDefinition();
        List ancestors = nodeDefn.getAncestorEntityDefinitionsInReverseOrder();
        for (int levelIdx = 0; levelIdx < ancestors.size(); ++levelIdx) {
            EntityDefinition ancestor = (EntityDefinition)ancestors.get(levelIdx);
            List keyAttrDefns = ancestor.getKeyAttributeDefinitions();
            for (AttributeDefinition keyDefn : keyAttrDefns) {
                FieldDefinition<?> fieldDefn = this.getKeyAttributeValueFieldDefinition(keyDefn);
                Path fieldRelativePath = this.createAncestorKeyRelativePath(ancestors.size() - levelIdx, fieldDefn);
                String colName = this.getAncestorKeyColumnName(keyDefn);
                AncestorKeyColumn col = new AncestorKeyColumn(colName, fieldDefn, fieldRelativePath);
                this.addColumn(table, col);
            }
        }
    }

    protected FieldDefinition<?> getKeyAttributeValueFieldDefinition(AttributeDefinition defn) {
        FieldDefinition fieldDefn = defn.getMainFieldDefinition();
        if (fieldDefn == null) {
            throw new IllegalArgumentException("Invalid key attribute definition type: " + defn.getClass().getName());
        }
        return fieldDefn;
    }

    protected String getAncestorKeyColumnName(AttributeDefinition keyDefn) {
        NodeDefinition parentDefn = keyDefn.getParentDefinition();
        return parentDefn.getName() + "_" + keyDefn.getName();
    }

    protected Path createAncestorKeyRelativePath(int depth, FieldDefinition<?> field) {
        Path result = Path.relative((String[])new String[]{"."});
        for (int i = 0; i < depth; ++i) {
            result = result.append(new PathElement(".."));
        }
        NodeDefinition parentDefn = field.getParentDefinition();
        result = result.appendElement(parentDefn.getName());
        result = result.appendElement(field.getName());
        return result;
    }

    protected void addPKConstraint(AbstractTable<?> table, Column<?> pkColumn) {
        String pkConstraintName = this.config.getPkConstraintPrefix() + table.getBaseName();
        PrimaryKeyConstraint pkConstraint = new PrimaryKeyConstraint(pkConstraintName, (Table<?>)table, pkColumn);
        table.setPrimaryKeyConstraint(pkConstraint);
    }

    private String generateDataTableName(RelationalSchema rs, DataTable parentTable, NodeDefinition defn) {
        String name = defn.getAnnotation(Constants.TABLE_NAME_QNAME);
        if (name == null) {
            name = defn.getName();
            for (NodeDefinition parent = defn.getParentDefinition(); rs.containsTable(name) && parent != null; parent = parent.getParentDefinition()) {
                name = parent.getName() + "_" + name;
            }
            if (rs.containsTable(name)) {
                throw new RuntimeException(String.format("Unable to generate unique data table name for node definition %s", defn.getPath()));
            }
        }
        return name;
    }

    private void addDataColumns(RelationalSchema rs, DataTable table, AttributeDefinition defn, Path relativePath) throws CollectRdbException {
        if (defn instanceof CodeAttributeDefinition) {
            this.addCodeAttributeDataColumns(rs, table, (CodeAttributeDefinition)defn, relativePath);
        } else if (defn instanceof CoordinateAttributeDefinition) {
            this.addCoordinateAttributeDataColumns(rs, table, (CoordinateAttributeDefinition)defn, relativePath);
        } else if (defn instanceof NumericAttributeDefinition) {
            this.addNumericAttributeDataColumns(table, (NumericAttributeDefinition)defn, relativePath);
        } else if (defn instanceof DateAttributeDefinition || defn instanceof TimeAttributeDefinition) {
            this.addDataColumn(table, (NodeDefinition)defn, relativePath);
            this.addDataColumnsForEachField(table, defn, relativePath);
        } else {
            this.addDataColumnsForEachField(table, defn, relativePath);
        }
    }

    private void addDataColumnsForEachField(DataTable table, AttributeDefinition defn, Path relativePath) throws CollectRdbException {
        for (FieldDefinition field : defn.getFieldDefinitions()) {
            this.addDataColumn(table, field, relativePath);
        }
    }

    private void addCodeAttributeDataColumns(RelationalSchema rs, DataTable table, CodeAttributeDefinition defn, Path relativePath) throws CollectRdbException {
        boolean qualifiable;
        FieldDefinition codeField = defn.getFieldDefinition("code");
        this.addCodeColumn(table, codeField, relativePath);
        CodeList list = defn.getList();
        if (!list.isExternal()) {
            this.addCodeValueFKColumn(rs, table, defn, relativePath);
        }
        if (qualifiable = this.isQualifiable(list)) {
            this.addDataColumn(table, defn.getFieldDefinition("qualifier"), relativePath);
        }
    }

    private void addCoordinateAttributeDataColumns(RelationalSchema rs, DataTable table, CoordinateAttributeDefinition defn, Path relativePath) throws CollectRdbException {
        this.addDataColumnsForEachField(table, (AttributeDefinition)defn, relativePath);
        String baseName = this.columnNameGenerator.generateName((NodeDefinition)defn);
        String latColName = baseName + "_lat";
        CoordinateLatitudeColumn latCol = new CoordinateLatitudeColumn(latColName, defn, relativePath);
        this.addColumn(table, latCol);
        String longColName = baseName + "_long";
        CoordinateLongitudeColumn longCol = new CoordinateLongitudeColumn(longColName, defn, relativePath);
        this.addColumn(table, longCol);
    }

    protected boolean isQualifiable(CodeList list) {
        boolean qualifiable = false;
        if (list.isExternal()) {
            return false;
        }
        if (list.isEmpty()) {
            Survey survey = list.getSurvey();
            SurveyContext context = survey.getContext();
            CodeListService codeListService = context.getCodeListService();
            qualifiable = codeListService.hasQualifiableItems(list);
        } else {
            qualifiable = list.isQualifiable();
        }
        return qualifiable;
    }

    private void addNumericAttributeDataColumns(DataTable table, NumericAttributeDefinition defn, Path relativePath) throws CollectRdbException {
        boolean variableUnit = defn.isVariableUnit();
        for (FieldDefinition field : defn.getFieldDefinitions()) {
            String name = field.getName();
            if (!variableUnit && (name.equals("unit") || name.equals("unit_name"))) continue;
            this.addDataColumn(table, field, relativePath);
        }
    }

    private void addCodeColumn(DataTable table, FieldDefinition<?> defn, Path relativePath) throws CollectRdbException {
        relativePath = relativePath.appendElement(defn.getName());
        String name = this.columnNameGenerator.generateName((NodeDefinition)defn);
        CodeColumn column = new CodeColumn(name, (NodeDefinition)defn, relativePath, this.config.getTextMaxLength(), this.config.getDefaultCode());
        this.addColumn(table, column);
    }

    private void addDataColumn(DataTable table, FieldDefinition<?> defn, Path relativePath) throws CollectRdbException {
        relativePath = relativePath.appendElement(defn.getName());
        this.addDataColumn(table, (NodeDefinition)defn, relativePath);
    }

    private void addDataColumn(DataTable table, NodeDefinition defn, Path relativePath) throws CollectRdbException {
        DataColumn column = this.createDataColumn(table, defn, relativePath);
        this.addColumn(table, column);
    }

    private void addColumn(AbstractTable<?> table, Column<?> column) throws CollectRdbException {
        String name = column.getName();
        if (table.containsColumn(name)) {
            throw new CollectRdbException("Duplicate column '" + name + "' in table '" + table.getName() + "'");
        }
        table.addColumn(column);
    }

    private DataColumn createDataColumn(DataTable table, NodeDefinition defn, Path relativePath) {
        if (defn instanceof FieldDefinition) {
            return this.createDataColumn(table, (FieldDefinition)defn, relativePath);
        }
        if (defn instanceof AttributeDefinition) {
            return this.createDataColumn(table, (AttributeDefinition)defn, relativePath);
        }
        throw new UnsupportedOperationException("Unknown defn " + defn.getClass());
    }

    private void addCodeValueFKColumn(RelationalSchema rs, DataTable table, CodeAttributeDefinition attrDefn, Path relativePath) throws CollectRdbException {
        CodeList list = attrDefn.getList();
        Integer levelIdx = attrDefn.getListLevelIndex();
        String codeListTableName = CodeListTables.getTableName(this.config, list, levelIdx);
        DataColumn codeValueColumn = table.getDataColumn(attrDefn.getFieldDefinition("code"));
        String codeValueColumnName = codeValueColumn.getName();
        String fkColumnName = DataTables.getCodeFKColumnName(this.config, table, attrDefn);
        CodeValueFKColumn col = new CodeValueFKColumn(fkColumnName, attrDefn, relativePath, this.config.getDefaultCode());
        this.addColumn(table, col);
        CodeTable codeListTable = rs.getCodeListTable(list, levelIdx);
        if (codeListTable != null) {
            String fkConstraintName = this.config.getFkConstraintPrefix() + codeValueColumnName + "_" + codeListTableName;
            PrimaryKeyConstraint codeListPkConstraint = codeListTable.getPrimaryKeyConstraint();
            ReferentialConstraint fkConstraint = new ReferentialConstraint(fkConstraintName, table, codeListPkConstraint, col);
            table.addConstraint(fkConstraint);
        }
    }

    private DataColumn createDataColumn(DataTable table, FieldDefinition<?> defn, Path relativePath) {
        String name = this.columnNameGenerator.generateName((NodeDefinition)defn);
        Integer length = RelationalSchemaGenerator.getColumnLength(this.config, defn);
        RDBJdbcType rdbType = RDBJdbcType.fromType(defn.getValueType());
        return new DataColumn(name, rdbType, (NodeDefinition)defn, relativePath, length, true);
    }

    private DataColumn createDataColumn(DataTable table, AttributeDefinition defn, Path relativePath) {
        String name = this.columnNameGenerator.generateName((NodeDefinition)defn);
        RDBJdbcType type = RDBJdbcType.fromCompositeAttributeDefinition(defn);
        return new DataColumn(name, type, (NodeDefinition)defn, relativePath, null, true);
    }

    private static Integer getColumnLength(RelationalSchemaConfig config, FieldDefinition<?> defn) {
        Class type = defn.getValueType();
        if (type == Double.class) {
            return config.getFloatingPointPrecision();
        }
        if (type == String.class) {
            AttributeDefinition attr = defn.getAttributeDefinition();
            if (attr instanceof TextAttributeDefinition) {
                TextAttributeDefinition textAttr = (TextAttributeDefinition)attr;
                if (textAttr.getType() == TextAttributeDefinition.Type.MEMO) {
                    return config.getMemoMaxLength();
                }
                return config.getTextMaxLength();
            }
            return config.getTextMaxLength();
        }
        return null;
    }

    public void setConfig(RelationalSchemaConfig config) {
        this.config = config;
    }

    class ColumnNameGenerator {
        private boolean uniqueNames;
        private String otherColumnSuffix;
        private Set<String> uniqueColumnNames;

        public ColumnNameGenerator(boolean uniqueNames, String otherColumnSuffix) {
            this.uniqueNames = uniqueNames;
            this.otherColumnSuffix = otherColumnSuffix;
            this.uniqueColumnNames = new HashSet<String>();
        }

        public String generateName(NodeDefinition node) {
            AttributeDefinition attr = node instanceof AttributeDefinition ? (AttributeDefinition)node : ((FieldDefinition)node).getAttributeDefinition();
            String baseName = attr.getAnnotation(Constants.COLUMN_NAME_QNAME);
            if (baseName == null) {
                baseName = attr.getName();
            }
            String completeName = this.getCompleteName(node, baseName);
            if (this.uniqueNames) {
                if (this.uniqueColumnNames.contains(completeName)) {
                    for (EntityDefinition parent = attr.getParentEntityDefinition(); parent != null && this.uniqueColumnNames.contains(completeName); parent = parent.getParentEntityDefinition()) {
                        baseName = parent.getName() + "_" + baseName;
                        completeName = this.getCompleteName(node, baseName);
                    }
                }
                if (this.uniqueColumnNames.contains(completeName)) {
                    String tempBaseName = baseName;
                    completeName = this.getCompleteName(node, tempBaseName);
                    int count = 1;
                    while (this.uniqueColumnNames.contains(completeName)) {
                        baseName = tempBaseName + count++;
                        completeName = this.getCompleteName(node, baseName);
                    }
                }
                this.uniqueColumnNames.add(completeName);
            }
            return completeName;
        }

        private String getCompleteName(NodeDefinition node, String baseName) {
            String suffix = node instanceof FieldDefinition ? this.getFieldNameSuffix((FieldDefinition)node) : "";
            return baseName + suffix;
        }

        public String getFieldNameSuffix(FieldDefinition<?> defn) {
            String fldName = defn.getName();
            AttributeDefinition attrDefn = defn.getAttributeDefinition();
            if (attrDefn instanceof BooleanAttributeDefinition || attrDefn instanceof TextAttributeDefinition || attrDefn instanceof CodeAttributeDefinition && fldName.equals("code") || attrDefn instanceof NumberAttributeDefinition && fldName.equals("value")) {
                return "";
            }
            if (attrDefn instanceof CodeAttributeDefinition && fldName.equals("qualifier")) {
                return this.otherColumnSuffix;
            }
            return "_" + fldName;
        }
    }
}

