/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.sql;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.relational.data.DataExtractor;
import org.openforis.collect.relational.data.Row;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.Table;
import org.openforis.collect.relational.print.RDBPrintJob;
import org.openforis.collect.relational.util.SQLUtils;

public abstract class SqlWriter {
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm";
    protected Writer writer;
    protected RelationalSchema schema;
    protected RDBPrintJob.RdbDialect dialect;
    private transient SimpleDateFormat dateFormatter;

    public SqlWriter(Writer writer, RelationalSchema schema) {
        this(writer, schema, RDBPrintJob.RdbDialect.STANDARD, DEFAULT_DATE_TIME_FORMAT);
    }

    public SqlWriter(Writer writer, RelationalSchema schema, RDBPrintJob.RdbDialect dialect, String dateTimeFormat) {
        this.writer = writer;
        this.schema = schema;
        this.dialect = dialect;
        this.dateFormatter = new SimpleDateFormat(dateTimeFormat);
    }

    protected void writeBatchInsert(Table<?> table, DataExtractor extractor) throws IOException {
        if (extractor.hasNext()) {
            this.writer.write("INSERT INTO ");
            this.writer.write(this.getQualifiedName(table));
            this.writer.write(40);
            this.writer.write(StringUtils.join(SQLUtils.doubleQuote(this.getColumnNames(table)), (String)", "));
            this.writer.write(41);
            this.writer.write(" VALUES ");
            this.writer.write(10);
            while (extractor.hasNext()) {
                Row row = extractor.next();
                this.writer.write(9);
                this.writer.write(40);
                List<String> stringValues = this.getStringValues(row);
                this.writer.write(StringUtils.join(stringValues, (String)", "));
                this.writer.write(41);
                if (!extractor.hasNext()) continue;
                this.writer.write(44);
                this.writer.write(10);
            }
            this.writer.write(59);
            this.writer.write(10);
        }
    }

    private List<String> getStringValues(Row row) {
        List<Object> values = row.getValues();
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object val : values) {
            stringValues.add(this.getStringValue(val));
        }
        return stringValues;
    }

    private String getStringValue(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof String) {
            String escapedVal = StringUtils.replace((String)((String)val), (String)"'", (String)"''");
            return SQLUtils.quote(escapedVal);
        }
        if (val instanceof Date) {
            return SQLUtils.quote(this.dateFormatter.format(val));
        }
        return val.toString();
    }

    private List<String> getColumnNames(Table<?> table) {
        List<Column<?>> columns = table.getColumns();
        ArrayList<String> names = new ArrayList<String>();
        for (Column<?> column : columns) {
            names.add(column.getName());
        }
        return names;
    }

    private String getQualifiedName(Table<?> table) {
        StringBuilder sb = new StringBuilder();
        if (!this.isSchemaless()) {
            sb.append(SQLUtils.doubleQuote(this.schema.getName()));
            sb.append('.');
        }
        sb.append(SQLUtils.doubleQuote(table.getName()));
        return sb.toString();
    }

    protected boolean isSchemaless() {
        return this.dialect == RDBPrintJob.RdbDialect.SQLITE;
    }
}

