/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.data;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.Table;

public final class Row {
    private Table<?> table;
    private List<Object> values;

    public Row(Table<?> table) {
        this.table = table;
        int cnt = table.getColumns().size();
        this.values = Arrays.asList(new Object[cnt]);
    }

    public Table<?> getTable() {
        return this.table;
    }

    public List<Object> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValue(int i, Object o) {
        this.values.set(i, o);
    }

    void printDebug(PrintStream out) {
        List<Column<?>> cols = this.table.getColumns();
        out.print(this.table.getName());
        out.print(": ");
        for (int i = 0; i < cols.size(); ++i) {
            if (i > 0) {
                out.print(", ");
            }
            Column<?> col = cols.get(i);
            Object value = this.values.get(i);
            out.printf("%s=%s", col.getName(), value);
        }
        out.println();
    }
}

