/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.data.internal;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.relational.data.internal.DataTableDataColumnValueExtractor;
import org.openforis.collect.relational.model.CodeValueFKColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.SurveyContext;
import org.openforis.idm.model.CodeAttribute;
import org.openforis.idm.model.Field;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.Record;

public class CodeValueFKColumnValueExtractor
extends DataTableDataColumnValueExtractor<CodeValueFKColumn> {
    public CodeValueFKColumnValueExtractor(DataTable table, CodeValueFKColumn column) {
        super(table, column);
    }

    @Override
    public Object extractValue(Node<?> context) {
        CodeAttributeDefinition defn = (CodeAttributeDefinition)((CodeValueFKColumn)this.column).getNodeDefinition();
        Node<?> valNode = super.extractValueNode(context);
        if (valNode != null && valNode instanceof CodeAttribute) {
            return this.extractValue((CodeAttribute)valNode);
        }
        if (((CodeValueFKColumn)this.column).getDefaultCodeValue() != null) {
            ModelVersion version = context.getRecord().getVersion();
            return this.getDefaultCodeItemId(defn.getList(), version);
        }
        return null;
    }

    private Object extractValue(CodeAttribute valNode) {
        Object item = this.findCodeListItem(valNode);
        if (item == null) {
            String defaultCodeValue = ((CodeValueFKColumn)this.column).getDefaultCodeValue();
            String codeValue = this.getCodeValue(valNode);
            if (defaultCodeValue == null || codeValue != null && !codeValue.equals(defaultCodeValue)) {
                return null;
            }
            CodeAttributeDefinition definition = (CodeAttributeDefinition)valNode.getDefinition();
            CodeList list = definition.getList();
            Record record = valNode.getRecord();
            ModelVersion version = record.getVersion();
            return this.getDefaultCodeItemId(list, version);
        }
        return item.getId();
    }

    private String getCodeValue(CodeAttribute attr) {
        if (attr == null) {
            return null;
        }
        Field codeField = attr.getCodeField();
        return (String)codeField.getValue();
    }

    private <T extends CodeListItem> T findCodeListItem(CodeAttribute attr) {
        String code = this.getCodeValue(attr);
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CodeListService codeListService = this.getCodeListService((CollectSurvey)attr.getSurvey());
        CodeListItem item = codeListService.loadItem(attr);
        return (T)item;
    }

    private Integer getDefaultCodeItemId(CodeList list, ModelVersion version) {
        CodeListService codeListService = this.getCodeListService((CollectSurvey)list.getSurvey());
        CodeListItem defaultCodeItem = codeListService.loadRootItem(list, ((CodeValueFKColumn)this.column).getDefaultCodeValue(), version);
        return defaultCodeItem == null ? -1 : defaultCodeItem.getId();
    }

    private CodeListService getCodeListService(CollectSurvey survey) {
        SurveyContext context = survey.getContext();
        CodeListService codeListService = context.getCodeListService();
        return codeListService;
    }
}

