/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.DatabaseExporter;
import org.openforis.collect.relational.jooq.JooqDatabaseExporter;
import org.openforis.collect.relational.jooq.JooqRelationalSchemaCreator;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.RelationalSchemaConfig;
import org.openforis.collect.relational.model.RelationalSchemaGenerator;
import org.openforis.commons.collection.Visitor;
import org.openforis.concurrency.ProcessProgressListener;
import org.openforis.concurrency.ProcessStepProgressListener;
import org.openforis.concurrency.Progress;
import org.openforis.concurrency.ProgressListener;
import org.openforis.idm.metamodel.Survey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CollectRDBPublisher {
    protected static final Logger LOG = LogManager.getLogger(CollectRDBPublisher.class);
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private RecordManager recordManager;
    @Autowired
    private DataSource dataSource;
    @Autowired(required=false)
    @Qualifier(value="rdbDataSource")
    private DataSource rdbDataSource;

    public void export(String surveyName, String rootEntityName, CollectRecord.Step step, String targetSchemaName) throws CollectRdbException {
        this.export(surveyName, rootEntityName, step, targetSchemaName, RelationalSchemaConfig.createDefault());
    }

    public void export(String surveyName, String rootEntityName, CollectRecord.Step step, String targetSchemaName, RelationalSchemaConfig config) throws CollectRdbException {
        Connection targetConn = this.getTargetConnection();
        this.export(surveyName, rootEntityName, step, targetSchemaName, targetConn, config);
    }

    public void export(String surveyName, String rootEntityName, CollectRecord.Step step, String targetSchemaName, RelationalSchemaConfig config, ProgressListener progressListener) throws CollectRdbException {
        Connection targetConn = this.getTargetConnection();
        this.export(surveyName, rootEntityName, step, targetSchemaName, targetConn, config, progressListener);
    }

    public void export(String surveyName, String rootEntityName, CollectRecord.Step step, String targetSchemaName, Connection targetConn, RelationalSchemaConfig config) throws CollectRdbException {
        this.export(surveyName, rootEntityName, step, targetSchemaName, targetConn, config, null);
    }

    public void export(String surveyName, String rootEntityName, CollectRecord.Step step, String targetSchemaName, Connection targetConn, RelationalSchemaConfig config, ProgressListener progressListener) throws CollectRdbException {
        try {
            targetConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            CollectSurvey survey = this.surveyManager.get(surveyName);
            RelationalSchemaGenerator schemaGenerator = new RelationalSchemaGenerator(config);
            RelationalSchema relationalSchema = schemaGenerator.generateSchema((Survey)survey, targetSchemaName);
            JooqRelationalSchemaCreator relationalSchemaCreator = this.createRelationalSchemaCreator();
            relationalSchemaCreator.createRelationalSchema(relationalSchema, targetConn);
            relationalSchemaCreator.addConstraints(relationalSchema, targetConn);
            relationalSchemaCreator.addIndexes(relationalSchema, targetConn);
            this.insertData(survey, rootEntityName, step, targetConn, relationalSchema, progressListener);
            targetConn.commit();
            if (LOG.isInfoEnabled()) {
                LOG.info("RDB generation completed");
            }
        }
        catch (Exception e) {
            try {
                targetConn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    private void insertData(final CollectSurvey survey, String rootEntityName, final CollectRecord.Step step, Connection targetConn, RelationalSchema relationalSchema, ProgressListener progressListener) throws IOException {
        RecordFilter recordFilter = new RecordFilter(survey);
        recordFilter.setRootEntityId(Integer.valueOf(survey.getSchema().getRootEntityDefinition(rootEntityName).getId()));
        recordFilter.setStepGreaterOrEqual(step);
        final int total = this.recordManager.countRecords(recordFilter);
        if (LOG.isInfoEnabled()) {
            LOG.info("Total records: " + total);
        }
        final DatabaseExporter databaseExporter = this.createDatabaseExporter(relationalSchema, targetConn);
        ProcessProgressListener totalProgressListener = new ProcessProgressListener(2);
        databaseExporter.insertReferenceData((ProgressListener)new ProcessStepProgressListener(totalProgressListener, progressListener));
        final ProcessStepProgressListener insertRecordsProgressListener = new ProcessStepProgressListener(totalProgressListener, progressListener);
        final AtomicInteger count = new AtomicInteger();
        this.recordManager.visitSummaries(recordFilter, null, (Visitor)new Visitor<CollectRecordSummary>(){

            public void visit(CollectRecordSummary summary) {
                try {
                    CollectRecord record = CollectRDBPublisher.this.recordManager.load(survey, summary.getId().intValue(), step, false);
                    databaseExporter.insertRecordData(record, ProgressListener.NULL_PROGRESS_LISTENER);
                }
                catch (CollectRdbException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                insertRecordsProgressListener.progressMade(new Progress((long)count.addAndGet(1), (long)total));
            }
        });
        databaseExporter.close();
        if (LOG.isInfoEnabled()) {
            LOG.info("All records exported");
            LOG.info("Adding constraints and indexes...");
        }
    }

    private Connection getTargetConnection() {
        DataSource targetDataSource = this.rdbDataSource == null ? this.dataSource : this.rdbDataSource;
        Connection targetConn = DataSourceUtils.getConnection((DataSource)targetDataSource);
        return targetConn;
    }

    private JooqRelationalSchemaCreator createRelationalSchemaCreator() {
        return new JooqRelationalSchemaCreator();
    }

    private DatabaseExporter createDatabaseExporter(RelationalSchema schema, Connection targetConn) {
        return new JooqDatabaseExporter(schema, targetConn);
    }
}

