/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import org.openforis.collect.relational.model.AbstractColumn;
import org.openforis.collect.relational.sql.RDBJdbcType;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.FieldDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.model.Node;
import org.openforis.idm.path.Path;

public class DataColumn
extends AbstractColumn<Node<?>> {
    private Object defaultValue;
    private NodeDefinition nodeDefinition;
    private Path relativePath;

    protected static Integer getFieldLength(FieldDefinition<?> defn) {
        Class type = defn.getValueType();
        return DataColumn.getFieldLength(type);
    }

    protected static Integer getFieldLength(Class<?> type) {
        if (type == Integer.class) {
            return null;
        }
        if (type == Double.class) {
            return 24;
        }
        if (type == String.class) {
            return 255;
        }
        throw new UnsupportedOperationException("Unknown field type " + type);
    }

    DataColumn(String name, RDBJdbcType type, NodeDefinition defn, Path relPath, Integer length, boolean nullable) {
        this(name, type, defn, relPath, length, nullable, null);
    }

    DataColumn(String name, RDBJdbcType type, NodeDefinition defn, Path relPath, Integer length, boolean nullable, Object defaultValue) {
        super(name, type, length, nullable);
        this.nodeDefinition = defn;
        this.relativePath = relPath;
        this.defaultValue = defaultValue;
    }

    public NodeDefinition getNodeDefinition() {
        return this.nodeDefinition;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public AttributeDefinition getAttributeDefinition() {
        AttributeDefinition attributeDefn;
        if (this.nodeDefinition == null) {
            return null;
        }
        if (this.nodeDefinition instanceof AttributeDefinition) {
            attributeDefn = (AttributeDefinition)this.nodeDefinition;
        } else if (this.nodeDefinition instanceof FieldDefinition) {
            attributeDefn = (AttributeDefinition)this.nodeDefinition.getParentDefinition();
        } else {
            throw new IllegalStateException("Invalid node definition, expected AttributeDefinition or FieldDefinition, found: " + this.nodeDefinition.getClass().getName());
        }
        return attributeDefn;
    }
}

