/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.sql;

import java.util.Date;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.TimeAttributeDefinition;

public enum RDBJdbcType {
    INTEGER(4, "integer", Integer.class),
    FLOAT(6, "float", Double.class),
    BIGINT(-5, "bigint", Long.class),
    BOOLEAN(16, "boolean", Boolean.class),
    VARCHAR(12, "varchar", String.class),
    DATE(91, "date", Date.class),
    TIME(92, "time", Date.class);

    private int code;
    private String name;
    private Class<?> javaType;

    public static RDBJdbcType fromType(Class<?> type) {
        if (type == Integer.class) {
            return INTEGER;
        }
        if (type == Double.class) {
            return FLOAT;
        }
        if (type == Long.class) {
            return BIGINT;
        }
        if (type == Boolean.class) {
            return BOOLEAN;
        }
        if (type == String.class) {
            return VARCHAR;
        }
        throw new UnsupportedOperationException("Unknown field type " + type);
    }

    public static RDBJdbcType fromCompositeAttributeDefinition(AttributeDefinition defn) {
        if (defn instanceof DateAttributeDefinition) {
            return DATE;
        }
        if (defn instanceof TimeAttributeDefinition) {
            return TIME;
        }
        throw new UnsupportedOperationException("Unsupported composite attribute definition: " + defn.getClass());
    }

    private RDBJdbcType(int code, String name, Class<?> javaType) {
        this.code = code;
        this.name = name;
        this.javaType = javaType;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }
}

