/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.model.AbstractTable;
import org.openforis.collect.relational.model.CodeValueFKColumn;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataPrimaryKeyColumn;
import org.openforis.collect.relational.model.PrimaryKeyConstraint;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FieldDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.model.Node;
import org.openforis.idm.path.Path;

public class DataTable
extends AbstractTable<Node<?>> {
    private NodeDefinition definition;
    private Path relativePath;
    private DataTable parent;
    private List<DataTable> childTables;
    private Map<Integer, CodeValueFKColumn> foreignKeyCodeColumns;
    private Map<Integer, DataAncestorFKColumn> ancestorFKColumnsByDefinitionId;
    private DataAncestorFKColumn parentFKColumn;

    DataTable(String prefix, String name, DataTable parent, NodeDefinition defn, Path relativePath) throws CollectRdbException {
        super(prefix, name);
        this.definition = defn;
        this.parent = parent;
        this.relativePath = relativePath;
        this.childTables = new ArrayList<DataTable>();
        this.foreignKeyCodeColumns = new HashMap<Integer, CodeValueFKColumn>();
        this.ancestorFKColumnsByDefinitionId = new HashMap<Integer, DataAncestorFKColumn>();
    }

    @Override
    void addColumn(Column<?> column) {
        super.addColumn(column);
        if (column instanceof CodeValueFKColumn) {
            int attrDefnId = ((CodeValueFKColumn)column).getAttributeDefinition().getId();
            this.foreignKeyCodeColumns.put(attrDefnId, (CodeValueFKColumn)column);
        }
        if (column instanceof DataAncestorFKColumn) {
            DataAncestorFKColumn ancestorFKColumn = (DataAncestorFKColumn)column;
            this.ancestorFKColumnsByDefinitionId.put(ancestorFKColumn.getAncestorDefinitionId(), ancestorFKColumn);
            if (ancestorFKColumn.isParentFKColumn()) {
                this.parentFKColumn = ancestorFKColumn;
            }
        }
    }

    public DataAncestorFKColumn getRecordIdColumn() {
        EntityDefinition rootEntityDef = this.definition.getRootEntity();
        return this.getAncestorFKColumn(rootEntityDef.getId());
    }

    public Collection<DataAncestorFKColumn> getAncestorFKColumns() {
        return this.ancestorFKColumnsByDefinitionId.values();
    }

    public DataAncestorFKColumn getAncestorFKColumn(int definitionId) {
        DataAncestorFKColumn column = this.ancestorFKColumnsByDefinitionId.get(definitionId);
        if (column == null) {
            throw new IllegalStateException("No ancestor id column found in table " + this.getName() + " for definition id " + definitionId);
        }
        return column;
    }

    public CodeValueFKColumn getForeignKeyCodeColumn(CodeAttributeDefinition defn) {
        return this.foreignKeyCodeColumns.get(defn.getId());
    }

    public NodeDefinition getNodeDefinition() {
        return this.definition;
    }

    public void print(PrintStream out) {
        out.printf("%-43s%s\n", this.getName() + ":", this.getRelativePath());
        for (Column col : this.getColumns()) {
            Integer length = col.getLength();
            String path = "";
            if (col instanceof DataColumn) {
                DataColumn dcol = (DataColumn)col;
                path = dcol.getRelativePath() + "";
            }
            out.printf("\t%-35s%-8s%-8s%s\n", col.getName(), col.getType().getCode(), length == null ? "" : length, path);
        }
        out.flush();
    }

    public List<DataColumn> getDataColumns(AttributeDefinition attributeDefinition) {
        ArrayList<DataColumn> result = new ArrayList<DataColumn>();
        int attributeDefinitionId = attributeDefinition.getId();
        for (Column column : this.getColumns()) {
            DataColumn dataCol;
            AttributeDefinition columnAttrDefn;
            if (!(column instanceof DataColumn) || (columnAttrDefn = (dataCol = (DataColumn)column).getAttributeDefinition()).getId() != attributeDefinitionId || dataCol instanceof CodeValueFKColumn) continue;
            result.add(dataCol);
        }
        return result;
    }

    public DataColumn getDataColumn(FieldDefinition<?> fieldDefinition) {
        AttributeDefinition attributeDefinition = (AttributeDefinition)fieldDefinition.getParentDefinition();
        List<DataColumn> attributeDataColumns = this.getDataColumns(attributeDefinition);
        String fieldDefinitionName = fieldDefinition.getName();
        for (DataColumn column : attributeDataColumns) {
            NodeDefinition columnNodeDefn = column.getNodeDefinition();
            if (!(columnNodeDefn instanceof FieldDefinition) || !columnNodeDefn.getName().equals(fieldDefinitionName)) continue;
            return column;
        }
        return null;
    }

    public List<DataTable> getAncestors() {
        ArrayList<DataTable> result = new ArrayList<DataTable>();
        for (DataTable ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            result.add(ancestor);
        }
        return result;
    }

    public DataTable getParent() {
        return this.parent;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    void addChildTable(DataTable table) {
        this.childTables.add(table);
    }

    public List<DataTable> getChildTables() {
        return this.childTables;
    }

    public DataPrimaryKeyColumn getPrimaryKeyColumn() {
        PrimaryKeyConstraint pkConstraint = this.getPrimaryKeyConstraint();
        return (DataPrimaryKeyColumn)pkConstraint.getPrimaryKeyColumn();
    }

    public DataAncestorFKColumn getParentFKColumn() {
        return this.parentFKColumn;
    }

    public void setParentFKColumn(DataAncestorFKColumn parentFKColumn) {
        this.parentFKColumn = parentFKColumn;
    }
}

