/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational.jooq;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertValuesStepN;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectConditionStep;
import org.jooq.TableLike;
import org.jooq.Update;
import org.jooq.UpdateConditionStep;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.persistence.jooq.CollectDSLContext;
import org.openforis.collect.persistence.jooq.JooqDaoSupport;
import org.openforis.collect.relational.DatabaseExporter;
import org.openforis.collect.relational.RDBUpdater;
import org.openforis.collect.relational.data.ColumnValuePair;
import org.openforis.collect.relational.data.DataExtractor;
import org.openforis.collect.relational.data.DataExtractorFactory;
import org.openforis.collect.relational.data.Row;
import org.openforis.collect.relational.data.internal.CodeTableDataExtractor;
import org.openforis.collect.relational.data.internal.DataTableDataExtractor;
import org.openforis.collect.relational.model.CodeTable;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.DataAncestorFKColumn;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataPrimaryKeyColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.Table;
import org.openforis.concurrency.Progress;
import org.openforis.concurrency.ProgressListener;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;

public class JooqDatabaseExporter
implements RDBUpdater,
DatabaseExporter,
Closeable {
    private static final Logger LOG = LogManager.getLogger(JooqDatabaseExporter.class);
    private CollectDSLContext dsl;
    private RelationalSchema schema;
    private BatchQueryExecutor batchExecutor;

    public JooqDatabaseExporter(RelationalSchema schema, Connection connection) {
        this(schema, new CollectDSLContext(connection));
    }

    public JooqDatabaseExporter(RelationalSchema schema, Configuration conf) {
        this(schema, new CollectDSLContext(conf));
    }

    public JooqDatabaseExporter(RelationalSchema schema, CollectDSLContext dsl) {
        this.schema = schema;
        this.dsl = dsl;
        this.batchExecutor = new BatchQueryExecutor(schema, ProgressListener.NULL_PROGRESS_LISTENER);
    }

    @Override
    public void insertReferenceData(ProgressListener progressListener) {
        List<CodeTable> codeListTables = this.schema.getCodeListTables();
        long totalItems = codeListTables.size();
        long processedItems = 0L;
        for (CodeTable codeTable : codeListTables) {
            CodeTableDataExtractor extractor = DataExtractorFactory.getExtractor(codeTable);
            this.batchExecutor.executeInserts(extractor);
            progressListener.progressMade(new Progress(++processedItems, totalItems));
        }
    }

    @Override
    public void insertRecordData(CollectRecord record, ProgressListener progressListener) {
        for (DataTable table : this.schema.getDataTables()) {
            DataExtractor extractor = DataExtractorFactory.getRecordDataExtractor(table, record);
            this.batchExecutor.addInserts(extractor);
        }
    }

    @Override
    public void insertEntity(int recordId, Integer parentId, int entityId, int entityDefinitionId) {
        this.insertNode(recordId, parentId, entityId, entityDefinitionId);
    }

    @Override
    public void insertAttribute(int recordId, Integer parentId, int attributeId, int attributeDefinitionId) {
        this.insertNode(recordId, parentId, attributeId, attributeDefinitionId);
    }

    private void insertNode(int recordId, Integer parentId, int nodeId, int nodeDefinitionId) {
        DataTable table = this.schema.getDataTableByDefinitionId(nodeDefinitionId);
        NodeDefinition nodeDef = table.getNodeDefinition();
        BigInteger pkValue = DataTableDataExtractor.getTableArtificialPK(recordId, nodeDef, nodeId);
        QueryCreator queryCreator = new QueryCreator(this.dsl, this.schema.getName());
        DataPrimaryKeyColumn pkColumn = table.getPrimaryKeyColumn();
        org.jooq.Table jooqTable = queryCreator.getJooqTable(table);
        InsertSetMoreStep insert = this.dsl.insertInto(jooqTable).set(DSL.field((String)pkColumn.getName()), (Object)pkValue);
        if (parentId != null) {
            Map<String, BigInteger> ancestorFKByColumnName = this.findAncestorFKByColumnName(this.schema, table, recordId, parentId);
            for (Map.Entry<String, BigInteger> entry : ancestorFKByColumnName.entrySet()) {
                insert.set(DSL.field((String)entry.getKey()), (Object)entry.getValue());
            }
        }
        try {
            insert.execute();
        }
        catch (DataAccessException e) {
            if (JooqDaoSupport.isConstraintViolation((DataAccessException)e)) {
                LOG.warn(String.format("Duplicate node already inserted: survey = %s, node path = %s, record id = %d, parent id = %d, node id = %d", this.schema.getSurvey().getName(), nodeDef.getPath(), recordId, parentId, nodeId));
            }
            throw new DataAccessException("Failed to insert node into RDB", (Throwable)e);
        }
    }

    private Map<String, BigInteger> findAncestorFKByColumnName(RelationalSchema schema, DataTable table, int recordId, int parentId) {
        HashMap<String, BigInteger> result = new HashMap<String, BigInteger>();
        DataTable parentTable = table.getParent();
        ArrayList<DataAncestorFKColumn> parentAncestorFKColumns = new ArrayList<DataAncestorFKColumn>(parentTable.getAncestorFKColumns());
        List<Field<?>> parentAncestorColumns = this.toFields(parentAncestorFKColumns);
        BigInteger parentPKValue = DataTableDataExtractor.getTableArtificialPK(recordId, parentTable.getNodeDefinition(), parentId);
        DataPrimaryKeyColumn parentPKColumn = parentTable.getPrimaryKeyColumn();
        QueryCreator queryCreator = new QueryCreator(this.dsl, schema.getName());
        SelectConditionStep selectAncestorFKs = this.dsl.select(parentAncestorColumns).from((TableLike)queryCreator.getJooqTable(parentTable)).where(new Condition[]{DSL.field((String)parentPKColumn.getName()).eq((Object)parentPKValue)});
        Record record = selectAncestorFKs.fetchOne();
        for (int i = 0; i < parentAncestorColumns.size(); ++i) {
            Field<?> parentAncestorField = parentAncestorColumns.get(i);
            DataAncestorFKColumn parentColumn = (DataAncestorFKColumn)parentAncestorFKColumns.get(i);
            int ancestorDefinitionId = parentColumn.getAncestorDefinitionId();
            DataAncestorFKColumn column = table.getAncestorFKColumn(ancestorDefinitionId);
            BigInteger ancestorPK = (BigInteger)record.getValue(parentAncestorField, BigInteger.class);
            result.put(column.getName(), ancestorPK);
        }
        result.put(table.getParentFKColumn().getName(), parentPKValue);
        return result;
    }

    private List<Field<?>> toFields(List<? extends Column<?>> columns) {
        ArrayList fields = new ArrayList(columns.size());
        for (Column<?> column : columns) {
            fields.add(DSL.field((Name)DSL.name((String[])new String[]{column.getName()}), (DataType)this.dsl.getDataType(column.getType().getJavaType())));
        }
        return fields;
    }

    @Override
    public void replaceRecordData(CollectRecord record, ProgressListener progressListener) {
        this.deleteRecordData(record.getId(), ((EntityDefinition)record.getRootEntity().getDefinition()).getId());
        this.insertRecordData(record, progressListener);
    }

    @Override
    public void updateEntityData(DataTable dataTable, BigInteger pkValue, List<ColumnValuePair<DataColumn, ?>> columnValuePairs) {
        this.batchExecutor.addUpdate(dataTable, pkValue, columnValuePairs);
    }

    @Override
    public void deleteRecordData(int recordId, int rootDefId) {
        this.deleteEntity(recordId, recordId, rootDefId);
    }

    @Override
    public void deleteEntity(int recordId, int entityId, int entityDefinitionId) {
        DataTable tableToDeleteFor = this.schema.getDataTableByDefinitionId(entityDefinitionId);
        EntityDefinition entityDefToDeleteFor = (EntityDefinition)tableToDeleteFor.getNodeDefinition();
        BigInteger pkValue = DataTableDataExtractor.getTableArtificialPK(recordId, (NodeDefinition)entityDefToDeleteFor, entityId);
        this.batchExecutor.addDelete(tableToDeleteFor, tableToDeleteFor.getPrimaryKeyColumn(), pkValue);
        ArrayList<? extends DataTable> descendantTables = new ArrayList<DataTable>(this.schema.getDescendantTablesForDefinition(entityDefinitionId));
        Collections.reverse(descendantTables);
        for (DataTable dataTable : descendantTables) {
            DataAncestorFKColumn ancestorIdColumn = dataTable.getAncestorFKColumn(entityDefinitionId);
            this.batchExecutor.addDelete(dataTable, ancestorIdColumn, pkValue);
        }
    }

    @Override
    public void deleteAttribute(int recordId, int attributeId, int definitionId) {
        DataTable tableToDeleteFor = this.schema.getDataTableByDefinitionId(definitionId);
        NodeDefinition defToDeleteFor = tableToDeleteFor.getNodeDefinition();
        BigInteger pkValue = DataTableDataExtractor.getTableArtificialPK(recordId, defToDeleteFor, attributeId);
        this.batchExecutor.addDelete(tableToDeleteFor, tableToDeleteFor.getPrimaryKeyColumn(), pkValue);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.batchExecutor);
    }

    private class QueryCreator {
        private final CollectDSLContext dsl;
        private final String schemaName;

        public QueryCreator(CollectDSLContext dsl, String schemaName) {
            this.dsl = dsl;
            this.schemaName = schemaName;
        }

        public InsertValuesStepN<Record> createInsertQuery(Row row) {
            Table<?> table = row.getTable();
            InsertValuesStepN<Record> insert = this.createInsertQuery(table);
            List<Object> values = row.getValues();
            insert.values(values);
            return insert;
        }

        public InsertValuesStepN<Record> createInsertQuery(Table<?> table) {
            List fields = JooqDatabaseExporter.this.toFields(table.getColumns());
            InsertValuesStepN insert = this.dsl.insertInto(this.getJooqTable(table), (Collection)fields);
            return insert;
        }

        public Update<Record> createUpdateQuery(DataTable table, BigInteger pkValue, Map<Field<?>, Object> fieldToValue) {
            DataPrimaryKeyColumn pkColumn = table.getPrimaryKeyColumn();
            Field pkField = DSL.field((String)pkColumn.getName());
            UpdateConditionStep query = this.dsl.update(this.getJooqTable(table)).set(fieldToValue).where(new Condition[]{pkField.eq((Object)pkValue)});
            return query;
        }

        public DeleteQuery<Record> createDeleteQuery(Table<?> table, Column<?> pkColumn, BigInteger pkValue) {
            org.jooq.Table<Record> jooqTable = this.getJooqTable(table);
            Field jooqPKColumn = DSL.field((String)pkColumn.getName(), BigInteger.class);
            DeleteQuery query = this.dsl.deleteQuery(jooqTable);
            query.addConditions(new Condition[]{jooqPKColumn.equal((Object)pkValue)});
            return query;
        }

        private org.jooq.Table<Record> getJooqTable(Table<?> table) {
            if (this.isSchemaLess()) {
                return DSL.table((Name)DSL.name((String[])new String[]{table.getName()}));
            }
            return DSL.table((Name)DSL.name((String[])new String[]{this.schemaName, table.getName()}));
        }

        private boolean isSchemaLess() {
            return this.dsl.configuration().dialect() == SQLDialect.SQLITE;
        }
    }

    private class BatchQueryExecutor
    implements Closeable {
        private static final int BATCH_MAX_SIZE = 500;
        private List<Query> queries;
        private QueryCreator queryCreator;
        private ProgressListener progressListener;
        private long processedQueries;

        public BatchQueryExecutor(RelationalSchema schema, ProgressListener progressListener) {
            this.progressListener = progressListener;
            this.queries = new ArrayList<Query>();
            this.queryCreator = new QueryCreator(JooqDatabaseExporter.this.dsl, schema.getName());
        }

        public void addInserts(DataExtractor extractor) {
            while (extractor.hasNext()) {
                Row row = extractor.next();
                this.addInsert(row);
            }
        }

        public void executeInserts(DataExtractor extractor) {
            Table<?> table = extractor.getTable();
            Object[] valuesPlaceholders = new Object[table.getColumns().size()];
            InsertValuesStepN insertQuery = this.queryCreator.createInsertQuery(table).values(valuesPlaceholders);
            BatchBindStep batch = JooqDatabaseExporter.this.dsl.batch((Query)insertQuery);
            while (extractor.hasNext()) {
                Row row = extractor.next();
                batch.bind(row.getValues().toArray(new Object[row.getValues().size()]));
            }
            batch.execute();
        }

        public void addInsert(Row row) {
            this.addQuery((Query)this.queryCreator.createInsertQuery(row));
        }

        public void addUpdate(DataTable table, BigInteger pkValue, List<ColumnValuePair<DataColumn, ?>> columnValuePairs) {
            HashMap fieldToValue = new HashMap(columnValuePairs.size());
            for (ColumnValuePair<DataColumn, ?> columnValuePair : columnValuePairs) {
                Field field = DSL.field((String)columnValuePair.getColumn().getName());
                Object value = columnValuePair.getValue();
                fieldToValue.put(field, value);
            }
            Update<Record> query = this.queryCreator.createUpdateQuery(table, pkValue, fieldToValue);
            this.addQuery((Query)query);
        }

        public void addDelete(Table<?> table, Column<?> pkColumn, BigInteger pkValue) {
            this.addQuery((Query)this.queryCreator.createDeleteQuery(table, pkColumn, pkValue));
        }

        private void addQuery(Query query) {
            this.queries.add(query);
            if (this.queries.size() == 500) {
                this.flush();
            }
        }

        public void flush() {
            if (this.queries.isEmpty()) {
                return;
            }
            try {
                JooqDatabaseExporter.this.dsl.batch(this.queries).execute();
                this.processedQueries += (long)this.queries.size();
                this.queries.clear();
                this.notifyProgressListener();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        private void notifyProgressListener() {
            if (this.progressListener != null) {
                this.progressListener.progressMade(new Progress(this.processedQueries, 0L));
            }
        }
    }
}

