/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.datacleansing.DataCleansingChain;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryEvaluator;
import org.openforis.collect.datacleansing.xpath.XPathDataQueryEvaluator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.concurrency.Task;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.model.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Scope(value="prototype")
public class DataCleansingChainExectutorTask
extends Task {
    @Autowired
    private RecordManager recordManager;
    private DataCleansingChainExecutorTaskInput input;
    private List<DataQueryExecutorError> errors;
    private int cleansedRecords;
    private int cleansedNodes;
    private int datasetSize;
    private Date lastRecordModifiedDate;

    protected long countTotalItems() {
        RecordFilter recordsFilter = this.createRecordsFilter();
        int count = this.recordManager.countRecords(recordsFilter);
        return count;
    }

    protected void initializeInternalVariables() throws Throwable {
        super.initializeInternalVariables();
        this.cleansedRecords = 0;
        this.cleansedNodes = 0;
        this.errors = new ArrayList<DataQueryExecutorError>();
    }

    protected void onCompleted() {
        super.onCompleted();
        IOUtils.closeQuietly((Closeable)this.input.nodeProcessor);
    }

    @Transactional
    protected void execute() throws Throwable {
        CollectSurvey survey = (CollectSurvey)this.input.chain.getSurvey();
        RecordFilter filter = this.createRecordsFilter();
        List recordSummaries = this.recordManager.loadSummaries(filter);
        this.datasetSize = recordSummaries.size();
        this.lastRecordModifiedDate = null;
        TreeSet<Integer> recordIdsToBeDeleted = new TreeSet<Integer>();
        Iterator it = recordSummaries.iterator();
        while (it.hasNext() && this.isRunning()) {
            CollectRecordSummary recordSummary = (CollectRecordSummary)it.next();
            this.udpateLastRecordModifiedDate(recordSummary);
            CollectRecord record = this.recordManager.load(survey, recordSummary.getId().intValue(), this.input.step, false);
            boolean recordCleansed = false;
            for (DataCleansingStep step : this.input.chain.getSteps()) {
                DataCleansingStepExecutionResult stepExecutionResult = this.executeStep(record, step);
                if (stepExecutionResult == null) continue;
                recordCleansed = true;
                if (stepExecutionResult != DataCleansingStepExecutionResult.RECORD_TO_BE_DELETED) continue;
                recordIdsToBeDeleted.add(record.getId());
                break;
            }
            if (recordCleansed) {
                ++this.cleansedRecords;
            }
            this.incrementProcessedItems();
        }
        this.recordManager.deleteByIds(recordIdsToBeDeleted);
    }

    private DataCleansingStepExecutionResult executeStep(CollectRecord record, DataCleansingStep step) {
        DataCleansingStepExecutionResult result = null;
        DataQueryEvaluator queryEvaluator = this.createQueryEvaluator(step.getQuery());
        List<Node<?>> nodes = queryEvaluator.evaluate(record);
        for (Node<?> node : nodes) {
            DataCleansingStepNodeProcessorResult processResult = this.processNode(step, node);
            if (processResult != null) {
                switch (processResult) {
                    case ATTRIBUTE_UPDATED: 
                    case ENTITY_DELETED: {
                        ++this.cleansedNodes;
                        result = DataCleansingStepExecutionResult.RECORD_UPDATED;
                        break;
                    }
                    case RECORD_TO_BE_DELETED: {
                        result = DataCleansingStepExecutionResult.RECORD_TO_BE_DELETED;
                    }
                }
            }
            if (processResult != DataCleansingStepNodeProcessorResult.RECORD_TO_BE_DELETED) continue;
            break;
        }
        return result;
    }

    private void udpateLastRecordModifiedDate(CollectRecordSummary recordSummary) {
        Date modifiedDate = recordSummary.getModifiedDate();
        if (this.lastRecordModifiedDate == null || this.lastRecordModifiedDate.compareTo(modifiedDate) < 0) {
            this.lastRecordModifiedDate = modifiedDate;
        }
    }

    private DataCleansingStepNodeProcessorResult processNode(DataCleansingStep step, Node<?> node) {
        try {
            return this.input.nodeProcessor.process(step, node);
        }
        catch (Exception e) {
            this.log().error((Object)String.format("Error executing cleansing step %s", step.getId()), (Throwable)e);
            CollectRecord record = (CollectRecord)node.getRecord();
            this.errors.add(new DataQueryExecutorError(record.getRootEntityKeyValues(), record.getId(), node.getPath(), e.getMessage()));
            return null;
        }
    }

    private RecordFilter createRecordsFilter() {
        CollectSurvey survey = (CollectSurvey)this.input.chain.getSurvey();
        EntityDefinition rootEntityDef = survey.getSchema().getFirstRootEntityDefinition();
        Integer rootEntityId = rootEntityDef.getId();
        RecordFilter filter = new RecordFilter(survey);
        filter.setStep(this.input.step);
        filter.setRootEntityId(rootEntityId);
        filter.setOffset(Integer.valueOf(0));
        filter.setMaxNumberOfRecords(this.input.maxRecords);
        return filter;
    }

    private DataQueryEvaluator createQueryEvaluator(DataQuery query) {
        return new XPathDataQueryEvaluator(query);
    }

    public DataCleansingChainExecutorTaskInput getInput() {
        return this.input;
    }

    public void setInput(DataCleansingChainExecutorTaskInput input) {
        this.input = input;
    }

    public int getCleansedNodes() {
        return this.cleansedNodes;
    }

    public int getCleansedRecords() {
        return this.cleansedRecords;
    }

    public int getDatasetSize() {
        return this.datasetSize;
    }

    public Date getLastRecordModifiedDate() {
        return this.lastRecordModifiedDate;
    }

    public static enum DataCleansingStepExecutionResult {
        RECORD_UPDATED,
        RECORD_TO_BE_DELETED;

    }

    public static enum DataCleansingStepNodeProcessorResult {
        ATTRIBUTE_UPDATED,
        ENTITY_DELETED,
        RECORD_TO_BE_DELETED;

    }

    public static interface DataCleansingStepNodeProcessor
    extends Closeable {
        public DataCleansingStepNodeProcessorResult process(DataCleansingStep var1, Node<?> var2) throws Exception;
    }

    public static class DataCleansingChainExecutorTaskInput {
        private DataCleansingChain chain;
        private CollectRecord.Step step;
        private Integer maxRecords;
        private DataCleansingStepNodeProcessor nodeProcessor;

        public DataCleansingChainExecutorTaskInput(DataCleansingChain chain, CollectRecord.Step step, DataCleansingStepNodeProcessor nodeProcessor) {
            this(chain, step, nodeProcessor, null);
        }

        public DataCleansingChainExecutorTaskInput(DataCleansingChain chain, CollectRecord.Step step, DataCleansingStepNodeProcessor nodeProcessor, Integer maxRecords) {
            this.chain = chain;
            this.step = step;
            this.nodeProcessor = nodeProcessor;
            this.maxRecords = maxRecords;
        }

        public DataCleansingChain getChain() {
            return this.chain;
        }

        public void setChain(DataCleansingChain chain) {
            this.chain = chain;
        }

        public CollectRecord.Step getStep() {
            return this.step;
        }

        public void setStep(CollectRecord.Step step) {
            this.step = step;
        }

        public Integer getMaxRecords() {
            return this.maxRecords;
        }

        public void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DataCleansingStepNodeProcessor getNodeProcessor() {
            return this.nodeProcessor;
        }

        public void setNodeProcessor(DataCleansingStepNodeProcessor nodeProcessor) {
            this.nodeProcessor = nodeProcessor;
        }
    }

    public static class DataQueryExecutorError {
        private List<String> recordKeys;
        private int recordId;
        private String attributePath;
        private String errorMessage;

        public DataQueryExecutorError(List<String> recordKeys, int recordId, String attributePath, String errorMessage) {
            this.recordKeys = recordKeys;
            this.recordId = recordId;
            this.attributePath = attributePath;
            this.errorMessage = errorMessage;
        }

        public int getRecordId() {
            return this.recordId;
        }

        public List<String> getRecordKeys() {
            return this.recordKeys;
        }

        public String getAttributePath() {
            return this.attributePath;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

