/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.datacleansing.DataCleansingStep;
import org.openforis.collect.datacleansing.DataCleansingStepValue;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.form.DataCleansingItemForm;

public class DataCleansingStepForm
extends DataCleansingItemForm<DataCleansingStep> {
    private Integer queryId;
    private String title;
    private String description;
    private String typeCode;
    private List<DataCleansingStepValue> updateValues;
    private String queryTitle;
    private String queryDescription;

    public DataCleansingStepForm() {
        this.updateValues = new ArrayList<DataCleansingStepValue>();
    }

    public DataCleansingStepForm(DataCleansingStep step) {
        super(step);
        DataQuery query = step.getQuery();
        if (query != null) {
            this.queryTitle = step == null ? null : query.getTitle();
            this.queryDescription = step == null ? null : query.getDescription();
        }
        List<DataCleansingStepValue> values = step.getUpdateValues();
        this.updateValues = new ArrayList<DataCleansingStepValue>(values);
        this.typeCode = String.valueOf(step.getType().getCode());
    }

    public DataCleansingStep.DataCleansingStepType getType() {
        return StringUtils.isBlank((CharSequence)this.typeCode) ? DataCleansingStep.DataCleansingStepType.ATTRIBUTE_UPDATE : DataCleansingStep.DataCleansingStepType.fromCode(this.typeCode.charAt(0));
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public String getQueryDescription() {
        return this.queryDescription;
    }

    public Integer getQueryId() {
        return this.queryId;
    }

    public void setQueryId(Integer queryId) {
        this.queryId = queryId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public List<DataCleansingStepValue> getUpdateValues() {
        return this.updateValues;
    }

    public void setUpdateValues(List<DataCleansingStepValue> values) {
        this.updateValues = values;
    }
}

