/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.VersionableItemFormObject;
import org.openforis.idm.metamodel.CodeListItem;

public class CodeListItemFormObject
extends VersionableItemFormObject<CodeListItem> {
    private static final String DEFAULT_COLOR = "000000";
    private String code;
    private String label;
    private String description;
    private boolean qualifiable;
    private String color;
    private String defaultLabel;
    private String defaultDescription;

    @Override
    public void loadFrom(CodeListItem source, String languageCode) {
        super.loadFrom(source, languageCode);
        this.code = source.getCode();
        this.label = source.getLabel(languageCode);
        this.description = source.getDescription(languageCode);
        this.qualifiable = source.isQualifiable();
        String sourceColor = source.getColor();
        this.color = sourceColor == null ? DEFAULT_COLOR : sourceColor;
        this.defaultLabel = source.getLabel();
        this.defaultDescription = source.getDescription();
    }

    @Override
    public void saveTo(CodeListItem dest, String languageCode) {
        super.saveTo(dest, languageCode);
        dest.setCode(StringUtils.trimToNull((String)this.code));
        dest.setLabel(languageCode, StringUtils.trimToNull((String)this.label));
        dest.setDescription(languageCode, StringUtils.trimToNull((String)this.description));
        dest.setQualifiable(Boolean.valueOf(this.qualifiable));
        dest.setColor(this.color == null || this.color.equals(DEFAULT_COLOR) ? null : this.color);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isQualifiable() {
        return this.qualifiable;
    }

    public void setQualifiable(boolean qualifiable) {
        this.qualifiable = qualifiable;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }
}

