/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.designer.form.BooleanAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.CodeAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.CoordinateAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.DateAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.EntityDefinitionFormObject;
import org.openforis.collect.designer.form.FileAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.NumberAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.RangeAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.TaxonAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.TextAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.TimeAttributeDefinitionFormObject;
import org.openforis.collect.designer.form.VersionableItemFormObject;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.designer.metamodel.NodeType;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.Calculable;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.Prompt;

public abstract class NodeDefinitionFormObject<T extends NodeDefinition>
extends VersionableItemFormObject<T> {
    public static final String MULTIPLE_FIELD = "multiple";
    public static final String REQUIRED_FIELD = "required";
    private EntityDefinition parentDefinition;
    private String name;
    private String description;
    private boolean multiple;
    private String requirenessType;
    private String requiredWhenExpression;
    private String relevanceType;
    private String relevantExpression;
    private boolean hideWhenNotRelevant;
    private String minCountExpression;
    private String maxCountExpression;
    private boolean autoGenerateMinItems;
    private boolean calculated;
    private boolean includeInDataExport;
    private boolean showInUI;
    private boolean calculatedOnlyOneTime;
    private boolean fromCollectEarthCSV;
    private boolean includedInCollectEarthHeader;
    private boolean showReadOnlyFieldInCollectEarth;
    private boolean hideKeyInCollectEarthRecordList;
    protected boolean key;
    protected boolean measurement;
    protected boolean qualifier;
    protected boolean showInSummary;
    private String headingLabel;
    private String instanceLabel;
    private String numberLabel;
    private String abbreviatedLabel;
    private String reportingLabel;
    private String interviewPromptLabel;
    private String paperPromptLabel;
    private String handheldPromptLabel;
    private String pcPromptLabel;
    private String defaultInstanceLabel;
    private String defaultHeadingLabel;
    private String defaultDescription;
    private String tabName;
    private int column;
    private int columnSpan;
    private Integer width;
    private Integer labelWidth;
    private String labelOrientation;
    private String backgroundColor;
    private Integer backgroundTransparency;

    NodeDefinitionFormObject() {
    }

    NodeDefinitionFormObject(EntityDefinition parentDefn) {
        this.parentDefinition = parentDefn;
    }

    public static NodeDefinitionFormObject<? extends NodeDefinition> newInstance(EntityDefinition parentDefn, NodeType nodeType, AttributeType attributeType) {
        if (nodeType == null) {
            return null;
        }
        switch (nodeType) {
            case ENTITY: {
                return new EntityDefinitionFormObject(parentDefn);
            }
            case ATTRIBUTE: {
                return NodeDefinitionFormObject.newInstance(parentDefn, attributeType);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + ((Object)((Object)nodeType)).getClass().getName());
    }

    public static AttributeDefinitionFormObject<?> newInstance(EntityDefinition parentDefn, AttributeType attributeType) {
        if (attributeType != null) {
            switch (attributeType) {
                case BOOLEAN: {
                    return new BooleanAttributeDefinitionFormObject(parentDefn);
                }
                case CODE: {
                    return new CodeAttributeDefinitionFormObject(parentDefn);
                }
                case COORDINATE: {
                    return new CoordinateAttributeDefinitionFormObject(parentDefn);
                }
                case DATE: {
                    return new DateAttributeDefinitionFormObject(parentDefn);
                }
                case FILE: {
                    return new FileAttributeDefinitionFormObject(parentDefn);
                }
                case NUMBER: {
                    return new NumberAttributeDefinitionFormObject(parentDefn);
                }
                case RANGE: {
                    return new RangeAttributeDefinitionFormObject(parentDefn);
                }
                case TAXON: {
                    return new TaxonAttributeDefinitionFormObject(parentDefn);
                }
                case TEXT: {
                    return new TextAttributeDefinitionFormObject(parentDefn);
                }
                case TIME: {
                    return new TimeAttributeDefinitionFormObject(parentDefn);
                }
            }
            throw new IllegalStateException("Attribute type not supported");
        }
        return null;
    }

    @Override
    public void loadFrom(T source, String language) {
        super.loadFrom(source, language);
        CollectSurvey survey = (CollectSurvey)source.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        this.name = source.getName();
        this.multiple = source.isMultiple();
        if (source.isAlwaysRequired()) {
            this.requirenessType = RequirenessType.ALWAYS_REQUIRED.name();
        } else {
            this.requiredWhenExpression = source.extractRequiredExpression();
            this.requirenessType = this.requiredWhenExpression == null ? RequirenessType.NOT_REQUIRED.name() : RequirenessType.REQUIRED_WHEN.name();
        }
        this.relevanceType = source.getRelevantExpression() == null ? RelevanceType.ALWAYS_RELEVANT.name() : RelevanceType.RELEVANT_WHEN.name();
        this.relevantExpression = source.getRelevantExpression();
        this.minCountExpression = source.getMinCountExpression();
        this.maxCountExpression = this.multiple ? source.getMaxCountExpression() : null;
        this.headingLabel = source.getLabel(NodeLabel.Type.HEADING, language);
        this.instanceLabel = source.getLabel(NodeLabel.Type.INSTANCE, language);
        this.numberLabel = source.getLabel(NodeLabel.Type.NUMBER, language);
        this.abbreviatedLabel = source.getLabel(NodeLabel.Type.ABBREVIATED, language);
        this.reportingLabel = source.getLabel(NodeLabel.Type.REPORTING, language);
        this.interviewPromptLabel = source.getPrompt(Prompt.Type.INTERVIEW, language);
        this.paperPromptLabel = source.getPrompt(Prompt.Type.PAPER, language);
        this.handheldPromptLabel = source.getPrompt(Prompt.Type.HANDHELD, language);
        this.pcPromptLabel = source.getPrompt(Prompt.Type.PC, language);
        this.description = source.getDescription(language);
        this.defaultInstanceLabel = source.getLabel(NodeLabel.Type.INSTANCE);
        this.defaultHeadingLabel = source.getLabel(NodeLabel.Type.HEADING);
        this.defaultDescription = source.getDescription();
        this.hideWhenNotRelevant = uiOptions.isHideWhenNotRelevant(source);
        this.column = uiOptions.getColumn(source);
        this.columnSpan = uiOptions.getColumnSpan(source);
        this.width = uiOptions.getWidth(source);
        this.labelWidth = uiOptions.getLabelWidth(source);
        this.labelOrientation = uiOptions.getLabelOrientation(source).name();
        CollectAnnotations annotations = survey.getAnnotations();
        this.autoGenerateMinItems = annotations.isAutoGenerateMinItems(source);
        if (source instanceof AttributeDefinition) {
            this.fromCollectEarthCSV = annotations.isFromCollectEarthCSV((AttributeDefinition)source);
            this.includedInCollectEarthHeader = annotations.isIncludedInCollectEarthHeader((AttributeDefinition)source);
            this.showReadOnlyFieldInCollectEarth = annotations.isShowReadOnlyFieldInCollectEarth((AttributeDefinition)source);
            this.hideKeyInCollectEarthRecordList = annotations.isHideKeyInCollectEarthRecordList((AttributeDefinition)source);
            this.showInSummary = annotations.isShowInSummary((AttributeDefinition)source);
            this.qualifier = annotations.isQualifier((AttributeDefinition)source);
        }
        if (source instanceof Calculable) {
            this.calculated = ((Calculable)source).isCalculated();
            this.showInUI = !uiOptions.isHidden(source);
            this.includeInDataExport = annotations.isIncludedInDataExport(source);
            this.calculatedOnlyOneTime = annotations.isCalculatedOnlyOneTime(source);
        }
        this.backgroundColor = annotations.getBackgroundColor(source);
        this.backgroundTransparency = NodeDefinitionFormObject.fromAlphaToTransparency(annotations.getBackgroundAlpha(source));
    }

    @Override
    public void saveTo(T dest, String languageCode) {
        super.saveTo(dest, languageCode);
        if (!this.name.equals(dest.getName())) {
            dest.rename(this.name);
        }
        dest.setLabel(NodeLabel.Type.HEADING, languageCode, this.headingLabel);
        dest.setLabel(NodeLabel.Type.INSTANCE, languageCode, this.instanceLabel);
        dest.setLabel(NodeLabel.Type.NUMBER, languageCode, this.numberLabel);
        dest.setLabel(NodeLabel.Type.ABBREVIATED, languageCode, this.abbreviatedLabel);
        dest.setLabel(NodeLabel.Type.REPORTING, languageCode, this.reportingLabel);
        dest.setPrompt(Prompt.Type.HANDHELD, languageCode, this.handheldPromptLabel);
        dest.setPrompt(Prompt.Type.INTERVIEW, languageCode, this.interviewPromptLabel);
        dest.setPrompt(Prompt.Type.PAPER, languageCode, this.paperPromptLabel);
        dest.setPrompt(Prompt.Type.PC, languageCode, this.pcPromptLabel);
        dest.setDescription(languageCode, this.description);
        dest.setMinCountExpression(null);
        dest.setMaxCountExpression(null);
        dest.setRequiredExpression(null);
        CollectSurvey survey = (CollectSurvey)dest.getSurvey();
        CollectAnnotations annotations = survey.getAnnotations();
        annotations.setAutoGenerateMinItems(dest, this.isMultiple() && StringUtils.isNotBlank((CharSequence)this.getMinCountExpression()) && this.autoGenerateMinItems);
        if (dest instanceof EntityDefinition && this.parentDefinition == null) {
            dest.setMultiple(true);
        } else if (!(dest instanceof AttributeDefinition) || !this.calculated) {
            dest.setMultiple(this.multiple);
            if (this.multiple) {
                dest.setMinCountExpression(StringUtils.trimToNull((String)this.minCountExpression));
                dest.setMaxCountExpression(StringUtils.trimToNull((String)this.maxCountExpression));
            } else {
                RequirenessType requirenessTypeEnum = RequirenessType.valueOf(this.requirenessType);
                switch (requirenessTypeEnum) {
                    case ALWAYS_REQUIRED: {
                        dest.setAlwaysRequired();
                        break;
                    }
                    case REQUIRED_WHEN: {
                        dest.setRequiredExpression(StringUtils.trimToNull((String)this.requiredWhenExpression));
                        break;
                    }
                }
            }
        }
        UIOptions uiOptions = survey.getUIOptions();
        RelevanceType relevanceTypeEnum = RelevanceType.valueOf(this.relevanceType);
        switch (relevanceTypeEnum) {
            case RELEVANT_WHEN: {
                dest.setRelevantExpression(StringUtils.trimToNull((String)this.relevantExpression));
                uiOptions.setHideWhenNotRelevant(dest, this.hideWhenNotRelevant);
                break;
            }
            default: {
                dest.setRelevantExpression(null);
                uiOptions.setHideWhenNotRelevant(dest, false);
            }
        }
        if (dest instanceof AttributeDefinition) {
            AttributeDefinition attrDef = (AttributeDefinition)dest;
            annotations.setFromCollectEarthCSV(attrDef, this.fromCollectEarthCSV);
            annotations.setIncludedInCollectEarthHeader(attrDef, this.fromCollectEarthCSV && this.includedInCollectEarthHeader);
            annotations.setShowReadOnlyFieldInCollectEarth(attrDef, this.fromCollectEarthCSV && this.showReadOnlyFieldInCollectEarth);
            annotations.setHideKeyInCollectEarthRecordList(attrDef, this.fromCollectEarthCSV && this.hideKeyInCollectEarthRecordList);
            annotations.setShowInSummary(attrDef, this.showInSummary);
            annotations.setQualifier(attrDef, this.qualifier);
        }
        uiOptions.setColumn(dest, this.column);
        uiOptions.setColumnSpan(dest, this.columnSpan);
        uiOptions.setWidth(dest, this.width);
        uiOptions.setLabelWidth(dest, this.labelWidth);
        uiOptions.setLabelOrientation(dest, UIOptions.Orientation.valueOf((String)this.labelOrientation));
        if (dest instanceof Calculable) {
            ((Calculable)dest).setCalculated(this.calculated);
            annotations.setIncludeInDataExport(dest, this.includeInDataExport);
            uiOptions.setHidden(dest, !this.showInUI);
            annotations.setCalculatedOnlyOneTime(dest, this.calculatedOnlyOneTime);
        }
        annotations.setBackgroundColor(dest, this.backgroundColor);
        annotations.setBackgroundAlpha(dest, Double.valueOf(NodeDefinitionFormObject.fromTransparencyToAlpha(this.backgroundTransparency)));
    }

    @Override
    protected void reset() {
        this.calculated = false;
        this.showInUI = true;
        this.includeInDataExport = true;
    }

    protected UIOptions getUIOptions(NodeDefinition nodeDefn) {
        CollectSurvey survey = (CollectSurvey)nodeDefn.getSurvey();
        UIOptions uiOptions = survey.getUIOptions();
        return uiOptions;
    }

    public void setParentDefinition(EntityDefinition parentDefinition) {
        this.parentDefinition = parentDefinition;
    }

    private static int fromAlphaToTransparency(double backgroundAlpha) {
        return Double.valueOf(Math.floor(100.0 * (1.0 - backgroundAlpha))).intValue();
    }

    private static double fromTransparencyToAlpha(int transparency) {
        return 1.0 - (double)transparency / 100.0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    public boolean isQualifier() {
        return this.qualifier;
    }

    public void setQualifier(boolean qualifier) {
        this.qualifier = qualifier;
    }

    public boolean isShowInSummary() {
        return this.showInSummary;
    }

    public void setShowInSummary(boolean showInSummary) {
        this.showInSummary = showInSummary;
    }

    public boolean isIncludeInDataExport() {
        return this.includeInDataExport;
    }

    public void setIncludeInDataExport(boolean includeInDataExport) {
        this.includeInDataExport = includeInDataExport;
    }

    public boolean isShowInUI() {
        return this.showInUI;
    }

    public void setShowInUI(boolean showInUI) {
        this.showInUI = showInUI;
    }

    public boolean isCalculatedOnlyOneTime() {
        return this.calculatedOnlyOneTime;
    }

    public void setCalculatedOnlyOneTime(boolean calculatedOnlyOneTime) {
        this.calculatedOnlyOneTime = calculatedOnlyOneTime;
    }

    public String getHeadingLabel() {
        return this.headingLabel;
    }

    public void setHeadingLabel(String headingLabel) {
        this.headingLabel = headingLabel;
    }

    public String getInstanceLabel() {
        return this.instanceLabel;
    }

    public void setInstanceLabel(String instanceLabel) {
        this.instanceLabel = instanceLabel;
    }

    public String getNumberLabel() {
        return this.numberLabel;
    }

    public void setNumberLabel(String numberLabel) {
        this.numberLabel = numberLabel;
    }

    public String getAbbreviatedLabel() {
        return this.abbreviatedLabel;
    }

    public void setAbbreviatedLabel(String abbreviatedLabel) {
        this.abbreviatedLabel = abbreviatedLabel;
    }

    public String getReportingLabel() {
        return this.reportingLabel;
    }

    public void setReportingLabel(String reportingLabel) {
        this.reportingLabel = reportingLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public String getInterviewPromptLabel() {
        return this.interviewPromptLabel;
    }

    public void setInterviewPromptLabel(String interviewPromptLabel) {
        this.interviewPromptLabel = interviewPromptLabel;
    }

    public String getPaperPromptLabel() {
        return this.paperPromptLabel;
    }

    public void setPaperPromptLabel(String paperPromptLabel) {
        this.paperPromptLabel = paperPromptLabel;
    }

    public String getHandheldPromptLabel() {
        return this.handheldPromptLabel;
    }

    public void setHandheldPromptLabel(String handheldPromptLabel) {
        this.handheldPromptLabel = handheldPromptLabel;
    }

    public String getPcPromptLabel() {
        return this.pcPromptLabel;
    }

    public void setPcPromptLabel(String pcPromptLabel) {
        this.pcPromptLabel = pcPromptLabel;
    }

    public String getRequirenessType() {
        return this.requirenessType;
    }

    public void setRequirenessType(String requirenessType) {
        this.requirenessType = requirenessType;
    }

    public String getRequiredWhenExpression() {
        return this.requiredWhenExpression;
    }

    public void setRequiredWhenExpression(String requiredWhenExpression) {
        this.requiredWhenExpression = requiredWhenExpression;
    }

    public String getRelevanceType() {
        return this.relevanceType;
    }

    public void setRelevanceType(String relevanceType) {
        this.relevanceType = relevanceType;
    }

    public String getRelevantExpression() {
        return this.relevantExpression;
    }

    public void setRelevantExpression(String relevantExpression) {
        this.relevantExpression = relevantExpression;
    }

    public boolean isHideWhenNotRelevant() {
        return this.hideWhenNotRelevant;
    }

    public void setHideWhenNotRelevant(boolean hideWhenNotRelevant) {
        this.hideWhenNotRelevant = hideWhenNotRelevant;
    }

    public String getMinCountExpression() {
        return this.minCountExpression;
    }

    public void setMinCountExpression(String expression) {
        this.minCountExpression = expression;
    }

    public String getMaxCountExpression() {
        return this.maxCountExpression;
    }

    public void setMaxCountExpression(String expression) {
        this.maxCountExpression = expression;
    }

    public boolean isAutoGenerateMinItems() {
        return this.autoGenerateMinItems;
    }

    public void setAutoGenerateMinItems(boolean autoGenerateMinItems) {
        this.autoGenerateMinItems = autoGenerateMinItems;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public void setColumnSpan(int columnSpan) {
        this.columnSpan = columnSpan;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(Integer labelWidth) {
        this.labelWidth = labelWidth;
    }

    public String getLabelOrientation() {
        return this.labelOrientation;
    }

    public void setLabelOrientation(String labelOrientation) {
        this.labelOrientation = labelOrientation;
    }

    public boolean isFromCollectEarthCSV() {
        return this.fromCollectEarthCSV;
    }

    public void setFromCollectEarthCSV(boolean fromCollectEarthCSV) {
        this.fromCollectEarthCSV = fromCollectEarthCSV;
    }

    public boolean isIncludedInCollectEarthHeader() {
        return this.includedInCollectEarthHeader;
    }

    public void setIncludedInCollectEarthHeader(boolean showReadOnlyFieldInCollectEarth) {
        this.includedInCollectEarthHeader = showReadOnlyFieldInCollectEarth;
    }

    public boolean isShowReadOnlyFieldInCollectEarth() {
        return this.showReadOnlyFieldInCollectEarth;
    }

    public void setShowReadOnlyFieldInCollectEarth(boolean showReadOnlyFieldInCollectEarth) {
        this.showReadOnlyFieldInCollectEarth = showReadOnlyFieldInCollectEarth;
    }

    public boolean isHideKeyInCollectEarthRecordList() {
        return this.hideKeyInCollectEarthRecordList;
    }

    public void setHideKeyInCollectEarthRecordList(boolean hideKeyInCollectEarthRecordList) {
        this.hideKeyInCollectEarthRecordList = hideKeyInCollectEarthRecordList;
    }

    public String getDefaultInstanceLabel() {
        return this.defaultInstanceLabel;
    }

    public String getDefaultHeadingLabel() {
        return this.defaultHeadingLabel;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public boolean isMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(boolean measurement) {
        this.measurement = measurement;
    }

    public Integer getBackgroundTransparency() {
        return this.backgroundTransparency;
    }

    public void setBackgroundTransparency(Integer backgroundTransparency) {
        this.backgroundTransparency = backgroundTransparency;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static enum RelevanceType {
        ALWAYS_RELEVANT,
        RELEVANT_WHEN;

    }

    public static enum RequirenessType {
        NOT_REQUIRED,
        ALWAYS_REQUIRED,
        REQUIRED_WHEN;

    }
}

