/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form.validator;

import org.openforis.collect.designer.form.validator.FormValidator;
import org.openforis.collect.designer.viewmodel.SurveyObjectBaseVM;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.model.species.Taxonomy;
import org.zkoss.bind.ValidationContext;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.select.annotation.WireVariable;

public class TaxonomyFormValidator
extends FormValidator {
    protected static final String NAME_FIELD = "name";
    @WireVariable
    private SpeciesManager speciesManager;

    @Override
    protected void internalValidate(ValidationContext ctx) {
        this.validateName(ctx);
    }

    protected boolean validateName(ValidationContext ctx) {
        boolean result = this.validateRequired(ctx, NAME_FIELD);
        if (result && (result = this.validateInternalName(ctx, NAME_FIELD))) {
            result = this.validateNameUniqueness(ctx);
        }
        return result;
    }

    protected boolean validateNameUniqueness(ValidationContext ctx) {
        SurveyObjectBaseVM viewModel = (SurveyObjectBaseVM)this.getVM(ctx);
        Taxonomy editedItem = (Taxonomy)viewModel.getEditedItem();
        CollectSurvey survey = viewModel.getSurvey();
        String name = (String)this.getValue(ctx, NAME_FIELD);
        Taxonomy existingItem = survey.getContext().getSpeciesListService().loadTaxonomyByName((Survey)survey, name);
        if (existingItem != null && existingItem.getId() != editedItem.getId()) {
            String message = Labels.getLabel((String)"global.item.validation.name_already_defined");
            this.addInvalidMessage(ctx, NAME_FIELD, message);
            return false;
        }
        return true;
    }
}

