/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.FieldSymbol;
import org.openforis.collect.model.proxy.NodeUpdateRequestProxy;
import org.openforis.collect.remoting.service.NodeUpdateRequest;
import org.openforis.idm.model.Attribute;
import org.openforis.idm.model.Field;

public class FieldUpdateRequestProxy
extends NodeUpdateRequestProxy<NodeUpdateRequest.FieldUpdateRequest<?>> {
    private Integer nodeId;
    private int fieldIndex;
    protected String value;
    protected String remarks;
    protected FieldSymbol symbol;

    @Override
    public NodeUpdateRequest.FieldUpdateRequest<?> toNodeUpdateRequest(CollectRecord record) {
        return this.toFieldUpdateRequest(record);
    }

    protected <T> NodeUpdateRequest.FieldUpdateRequest<T> toFieldUpdateRequest(CollectRecord record) {
        NodeUpdateRequest.FieldUpdateRequest<Object> req = new NodeUpdateRequest.FieldUpdateRequest<Object>();
        Attribute attribute = (Attribute)record.getNodeByInternalId(this.nodeId.intValue());
        Field field = attribute.getField(this.fieldIndex);
        req.setField(field);
        Object parsedValue = field.parseValue(this.value);
        req.setValue(parsedValue);
        req.setSymbol(this.symbol);
        req.setRemarks(this.remarks);
        return req;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public FieldSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(FieldSymbol symbol) {
        this.symbol = symbol;
    }
}

