/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service.recordindex;

import java.io.Closeable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.openforis.collect.manager.RecordIndexException;
import org.openforis.collect.manager.RecordIndexManager;
import org.openforis.collect.model.CollectRecord;

public class VolatileRecordIndexManager
extends RecordIndexManager {
    private static final long serialVersionUID = 1L;

    public synchronized boolean init() throws RecordIndexException {
        this.initIndexDirectory();
        this.initialized = true;
        return this.initialized;
    }

    protected Directory createIndexDirectory() throws RecordIndexException {
        RAMDirectory directory = new RAMDirectory();
        return directory;
    }

    public void index(CollectRecord record) throws RecordIndexException {
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createIndexWriter();
            this.clean(indexWriter);
            this.index(indexWriter, record);
        }
        catch (Exception e) {
            throw new RecordIndexException((Throwable)e);
        }
        finally {
            this.close((Closeable)indexWriter);
        }
    }

    private void clean(IndexWriter indexWriter) {
        try {
            indexWriter.deleteAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

