/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.dataexport.codelist.CodeListExportProcess;
import org.openforis.collect.metamodel.view.CodeListItemView;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Controllers;
import org.openforis.collect.web.manager.RecordProviderSession;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.model.Entity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api"})
public class CodeListController {
    private static final String CSV_EXTENSION = ".csv";
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CodeListManager codeListManager;
    @Autowired
    private RecordProviderSession recordProviderSession;

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}.csv"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportCodeListWork(HttpServletResponse response, @PathVariable(value="surveyId") Integer surveyId, @PathVariable(value="codeListId") Integer codeListId) throws IOException {
        return this.exportCodeList(response, surveyId, codeListId);
    }

    @RequestMapping(value={"survey/{surveyId}/codelist/{codeListId}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CodeListItemView> loadAvailableItems(@PathVariable Integer surveyId, @PathVariable Integer codeListId, @RequestParam(required=false) Integer recordId, @RequestParam CollectRecord.Step recordStep, @RequestParam String parentEntityPath, @RequestParam Integer codeAttrDefId) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId.intValue());
        CollectRecord record = this.recordProviderSession.provide(survey, recordId, recordStep);
        Entity parentEntity = (Entity)record.findNodeByPath(parentEntityPath);
        CodeAttributeDefinition codeAttrDef = (CodeAttributeDefinition)survey.getSchema().getDefinitionById(codeAttrDefId.intValue());
        List items = this.codeListManager.loadValidItems(parentEntity, codeAttrDef);
        return this.toViews(items);
    }

    protected String exportCodeList(HttpServletResponse response, int surveyId, int codeListId) throws IOException {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        CodeList list = survey.getCodeListById(codeListId);
        String fileName = list.getName() + CSV_EXTENSION;
        Controllers.setOutputContent(response, fileName, "text/csv");
        ServletOutputStream out = response.getOutputStream();
        CodeListExportProcess process = new CodeListExportProcess(this.codeListManager);
        process.exportToCSV((OutputStream)out, survey, codeListId);
        return "ok";
    }

    private List<CodeListItemView> toViews(List<CodeListItem> items) {
        ArrayList<CodeListItemView> views = new ArrayList<CodeListItemView>(items.size());
        for (CodeListItem item : items) {
            CodeListItemView view = new CodeListItemView();
            view.setCode(item.getCode());
            view.setLabel(item.getLabel());
            views.add(view);
        }
        return views;
    }
}

