/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openforis.collect.command.AddAttributeCommand;
import org.openforis.collect.command.AddEntityCommand;
import org.openforis.collect.command.Command;
import org.openforis.collect.command.CommandDispatcher;
import org.openforis.collect.command.CreateRecordCommand;
import org.openforis.collect.command.CreateRecordPreviewCommand;
import org.openforis.collect.command.DeleteNodeCommand;
import org.openforis.collect.command.DeleteRecordCommand;
import org.openforis.collect.command.NodeCommand;
import org.openforis.collect.command.RecordCommand;
import org.openforis.collect.command.UpdateAttributeCommand;
import org.openforis.collect.command.UpdateBooleanAttributeCommand;
import org.openforis.collect.command.UpdateCodeAttributeCommand;
import org.openforis.collect.command.UpdateDateAttributeCommand;
import org.openforis.collect.command.UpdateNumericAttributeCommand;
import org.openforis.collect.command.UpdateTextAttributeCommand;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.Response;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/command"})
public class CommandController {
    @Autowired
    private CommandDispatcher commandDispatcher;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AppWS appWS;

    @RequestMapping(value={"record"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response createRecord(@RequestBody CreateRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record_preview"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public List<RecordEventView> createRecordPreview(@RequestBody CreateRecordPreviewCommand command) {
        return this.submitCommandSync((Command)command);
    }

    @RequestMapping(value={"record"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response deleteRecord(@RequestBody DeleteRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attribute/new"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addAttribute(@RequestBody AddAttributeCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attributes"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addOrUpdateAttributes(@RequestBody UpdateAttributesCommandWrapper commandsWrapper) {
        commandsWrapper.commands.forEach(c -> {
            UpdateAttributeCommand command = c.toCommand();
            this.submitCommand((Command)command);
        });
        return new Response();
    }

    @RequestMapping(value={"record/attribute"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object updateAttribute(@RequestBody UpdateAttributeCommandWrapper commandWrapper) {
        UpdateAttributeCommand command = commandWrapper.toCommand();
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/entity"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object addEntity(@RequestBody AddEntityCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/node"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteNode(@RequestBody DeleteNodeCommand command) {
        return this.submitCommand((Command)command);
    }

    private Response submitCommand(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        this.commandDispatcher.submit(command, new EventListener(){

            public void onEvent(RecordEvent event) {
                CommandController.this.appWS.sendMessage(new AppWS.RecordEventMessage(new RecordEventView(event)));
            }
        });
        return new Response();
    }

    private List<RecordEventView> submitCommandSync(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        List events = this.commandDispatcher.submitSync(command);
        ArrayList<RecordEventView> result = new ArrayList<RecordEventView>(events.size());
        for (RecordEvent event : events) {
            result.add(new RecordEventView(event));
        }
        return result;
    }

    static class UpdateAttributeCommandWrapper
    extends UpdateAttributeCommand {
        private static final long serialVersionUID = 1L;
        AttributeType attributeType;
        Map<String, Object> valueByField;

        UpdateAttributeCommandWrapper() {
        }

        void setValueInCommand(NodeCommand c) {
            switch (this.attributeType) {
                case BOOLEAN: {
                    ((UpdateBooleanAttributeCommand)c).setValue((Boolean)this.valueByField.get("value"));
                    break;
                }
                case CODE: {
                    ((UpdateCodeAttributeCommand)c).setCode((String)this.valueByField.get("code"));
                    break;
                }
                case DATE: {
                    ((UpdateDateAttributeCommand)c).setYear((Integer)this.valueByField.get("year"));
                    ((UpdateDateAttributeCommand)c).setMonth((Integer)this.valueByField.get("month"));
                    ((UpdateDateAttributeCommand)c).setDay((Integer)this.valueByField.get("day"));
                    break;
                }
                case NUMBER: {
                    ((UpdateNumericAttributeCommand)c).setValue((Number)this.valueByField.get("value"));
                    ((UpdateNumericAttributeCommand)c).setUnitId((Integer)this.valueByField.get("unit"));
                    break;
                }
                case TEXT: {
                    ((UpdateTextAttributeCommand)c).setValue((String)this.valueByField.get("value"));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
                }
            }
        }

        public UpdateAttributeCommand toCommand() {
            Class<? extends UpdateAttributeCommand> commandType = this.toCommandType();
            try {
                UpdateAttributeCommand c = commandType.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)((Object)this), (Object)c, (String[])new String[]{"attributeType", "value"});
                this.setValueInCommand((NodeCommand)c);
                return c;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<? extends UpdateAttributeCommand> toCommandType() {
            switch (this.attributeType) {
                case BOOLEAN: {
                    return UpdateBooleanAttributeCommand.class;
                }
                case CODE: {
                    return UpdateCodeAttributeCommand.class;
                }
                case DATE: {
                    return UpdateDateAttributeCommand.class;
                }
                case NUMBER: {
                    return UpdateNumericAttributeCommand.class;
                }
                case TEXT: {
                    return UpdateTextAttributeCommand.class;
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public void setAttributeType(AttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public Map<String, Object> getValueByField() {
            return this.valueByField;
        }

        public void setValueByField(Map<String, Object> valueByField) {
            this.valueByField = valueByField;
        }
    }

    static class UpdateAttributesCommandWrapper {
        List<UpdateAttributeCommandWrapper> commands = new ArrayList<UpdateAttributeCommandWrapper>();

        UpdateAttributesCommandWrapper() {
        }

        public List<UpdateAttributeCommandWrapper> getCommands() {
            return this.commands;
        }

        public void setCommands(List<UpdateAttributeCommandWrapper> commands) {
            this.commands = commands;
        }
    }

    static class RecordEventView {
        private RecordEvent event;

        public RecordEventView(RecordEvent event) {
            this.event = event;
        }

        public String getEventType() {
            return this.event.getClass().getSimpleName();
        }

        public RecordEvent getEvent() {
            return this.event;
        }
    }
}

