/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.dataexport.species.SpeciesExportProcess;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.utils.Controllers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SpeciesController {
    private static final String SPECIES_LIST_CSV_FILE_NAME = "species_list.csv";
    @Autowired
    private SpeciesManager speciesManager;
    @Autowired
    private SurveyManager surveyManager;

    @RequestMapping(value={"api/survey/{surveyId}/taxonomy/{taxonomyId}/export.csv"}, method={RequestMethod.GET})
    @ResponseBody
    public String exportSpecies(HttpServletResponse response, @PathVariable(value="surveyId") Integer surveyId, @PathVariable(value="taxonomyId") Integer taxonomyId) throws IOException {
        Controllers.setOutputContent(response, SPECIES_LIST_CSV_FILE_NAME, "text/csv");
        ServletOutputStream out = response.getOutputStream();
        CollectSurvey survey = this.surveyManager.loadSurvey(surveyId.intValue());
        SpeciesExportProcess process = new SpeciesExportProcess(this.speciesManager);
        process.exportToCSV((OutputStream)out, survey, taxonomyId);
        return "ok";
    }
}

