/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.json;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.parser.JSONParser;
import org.openforis.collect.datacleansing.ValueParser;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.BooleanAttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.DateAttributeDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.RangeAttributeDefinition;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;
import org.openforis.idm.metamodel.TimeAttributeDefinition;
import org.openforis.idm.metamodel.Unit;
import org.openforis.idm.model.BooleanValue;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.Date;
import org.openforis.idm.model.File;
import org.openforis.idm.model.IntegerRange;
import org.openforis.idm.model.IntegerValue;
import org.openforis.idm.model.RealRange;
import org.openforis.idm.model.RealValue;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.TextValue;
import org.openforis.idm.model.Time;
import org.openforis.idm.model.Value;

public class JSONValueParser
implements ValueParser {
    @Override
    public Value parseValue(AttributeDefinition def, String value) {
        if (def instanceof BooleanAttributeDefinition) {
            return this.parseBoolean(value);
        }
        if (def instanceof CodeAttributeDefinition) {
            return this.parseCode(value);
        }
        if (def instanceof CoordinateAttributeDefinition) {
            return this.parseCoordinate(value);
        }
        if (def instanceof DateAttributeDefinition) {
            return this.parseDate(value);
        }
        if (def instanceof FileAttributeDefinition) {
            return this.parseFile(value);
        }
        if (def instanceof NumberAttributeDefinition) {
            if (((NumberAttributeDefinition)def).getType() == NumericAttributeDefinition.Type.INTEGER) {
                return this.parseInteger((NumberAttributeDefinition)def, value);
            }
            return this.parseReal((NumberAttributeDefinition)def, value);
        }
        if (def instanceof RangeAttributeDefinition) {
            if (((RangeAttributeDefinition)def).getType() == NumericAttributeDefinition.Type.INTEGER) {
                return this.parseIntegerRange((RangeAttributeDefinition)def, value);
            }
            return this.parseRealRange((RangeAttributeDefinition)def, value);
        }
        if (def instanceof TaxonAttributeDefinition) {
            return this.parseTaxonOccurrence(value);
        }
        if (def instanceof TextAttributeDefinition) {
            return this.parseText(value);
        }
        if (def instanceof TimeAttributeDefinition) {
            return this.parseTime(value);
        }
        throw new UnsupportedOperationException("Attribute type not supported: " + def.getClass());
    }

    public BooleanValue parseBoolean(String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "value");
        return map == null ? null : new BooleanValue((Boolean)map.get("value"));
    }

    public Code parseCode(String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "code");
        return map == null ? null : new Code((String)map.get("code"), (String)map.get("qualifier"));
    }

    public Coordinate parseCoordinate(String value) {
        Map<String, Object> map = this.parseJSONToMap(value);
        return map == null ? null : new Coordinate(JSONValueParser.getDouble(map, "x"), JSONValueParser.getDouble(map, "y"), (String)map.get("srs"));
    }

    public Date parseDate(String value) {
        Map<String, Object> map = this.parseJSONToMap(value, null);
        return map == null ? null : new Date(JSONValueParser.getInteger(map, "year"), JSONValueParser.getInteger(map, "month"), JSONValueParser.getInteger(map, "day"));
    }

    public File parseFile(String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "filename");
        return map == null ? null : new File((String)map.get("filename"), JSONValueParser.getLong(map, "size"));
    }

    public IntegerValue parseInteger(NumberAttributeDefinition attrDef, String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "value");
        if (map == null) {
            return null;
        }
        Integer unitId = JSONValueParser.getInteger(map, "unit_id");
        Unit unit = attrDef.getActualUnit(unitId);
        return new IntegerValue(JSONValueParser.getInteger(map, "value"), unit);
    }

    public IntegerRange parseIntegerRange(RangeAttributeDefinition attrDef, String value) {
        Map<String, Object> map = this.parseJSONToMap(value);
        if (map == null) {
            return null;
        }
        Integer from = JSONValueParser.getInteger(map, "from");
        Integer to = JSONValueParser.getInteger(map, "to");
        if (to == null) {
            to = from;
        }
        Integer unitId = JSONValueParser.getInteger(map, "unit_id");
        Unit unit = attrDef.getActualUnit(unitId);
        return new IntegerRange(from, to, unit);
    }

    public RealValue parseReal(NumberAttributeDefinition attrDef, String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "value");
        if (map == null) {
            return null;
        }
        Integer unitId = JSONValueParser.getInteger(map, "unit_id");
        Unit unit = attrDef.getActualUnit(unitId);
        return new RealValue(JSONValueParser.getDouble(map, "value"), unit);
    }

    public RealRange parseRealRange(RangeAttributeDefinition attrDef, String value) {
        Map<String, Object> map = this.parseJSONToMap(value);
        if (map == null) {
            return null;
        }
        Double from = JSONValueParser.getDouble(map, "from");
        Double to = JSONValueParser.getDouble(map, "to");
        if (to == null) {
            to = from;
        }
        Integer unitId = JSONValueParser.getInteger(map, "unit_id");
        Unit unit = attrDef.getActualUnit(unitId);
        return new RealRange(from, to, unit);
    }

    public TaxonOccurrence parseTaxonOccurrence(String value) {
        Map<String, Object> map = this.parseJSONToMap(value, "code");
        return map == null ? null : new TaxonOccurrence((String)map.get("code"), (String)map.get("scientific_name"), (String)map.get("vernacular_name"), (String)map.get("language_code"), (String)map.get("language_variety"));
    }

    private TextValue parseText(String value) {
        Map<String, Object> map = this.parseJSONToMap(value);
        return map == null ? null : new TextValue((String)map.get("value"));
    }

    public Time parseTime(String value) {
        Map<String, Object> map = this.parseJSONToMap(value);
        return map == null ? null : new Time(JSONValueParser.getInteger(map, "hour"), JSONValueParser.getInteger(map, "minute"));
    }

    private Map<String, Object> parseJSONToMap(String value) {
        return this.parseJSONToMap(value, null);
    }

    private Map<String, Object> parseJSONToMap(final String value, final String singleValueField) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (value.startsWith("{")) {
            try {
                Map map = (Map)new JSONParser().parse(value);
                return map;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new HashMap<String, Object>(){
            {
                this.put(StringUtils.trimToEmpty((String)singleValueField), value);
            }
        };
    }

    protected static Integer getInteger(Map<String, Object> map, String field) {
        Object val = map.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return Integer.parseInt(val.toString());
    }

    protected static Double getDouble(Map<String, Object> map, String field) {
        Object val = map.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Double.parseDouble(val.toString());
    }

    protected static Long getLong(Map<String, Object> map, String field) {
        Object val = map.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Long.parseLong(val.toString());
    }
}

