/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.datacleansing.xpath;

import java.util.ArrayList;
import java.util.List;
import org.openforis.collect.datacleansing.DataQuery;
import org.openforis.collect.datacleansing.DataQueryEvaluator;
import org.openforis.collect.model.CollectRecord;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.SurveyContext;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.expression.ExpressionEvaluator;
import org.openforis.idm.model.expression.InvalidExpressionException;

public class XPathDataQueryEvaluator
implements DataQueryEvaluator {
    private DataQuery query;

    public XPathDataQueryEvaluator(DataQuery query) {
        this.query = query;
    }

    @Override
    public List<Node<?>> evaluate(CollectRecord record) {
        ArrayList result = new ArrayList();
        String condition = this.query.getConditions();
        AttributeDefinition attrDef = this.query.getAttributeDefinition();
        SurveyContext surveyContext = record.getSurveyContext();
        ExpressionEvaluator expressionEvaluator = surveyContext.getExpressionEvaluator();
        List nodes = record.findNodesByPath(attrDef.getPath());
        for (Node node : nodes) {
            try {
                if (!expressionEvaluator.evaluateBoolean((Node)node.getParent(), node, condition)) continue;
                result.add(node);
            }
            catch (InvalidExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

