/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import java.util.Locale;
import org.openforis.collect.designer.form.SurveyObjectFormObject;
import org.openforis.collect.designer.viewmodel.UnitsVM;
import org.openforis.idm.metamodel.Unit;

public class UnitFormObject
extends SurveyObjectFormObject<Unit> {
    private String name;
    private String label;
    private String abbreviation;
    private String dimensionLabel;
    private Double conversionFactor;

    @Override
    public void loadFrom(Unit source, String languageCode) {
        this.name = source.getName();
        this.label = source.getLabel(languageCode);
        this.abbreviation = source.getAbbreviation(languageCode);
        String dimensionValue = source.getDimension();
        if (dimensionValue != null) {
            Unit.Dimension dimension = Unit.Dimension.valueOf((String)dimensionValue.toUpperCase(Locale.ENGLISH));
            this.dimensionLabel = UnitsVM.getDimensionLabel(dimension);
        } else {
            this.dimensionLabel = null;
        }
        this.conversionFactor = source.getConversionFactor();
    }

    @Override
    public void saveTo(Unit dest, String languageCode) {
        dest.setName(this.name);
        dest.setLabel(languageCode, this.label);
        dest.setAbbreviation(languageCode, this.abbreviation);
        Unit.Dimension dimension = this.getDimensionFromLabel(this.dimensionLabel);
        dest.setDimension(dimension == null ? null : dimension.name().toLowerCase(Locale.ENGLISH));
        dest.setConversionFactor(this.conversionFactor);
    }

    @Override
    protected void reset() {
    }

    private Unit.Dimension getDimensionFromLabel(String label) {
        for (Unit.Dimension dimension : Unit.Dimension.values()) {
            String dimLabel = UnitsVM.getDimensionLabel(dimension);
            if (!dimLabel.equals(label)) continue;
            return dimension;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public Double getConversionFactor() {
        return this.conversionFactor;
    }

    public void setConversionFactor(Double conversionFactor) {
        this.conversionFactor = conversionFactor;
    }

    public String getDimensionLabel() {
        return this.dimensionLabel;
    }

    public void setDimensionLabel(String dimensionLabel) {
        this.dimensionLabel = dimensionLabel;
    }
}

