/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.viewmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.designer.form.AttributeDefinitionFormObject;
import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.designer.form.NodeDefinitionFormObject;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.designer.model.CheckType;
import org.openforis.collect.designer.util.MessageUtil;
import org.openforis.collect.designer.util.Predicate;
import org.openforis.collect.designer.util.Resources;
import org.openforis.collect.designer.viewmodel.BaseVM;
import org.openforis.collect.designer.viewmodel.NodeDefinitionVM;
import org.openforis.collect.designer.viewmodel.SchemaObjectSelectorPopUpVM;
import org.openforis.collect.manager.validation.SurveyValidator;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.ui.UITab;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.AttributeDefault;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.SurveyObject;
import org.openforis.idm.metamodel.validation.Check;
import org.openforis.idm.metamodel.validation.ComparisonCheck;
import org.openforis.idm.metamodel.validation.CustomCheck;
import org.openforis.idm.metamodel.validation.DistanceCheck;
import org.openforis.idm.metamodel.validation.PatternCheck;
import org.openforis.idm.metamodel.validation.UniquenessCheck;
import org.zkoss.bind.BindUtils;
import org.zkoss.bind.Binder;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.Command;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.DependsOn;
import org.zkoss.bind.annotation.GlobalCommand;
import org.zkoss.bind.annotation.NotifyChange;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public abstract class AttributeVM<T extends AttributeDefinition>
extends NodeDefinitionVM<T> {
    private static final String EDITED_NODE_KEY_CHANGING_GLOBAL_COMMAND = "editedNodeKeyChanging";
    private static final String EDITED_NODE_CALCULATED_PROPERTY_CHANGING_GLOBAL_COMMAND = "editedNodeCalculatedPropertyChanging";
    private List<Check<?>> checks;
    private boolean editingNewCheck;
    private Check<?> editedCheck;
    private Check<?> selectedCheck;
    protected List<AttributeDefault> attributeDefaults;
    private Boolean editingNewAttributeDefault;
    private AttributeDefault editedAttributeDefault;
    protected AttributeDefault selectedAttributeDefault;
    private Window checkPopUp;
    private Window attributeDefaultPopUp;

    public AttributeVM() {
        this.fieldLabelKeyPrefixes.addAll(Arrays.asList("survey.schema.attribute"));
    }

    @Override
    protected FormObject<T> createFormObject() {
        AttributeType attributeTypeEnum = AttributeType.valueOf((AttributeDefinition)this.editedItem);
        this.formObject = NodeDefinitionFormObject.newInstance(this.parentEntity, attributeTypeEnum);
        return this.formObject;
    }

    @Override
    @NotifyChange(value={"editedItem", "formObject", "tempFormObject", "checks"})
    public void setEditedItem(T editedItem) {
        super.setEditedItem(editedItem);
        this.initAttributeDefaults();
        this.initChecks();
    }

    @Override
    public List<Map<String, String>> getDependentNodes() {
        List<Map<String, String>> result = super.getDependentNodes();
        return result;
    }

    protected void initChecks() {
        if (this.editedItem == null) {
            this.checks = null;
        } else {
            this.checks = new ArrayList(((AttributeDefinition)this.editedItem).getChecks());
            ((AttributeDefinitionFormObject)this.formObject).setChecks(this.checks);
            this.setTempFormObjectFieldValue("checks", this.checks);
        }
    }

    @Override
    @GlobalCommand
    public void currentLanguageChanged() {
        super.currentLanguageChanged();
        this.notifyChange("attributeDefaults", "precisions");
    }

    @Command
    public void addCheck(@BindingParam(value="checkType") String checkType) {
        if (this.checkCanAddCheck()) {
            CheckType type = CheckType.valueOf(checkType.toUpperCase(Locale.ENGLISH));
            this.editingNewCheck = true;
            this.editedCheck = CheckType.createCheck(type);
            this.openCheckEditPopUp();
        }
    }

    @Command
    public void editCheck() {
        this.editingNewCheck = false;
        this.editedCheck = this.selectedCheck;
        this.openCheckEditPopUp();
    }

    @Command
    public void deleteCheck() {
        MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                ((AttributeDefinition)AttributeVM.this.editedItem).removeCheck(AttributeVM.this.selectedCheck);
                AttributeVM.this.selectedCheck = null;
                AttributeVM.this.initChecks();
                AttributeVM.this.notifyChange("selectedCheck", "checks");
            }
        }, "survey.schema.node.check.confirm_delete");
        params.setOkLabelKey("global.delete_item");
        MessageUtil.showConfirm(params);
    }

    @Command
    @NotifyChange(value={"selectedAttributeDefault"})
    public void selectCheck(@BindingParam(value="check") Check<?> check) {
        this.selectedCheck = check;
    }

    @Command
    public void keyChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="key") boolean key) {
        if (!key) {
            this.setTempFormObjectFieldValue("measurement", false);
        }
        this.dispatchApplyChangesCommand(binder);
        this.dispatchKeyChangingCommand(key);
    }

    private void dispatchKeyChangingCommand(boolean key) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("item", this.editedItem);
        args.put("key", key);
        BindUtils.postGlobalCommand(null, null, (String)EDITED_NODE_KEY_CHANGING_GLOBAL_COMMAND, args);
    }

    @Command
    public void calculatedChanged(@ContextParam(value=ContextType.BINDER) Binder binder, @BindingParam(value="changed") boolean changed) {
        this.setTempFormObjectFieldValue("key", false);
        this.setTempFormObjectFieldValue("multiple", false);
        this.setTempFormObjectFieldValue("showInUI", true);
        this.setTempFormObjectFieldValue("includeInDataExport", CollectAnnotations.Annotation.INCLUDE_IN_DATA_EXPORT.getDefaultValue());
        this.setTempFormObjectFieldValue("calculatedOnlyOneTime", CollectAnnotations.Annotation.CALCULATED_ONLY_ONE_TIME.getDefaultValue());
        this.setTempFormObjectFieldValue("editable", CollectAnnotations.Annotation.EDITABLE.getDefaultValue());
        this.setTempFormObjectFieldValue("phaseToApplyDefaultValue", ((CollectRecord.Step)CollectAnnotations.Annotation.PHASE_TO_APPLY_DEFAULT_VALUE.getDefaultValue()).name());
        this.dispatchKeyChangingCommand(false);
        this.dispatchCalculatedPropertyChangingCommand(changed);
        this.dispatchApplyChangesCommand(binder);
    }

    private void dispatchCalculatedPropertyChangingCommand(boolean calculated) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("item", this.editedItem);
        args.put("calculated", calculated);
        BindUtils.postGlobalCommand(null, null, (String)EDITED_NODE_CALCULATED_PROPERTY_CHANGING_GLOBAL_COMMAND, args);
    }

    protected void openCheckEditPopUp() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("parentDefinition", this.editedItem);
        args.put("newItem", this.editingNewCheck);
        args.put("check", this.editedCheck);
        this.checkPopUp = AttributeVM.openPopUp(Resources.Component.CHECK_POPUP.getLocation(), true, args);
    }

    @GlobalCommand
    public void applyChangesToEditedCheck(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedCheck != null && this.checkCanLeaveForm()) {
            if (this.editingNewCheck) {
                ((AttributeDefinition)this.editedItem).addCheck(this.editedCheck);
            }
            this.closeCheckEditPopUp(binder);
            this.editedCheck = null;
            this.initChecks();
            this.notifyChange("checks");
        }
    }

    @GlobalCommand
    public void cancelChangesToEditedCheck(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedCheck != null) {
            this.closeCheckEditPopUp(binder);
            this.editedCheck = null;
        }
    }

    protected void closeCheckEditPopUp(Binder binder) {
        AttributeVM.closePopUp(this.checkPopUp);
        this.checkPopUp = null;
        this.validateForm(binder);
    }

    protected void initAttributeDefaults() {
        if (this.editedItem == null) {
            this.attributeDefaults = null;
        } else {
            this.attributeDefaults = new ArrayList<AttributeDefault>(((AttributeDefinition)this.editedItem).getAttributeDefaults());
            this.setTempFormObjectFieldValue("attributeDefaults", this.attributeDefaults);
            ((AttributeDefinitionFormObject)this.formObject).setAttributeDefaults(this.attributeDefaults);
        }
        this.notifyChange("formObject", "tempFormObject", "attributeDefaults");
    }

    @Command
    @NotifyChange(value={"attributeDefaults"})
    public void addAttributeDefault() {
        if (this.checkCanInsertAttributeDefault()) {
            this.editingNewAttributeDefault = true;
            this.editedAttributeDefault = new AttributeDefault();
            this.openAttributeDefaultEditPopUp();
        }
    }

    protected boolean checkCanInsertAttributeDefault() {
        String lastItemCondition;
        if (!this.checkNodeAttached()) {
            return false;
        }
        if (this.attributeDefaults != null && !this.attributeDefaults.isEmpty() && (StringUtils.isBlank((CharSequence)(lastItemCondition = this.attributeDefaults.get(this.attributeDefaults.size() - 1).getCondition())) || lastItemCondition.trim().equalsIgnoreCase("true()"))) {
            MessageUtil.showWarning("survey.schema.attribute.attribute_default.cannot_insert.item_without_condition_found", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkCanAddCheck() {
        return this.checkNodeAttached();
    }

    @Command
    public void editAttributeDefault() {
        this.editingNewAttributeDefault = false;
        this.editedAttributeDefault = this.selectedAttributeDefault;
        this.openAttributeDefaultEditPopUp();
    }

    @Command
    @NotifyChange(value={"selectedAttributeDefault", "attributeDefaults"})
    public void deleteAttributeDefault() {
        MessageUtil.ConfirmParams params = new MessageUtil.ConfirmParams(new MessageUtil.ConfirmHandler(){

            @Override
            public void onOk() {
                ((AttributeDefinition)AttributeVM.this.editedItem).removeAttributeDefault(AttributeVM.this.selectedAttributeDefault);
                AttributeVM.this.selectedAttributeDefault = null;
                AttributeVM.this.initAttributeDefaults();
                AttributeVM.this.notifyChange("selectedAttributeDefault", "attributeDefaults");
            }
        }, "survey.schema.attribute.attribute_default.confirm_delete");
        params.setOkLabelKey("global.delete_item");
        MessageUtil.showConfirm(params);
    }

    @Command
    @NotifyChange(value={"selectedAttributeDefault"})
    public void selectAttributeDefault(@BindingParam(value="attributeDefault") AttributeDefault attributeDefault) {
        this.selectedAttributeDefault = attributeDefault;
    }

    protected void openAttributeDefaultEditPopUp() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("parentDefinition", this.editedItem);
        args.put("newItem", this.editingNewAttributeDefault);
        args.put("attributeDefault", this.editedAttributeDefault);
        this.attributeDefaultPopUp = AttributeVM.openPopUp(Resources.Component.ATTRIBUTE_DEFAULT_POPUP.getLocation(), true, args);
    }

    @GlobalCommand
    public void applyChangesToEditedAttributeDefault(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedAttributeDefault != null && this.checkCanLeaveForm()) {
            this.closeAttributeDefaultEditPopUp(binder);
            this.editedAttributeDefault = null;
            this.initAttributeDefaults();
            this.notifyChange("attributeDefaults");
        }
    }

    @GlobalCommand
    public void cancelChangesToEditedAttributeDefault(@ContextParam(value=ContextType.BINDER) Binder binder) {
        if (this.editedAttributeDefault != null) {
            this.closeAttributeDefaultEditPopUp(binder);
            this.editedAttributeDefault = null;
        }
    }

    protected void closeAttributeDefaultEditPopUp(Binder binder) {
        AttributeVM.closePopUp(this.attributeDefaultPopUp);
        this.attributeDefaultPopUp = null;
        this.validateForm(binder);
    }

    @Command
    @NotifyChange(value={"attributeDefaults"})
    public void moveSelectedAttributeDefaultUp() {
        this.moveSelectedAttributeDefault(true);
    }

    @Command
    @NotifyChange(value={"attributeDefaults"})
    public void moveSelectedAttributeDefaultDown() {
        this.moveSelectedAttributeDefault(false);
    }

    protected void moveSelectedAttributeDefault(boolean up) {
        int indexFrom = this.getSelectedAttributeDefaultIndex();
        int indexTo = up ? indexFrom - 1 : indexFrom + 1;
        this.moveSelectedAttributeDefault(indexTo);
    }

    protected int getSelectedAttributeDefaultIndex() {
        List items = ((AttributeDefinition)this.editedItem).getAttributeDefaults();
        int index = items.indexOf(this.selectedAttributeDefault);
        return index;
    }

    protected void moveSelectedAttributeDefault(int indexTo) {
        ((AttributeDefinition)this.editedItem).moveAttributeDefault(this.selectedAttributeDefault, indexTo);
        this.initAttributeDefaults();
    }

    @DependsOn(value={"attributeDefaults", "selectedAttributeDefault"})
    public boolean isMoveSelectedAttributeDefaultUpDisabled() {
        return this.isMoveSelectedAttributeDefaultDisabled(true);
    }

    @DependsOn(value={"attributeDefaults", "selectedAttributeDefault"})
    public boolean isMoveSelectedAttributeDefaultDownDisabled() {
        return this.isMoveSelectedAttributeDefaultDisabled(false);
    }

    protected boolean isMoveSelectedAttributeDefaultDisabled(boolean up) {
        if (this.selectedAttributeDefault == null) {
            return true;
        }
        List siblings = ((AttributeDefinition)this.editedItem).getAttributeDefaults();
        int index = siblings.indexOf(this.selectedAttributeDefault);
        return up ? index <= 0 : index < 0 || index >= siblings.size() - 1;
    }

    @Command
    public void openReferencedAttributeSelector(final @ContextParam(value=ContextType.BINDER) Binder binder) {
        SurveyValidator.ReferenceableKeyAttributeHelper referenceableKeyAttributeHelper = new SurveyValidator.ReferenceableKeyAttributeHelper((AttributeDefinition)this.editedItem);
        final Set referenceableEntityDefinitions = referenceableKeyAttributeHelper.determineReferenceableEntities();
        final Set selectableAttributes = referenceableKeyAttributeHelper.determineReferenceableAttributes();
        if (selectableAttributes.isEmpty()) {
            MessageUtil.showWarning("survey.schema.attribute.no_referenceable_attributes_available", new Object[0]);
        } else {
            Predicate<SurveyObject> includedNodePredicate = new Predicate<SurveyObject>(){

                @Override
                public boolean evaluate(SurveyObject item) {
                    EntityDefinition parentEntity = item instanceof UITab ? AttributeVM.this.survey.getUIOptions().getParentEntityForAssignedNodes((UITab)item) : ((NodeDefinition)item).getParentEntityDefinition();
                    for (EntityDefinition entityDef : referenceableEntityDefinitions) {
                        if (parentEntity != entityDef && !parentEntity.isAncestorOf((NodeDefinition)entityDef)) continue;
                        return true;
                    }
                    return false;
                }
            };
            Predicate<SurveyObject> disabledNodePredicate = new Predicate<SurveyObject>(){

                @Override
                public boolean evaluate(SurveyObject item) {
                    return !selectableAttributes.contains(item);
                }
            };
            String title = Labels.getLabel((String)"survey.schema.attribute.select_attribute_referenced_by", (Object[])new String[]{((AttributeDefinition)this.editedItem).getName()});
            final Window parentSelectorPopUp = SchemaObjectSelectorPopUpVM.openPopup(title, false, ((AttributeDefinition)this.editedItem).getRootEntity(), null, includedNodePredicate, false, false, disabledNodePredicate, null, (SurveyObject)((AttributeDefinition)this.editedItem).getReferencedAttribute(), true);
            parentSelectorPopUp.addEventListener("onNodeSelected", (EventListener)new EventListener<SchemaObjectSelectorPopUpVM.NodeSelectedEvent>(){

                public void onEvent(SchemaObjectSelectorPopUpVM.NodeSelectedEvent event) throws Exception {
                    AttributeDefinition referencedAttribute = (AttributeDefinition)event.getSelectedItem();
                    AttributeDefinitionFormObject fo = (AttributeDefinitionFormObject)AttributeVM.this.formObject;
                    fo.setReferencedAttributePath(referencedAttribute == null ? null : referencedAttribute.getPath());
                    AttributeVM.this.notifyChange("formObject");
                    AttributeVM.this.dispatchApplyChangesCommand(binder);
                    BaseVM.closePopUp(parentSelectorPopUp);
                }
            });
        }
    }

    @Command
    public void generateEntityAlias() {
        AttributeDefinitionFormObject fo = (AttributeDefinitionFormObject)this.formObject;
        String referencedAttributePath = fo.getReferencedAttributePath();
        EntityDefinition sourceDef = ((AttributeDefinition)this.editedItem).getParentEntityDefinition();
        String aliasName = sourceDef + "_alias";
        NodeDefinition referencedAttributeDef = ((AttributeDefinition)this.editedItem).getDefinitionByPath(referencedAttributePath);
        EntityDefinition parentDef = referencedAttributeDef.getNearestAncestorMultipleEntity();
        if (parentDef.containsChildDefinition(aliasName)) {
            MessageUtil.showError("survey.schema.attribute.generate_entity_alias.error.alias_already_existing", aliasName, parentDef.getName());
        } else {
            EntityDefinition aliasDef = this.schemaUpdater.generateAlias(sourceDef, ((AttributeDefinition)this.editedItem).getName(), parentDef, referencedAttributeDef.getName());
            ((CollectSurvey)aliasDef.getSurvey()).getUIOptions().setLayout(aliasDef, UIOptions.Layout.TABLE);
            aliasDef.rename(aliasName);
            this.dispatchSchemaChangedCommand();
            MessageUtil.showInfo("survey.schema.attribute.generate_entity_alias.generation_successfull", aliasName, parentDef.getName());
        }
    }

    public List<AttributeDefault> getAttributeDefaults() {
        return this.attributeDefaults;
    }

    public AttributeDefault getSelectedAttributeDefault() {
        return this.selectedAttributeDefault;
    }

    public void setSelectedAttributeDefault(AttributeDefault selectedAttributeDefault) {
        this.selectedAttributeDefault = selectedAttributeDefault;
    }

    public Check<?> getSelectedCheck() {
        return this.selectedCheck;
    }

    public void setSelectedCheck(Check<?> selectedCheck) {
        this.selectedCheck = selectedCheck;
    }

    public List<Check<?>> getChecks() {
        return this.checks;
    }

    public List<CheckType> getCheckTypes() {
        return CheckType.compatibleValues(AttributeType.valueOf((AttributeDefinition)this.editedItem));
    }

    public String getCheckTypeLabel(Check<?> check) {
        CheckType type = CheckType.valueOf(check);
        return type.getLabel();
    }

    public String getCheckFlagLabel(Check<?> check) {
        Check.Flag flag = check.getFlag();
        switch (flag) {
            case ERROR: {
                return Labels.getLabel((String)"survey.schema.node.check.flag.error");
            }
            case WARN: {
                return Labels.getLabel((String)"survey.schema.node.check.flag.warning");
            }
        }
        return null;
    }

    public String getCheckMessage(Check<?> check) {
        String result = check.getMessage(this.currentLanguageCode);
        if (result == null) {
            CheckType type = CheckType.valueOf(check);
            result = type.getDefaultMessage();
        }
        return result;
    }

    public String getCheckExpressionPreview(Check<?> check) {
        if (check instanceof ComparisonCheck) {
            return ((ComparisonCheck)check).getExpression();
        }
        if (check instanceof CustomCheck) {
            return ((CustomCheck)check).getExpression();
        }
        if (check instanceof DistanceCheck) {
            return this.getDistanceCheckExpressionPreview((DistanceCheck)check);
        }
        if (check instanceof PatternCheck) {
            return ((PatternCheck)check).getRegularExpression();
        }
        if (check instanceof UniquenessCheck) {
            return ((UniquenessCheck)check).getExpression();
        }
        return null;
    }

    public String getCheckCondition(Check<?> check) {
        return check.getCondition();
    }

    private String getDistanceCheckExpressionPreview(DistanceCheck dc) {
        ArrayList<String> parts = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)dc.getMinDistanceExpression())) {
            parts.add(Labels.getLabel((String)"survey.schema.node.check.distance.minDistanceExpressionPreview", (Object[])new String[]{dc.getDestinationPointExpression(), dc.getMinDistanceExpression()}));
        }
        if (StringUtils.isNotBlank((CharSequence)dc.getMaxDistanceExpression())) {
            parts.add(Labels.getLabel((String)"survey.schema.node.check.distance.maxDistanceExpressionPreview", (Object[])new String[]{dc.getDestinationPointExpression(), dc.getMaxDistanceExpression()}));
        }
        return StringUtils.join(parts, (String)"\n");
    }
}

