/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.granite.context.GraniteContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.openforis.collect.config.CollectConfiguration;
import org.openforis.collect.designer.session.SessionStatus;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.UserManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.User;
import org.openforis.collect.persistence.RecordUnlockedException;
import org.openforis.collect.persistence.SurveyStoreException;
import org.openforis.collect.web.session.SessionState;
import org.openforis.collect.web.ws.AppWS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionManager {
    private static final Logger LOG = LogManager.getLogger(SessionManager.class);
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    @Autowired
    private transient SurveyManager surveyManager;
    @Autowired
    private transient UserManager userManager;
    @Autowired
    private transient RecordManager recordManager;
    @Autowired
    private transient AppWS appWS;

    public void createSessionState(HttpSession session) {
        String sessionId = session.getId();
        SessionState sessionState = new SessionState(sessionId);
        if (CollectConfiguration.isDevelopmentMode()) {
            sessionState.setUser(this.userManager.loadAdminUser());
        }
        session.setAttribute(SessionState.SESSION_ATTRIBUTE_NAME, (Object)sessionState);
    }

    public void sessionDestroyed() {
        CollectRecord activeRecord = this.getActiveRecord();
        if (activeRecord != null) {
            try {
                this.releaseRecord();
            }
            catch (RecordUnlockedException recordUnlockedException) {
                // empty catch block
            }
        }
    }

    public SessionState getSessionState() {
        SessionState sessionState = (SessionState)this.getSessionAttribute(SessionState.SESSION_ATTRIBUTE_NAME);
        if (sessionState == null) {
            return null;
        }
        if (sessionState.getUser() == null) {
            sessionState.setUser(this.loadAuthenticatedUser());
        }
        return sessionState;
    }

    public CollectRecord getActiveRecord() {
        SessionState sessionState = this.getSessionState();
        return sessionState.getActiveRecord();
    }

    public User getLoggedUser() {
        SessionState sessionState = this.getSessionState();
        return sessionState.getUser();
    }

    public String getLoggedUsername() {
        User user = this.getLoggedUser();
        return user == null ? null : user.getUsername();
    }

    public CollectSurvey getActiveDesignerSurvey() {
        SessionStatus designerSessionStatus = this.getDesignerSessionStatus();
        if (designerSessionStatus == null) {
            return null;
        }
        return designerSessionStatus.getSurvey();
    }

    public SessionStatus getDesignerSessionStatus() {
        SessionStatus designerSessionStatus = (SessionStatus)this.getSessionAttribute("designer_status");
        return designerSessionStatus;
    }

    public CollectSurvey getActiveSurvey() {
        SessionState sessionState = this.getSessionState();
        return sessionState.getActiveSurvey();
    }

    public void setActiveRecord(CollectRecord record) {
        SessionState sessionState = this.getSessionState();
        sessionState.setActiveRecord(record);
        sessionState.keepActiveRecordAlive();
    }

    public void setActiveSurvey(CollectSurvey survey) {
        SessionState sessionState = this.getSessionState();
        sessionState.setActiveSurvey(survey);
    }

    public void clearActiveRecord() {
        SessionState sessionState = this.getSessionState();
        sessionState.setActiveRecord(null);
    }

    public void saveActiveDesignerSurvey() {
        try {
            SessionState sessionState = this.getSessionState();
            CollectSurvey survey = this.getActiveDesignerSurvey();
            boolean activeSurveyWork = sessionState.isActiveSurveyWork();
            if (!activeSurveyWork) {
                throw new IllegalArgumentException("Active designer survey should be a 'work' survey");
            }
            this.surveyManager.save(survey);
        }
        catch (SurveyStoreException e) {
            LOG.error("Error updating taxonomy related attributes.", (Throwable)e);
        }
    }

    public void keepSessionAlive() {
        this.getSessionState();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Keep alive request received");
        }
    }

    public void setLocale(String localeStr) {
        Locale locale = this.toLocale(localeStr);
        SessionState sessionState = this.getSessionState();
        sessionState.setLocale(locale);
    }

    public void checkIsActiveRecordLocked() throws RecordUnlockedException {
        SessionState sessionState = this.getSessionState();
        CollectRecord record = sessionState.getActiveRecord();
        if (record == null) {
            throw new RecordUnlockedException();
        }
        if (record.getId() != null) {
            User user = sessionState.getUser();
            String lockId = sessionState.getSessionId();
            try {
                this.recordManager.checkIsLocked(record.getId().intValue(), user, lockId);
                sessionState.keepActiveRecordAlive();
            }
            catch (RecordUnlockedException e) {
                this.clearActiveRecord();
                throw e;
            }
        }
    }

    private Object getSessionAttribute(String attributeName) {
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (graniteContext != null) {
            return graniteContext.getSessionMap().get(attributeName);
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            HttpSession session = requestAttributes.getRequest().getSession(false);
            return session == null ? null : session.getAttribute(attributeName);
        }
        return null;
    }

    public void invalidateSession() {
        try {
            this.releaseRecord();
        }
        catch (RecordUnlockedException recordUnlockedException) {
            // empty catch block
        }
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (graniteContext != null && graniteContext instanceof HttpGraniteContext) {
            HttpGraniteContext httpGraniteContext = (HttpGraniteContext)graniteContext;
            HttpServletRequest request = httpGraniteContext.getRequest();
            HttpSession session = request.getSession();
            session.invalidate();
        }
    }

    public void releaseRecord() throws RecordUnlockedException {
        this.checkIsActiveRecordLocked();
        SessionState sessionState = this.getSessionState();
        CollectRecord activeRecord = sessionState.getActiveRecord();
        if (activeRecord != null && activeRecord.getId() != null) {
            this.recordManager.releaseLock(activeRecord.getId());
            this.appWS.sendMessage(new AppWS.RecordUnlockedMessage(activeRecord.getId()));
        }
        sessionState.setActiveRecord(null);
    }

    private User loadAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            String name = authentication.getName();
            User user = this.userManager.loadByUserName(name);
            return user;
        }
        return null;
    }

    private Locale toLocale(String localeStr) {
        try {
            return LocaleUtils.toLocale((String)localeStr);
        }
        catch (Exception e) {
            if (localeStr.length() > 2) {
                return LocaleUtils.toLocale((String)localeStr.substring(0, 2));
            }
            return DEFAULT_LOCALE;
        }
    }
}

