/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.manager.codelistimport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openforis.collect.io.exception.ParsingException;
import org.openforis.collect.io.metadata.parsing.CSVDataImportReader;
import org.openforis.collect.io.metadata.parsing.CSVLineParser;
import org.openforis.collect.io.metadata.parsing.DataImportReader;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.io.parsing.CSVFileOptions;
import org.openforis.collect.manager.codelistimport.CodeListLine;
import org.openforis.commons.io.csv.CsvLine;

public class CodeListCSVReader
extends CSVDataImportReader<CodeListLine> {
    public static final String FLAT_LIST_CODE_COLUMN_NAME = "code";
    public static final String FLAT_LIST_LABEL_COLUMN_NAME = "label";
    public static final String CODE_COLUMN_SUFFIX = "_code";
    public static final String LABEL_COLUMN_SUFFIX = "_label";
    public static final String DESCRIPTION_COLUMN_SUFFIX = "_description";
    public static final String QUALIFIABLE_COLUMN_SUFFIX = "_qualifiable";
    private ColumnsInfo columnsInfo;
    private List<String> languages;
    private String defaultLanguage;

    public CodeListCSVReader(File file, CSVFileOptions csvFileOptions, List<String> languages, String defaultLanguage) throws IOException, ParsingException {
        super(file, csvFileOptions);
        this.languages = languages;
        this.defaultLanguage = defaultLanguage;
    }

    protected void readHeaders() throws IOException {
        super.readHeaders();
        this.columnsInfo = new ColumnsInfoExtractor().extractColumnsInfo(this.csvReader.getColumnNames(), this.defaultLanguage);
    }

    protected CodeListCSVLineParser createLineParserInstance() {
        CodeListCSVLineParser lineParser = CodeListCSVLineParser.createInstance(this, this.currentCSVLine);
        return lineParser;
    }

    public boolean validateAllFile() throws ParsingException {
        Validator validator = new Validator();
        validator.validate();
        return true;
    }

    public List<String> getLevels() {
        return this.getColumnsInfo().getLevelNames();
    }

    public ColumnsInfo getColumnsInfo() {
        return this.columnsInfo;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    class Validator {
        private static final String MISSING_REQUIRED_COLUMNS_MESSAGE_KEY = "codeListImport.parsingError.missing_required_columns.message";
        private static final String LANGUAGE_CODE_NOT_DEFINED_MESSAGE_KEY = "codeListImport.parsingError.language_code_not_defined";

        Validator() {
        }

        public void validate() throws ParsingException {
            this.validateHeaders();
        }

        protected void validateHeaders() throws ParsingException {
            if (CodeListCSVReader.this.columnsInfo.getLevelNames().isEmpty()) {
                throw new ParsingException(new ParsingError(ParsingError.ErrorType.MISSING_REQUIRED_COLUMNS, 1L, (String)null, MISSING_REQUIRED_COLUMNS_MESSAGE_KEY));
            }
            for (String colName : CodeListCSVReader.this.getColumnNames()) {
                ColumnInfo columnInfo = CodeListCSVReader.this.columnsInfo.getInfo(colName);
                switch (columnInfo.getType()) {
                    case INVALID: {
                        throw new ParsingException(new ParsingError(ParsingError.ErrorType.WRONG_COLUMN_NAME, 1L, colName));
                    }
                    case LABEL: 
                    case DESCRIPTION: {
                        if (CodeListCSVReader.this.languages.contains(columnInfo.getLangCode())) break;
                        throw new ParsingException(new ParsingError(ParsingError.ErrorType.WRONG_COLUMN_NAME, 1L, colName, LANGUAGE_CODE_NOT_DEFINED_MESSAGE_KEY));
                    }
                }
            }
        }
    }

    static class ColumnsInfoExtractor {
        private static final String LEVEL_NAME_COLUMN_EXPR = "[a-z]\\w*";
        private static final Pattern CODE_COLUMN_PATTERN = ColumnsInfoExtractor.toPattern("([a-z]\\w*)_code");
        private static final String LABEL_COLUMN_EXPR = "([a-z]\\w*)";
        private static final Pattern LABEL_COLUMN_PATTERN = ColumnsInfoExtractor.toPattern("([a-z]\\w*)");
        private static final String LANG_OPTIONAL_EXPR = "(_([a-z]{2}))?";
        private static final String LABEL_COLUMN_WITH_LANG_CODE_EXPR = "([a-z]\\w*)_label(_([a-z]{2}))?";
        private static final Pattern LABEL_COLUMN_WITH_LANG_CODE_PATTERN = ColumnsInfoExtractor.toPattern("([a-z]\\w*)_label(_([a-z]{2}))?");
        private static final Pattern DESCRIPTION_COLUMN_PATTERN = ColumnsInfoExtractor.toPattern("([a-z]\\w*)_description(_([a-z]{2}))?");
        private static final Pattern QUALIFIABLE_COLUMN_PATTERN = ColumnsInfoExtractor.toPattern("([a-z]\\w*)_qualifiable");

        ColumnsInfoExtractor() {
        }

        private static final Pattern toPattern(String expr) {
            return Pattern.compile("^" + expr + "$");
        }

        public ColumnsInfo extractColumnsInfo(List<String> colNames, String defaultLanguage) {
            ColumnsInfo columnsInfo = new ColumnsInfo();
            int prevLevelIndex = -1;
            String prevLevelName = null;
            for (String colName : colNames) {
                ColumnInfo columnInfo = this.extractColumnInfo(colName, prevLevelIndex, prevLevelName, defaultLanguage);
                if (columnInfo.getType() == ColumnType.CODE) {
                    ++prevLevelIndex;
                    prevLevelName = columnInfo.getLevelName();
                }
                columnsInfo.addColumnInfo(columnInfo);
            }
            return columnsInfo;
        }

        private ColumnInfo extractColumnInfo(String colName, int levelIndex, String expectedLevelName, String defaultLanguage) {
            try {
                Matcher matcher = CODE_COLUMN_PATTERN.matcher(colName);
                if (matcher.matches()) {
                    String levelName = matcher.group(1);
                    return new ColumnInfo(colName, ColumnType.CODE, levelName, levelIndex + 1);
                }
                matcher = DESCRIPTION_COLUMN_PATTERN.matcher(colName);
                if (matcher.matches()) {
                    String levelName = matcher.group(1);
                    this.checkLevelName(expectedLevelName, levelName);
                    String langCode = matcher.groupCount() > 2 && matcher.group(3) != null ? matcher.group(3) : defaultLanguage;
                    return new ColumnInfo(colName, ColumnType.DESCRIPTION, levelName, levelIndex, langCode);
                }
                matcher = QUALIFIABLE_COLUMN_PATTERN.matcher(colName);
                if (matcher.matches()) {
                    String levelName = matcher.group(1);
                    this.checkLevelName(expectedLevelName, levelName);
                    return new ColumnInfo(colName, ColumnType.QUALIFIABLE, levelName, levelIndex);
                }
                matcher = LABEL_COLUMN_WITH_LANG_CODE_PATTERN.matcher(colName);
                if (!matcher.matches()) {
                    matcher = LABEL_COLUMN_PATTERN.matcher(colName);
                }
                if (matcher.matches()) {
                    String levelName = matcher.group(1);
                    this.checkLevelName(expectedLevelName, levelName);
                    ColumnInfo columnInfo = new ColumnInfo(colName, ColumnType.LABEL, levelName, levelIndex);
                    String langCode = matcher.groupCount() > 2 && matcher.group(3) != null ? matcher.group(3) : defaultLanguage;
                    columnInfo.setLangCode(langCode);
                    return columnInfo;
                }
            }
            catch (InvalidLevelNameException e) {
                return new ColumnInfo(colName, ColumnType.INVALID, e.getLevelName(), levelIndex);
            }
            return new ColumnInfo(colName, ColumnType.INVALID);
        }

        private void checkLevelName(String expectedLevelName, String levelName) throws InvalidLevelNameException {
            if (expectedLevelName == null || !expectedLevelName.equals(levelName)) {
                throw new InvalidLevelNameException(expectedLevelName, levelName);
            }
        }

        static class InvalidLevelNameException
        extends Exception {
            private static final long serialVersionUID = 1L;
            private String levelName;

            public InvalidLevelNameException(String expectedLevelName, String levelName) {
                super(String.format("Invalid level name: expected %s found %s", expectedLevelName, levelName));
                this.levelName = levelName;
            }

            private String getLevelName() {
                return this.levelName;
            }
        }
    }

    public static class ColumnsInfo {
        private Map<String, ColumnInfo> infoByColumnName = new HashMap<String, ColumnInfo>();
        private List<String> levelNames = new ArrayList<String>();

        public void addColumnInfo(ColumnInfo columnInfo) {
            this.infoByColumnName.put(columnInfo.getColumnName(), columnInfo);
            if (columnInfo.getType() == ColumnType.CODE) {
                this.levelNames.add(columnInfo.getLevelName());
            }
        }

        public ColumnInfo getQualifiableColumnInfo(int levelIdx) {
            List<ColumnInfo> columnsInfo = this.getColumnInfosByType(levelIdx, ColumnType.QUALIFIABLE);
            return columnsInfo.isEmpty() ? null : columnsInfo.get(0);
        }

        private List<ColumnInfo> getColumnInfosByType(int levelIdx, ColumnType type) {
            ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
            Collection<ColumnInfo> values = this.infoByColumnName.values();
            for (ColumnInfo columnInfo : values) {
                if (columnInfo.getLevelIndex() != levelIdx || columnInfo.getType() != type) continue;
                result.add(columnInfo);
            }
            return result;
        }

        public List<ColumnInfo> getLabelColumnInfos(int levelIdx) {
            return this.getColumnInfosByType(levelIdx, ColumnType.LABEL);
        }

        public List<ColumnInfo> getDescriptionColumnInfos(int levelIdx) {
            return this.getColumnInfosByType(levelIdx, ColumnType.DESCRIPTION);
        }

        public ColumnInfo getInfo(String colName) {
            return this.infoByColumnName.get(colName);
        }

        public ColumnInfo getCodeColumnInfo(String levelName) {
            return this.infoByColumnName.get(levelName + CodeListCSVReader.CODE_COLUMN_SUFFIX);
        }

        public List<String> getLevelNames() {
            return this.levelNames;
        }
    }

    public static class ColumnInfo {
        private String columnName;
        ColumnType type;
        String levelName;
        Integer levelIndex;
        String langCode;

        public ColumnInfo(String columnName, ColumnType type) {
            this(columnName, type, null, null);
        }

        public ColumnInfo(String columnName, ColumnType type, String levelName, Integer levelIndex) {
            this(columnName, type, levelName, levelIndex, null);
        }

        public ColumnInfo(String columnName, ColumnType type, String levelName, Integer levelIndex, String langCode) {
            this.columnName = columnName;
            this.type = type;
            this.levelName = levelName;
            this.levelIndex = levelIndex;
            this.langCode = langCode;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public ColumnType getType() {
            return this.type;
        }

        public String getLevelName() {
            return this.levelName;
        }

        public Integer getLevelIndex() {
            return this.levelIndex;
        }

        public String getLangCode() {
            return this.langCode;
        }

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }
    }

    static enum ColumnType {
        CODE,
        LABEL,
        DESCRIPTION,
        QUALIFIABLE,
        INVALID;

    }

    public static class CodeListCSVLineParser
    extends CSVLineParser<CodeListLine> {
        CodeListCSVLineParser(CodeListCSVReader reader, CsvLine line) {
            super((DataImportReader)reader, line);
        }

        public static CodeListCSVLineParser createInstance(CodeListCSVReader reader, CsvLine line) {
            return new CodeListCSVLineParser(reader, line);
        }

        public CodeListLine parse() throws ParsingException {
            String level;
            String codeColumnName;
            String code;
            CodeListLine line = (CodeListLine)super.parse();
            ColumnsInfo columnsInfo = ((CodeListCSVReader)this.reader).getColumnsInfo();
            List<String> levels = columnsInfo.getLevelNames();
            for (int levelIdx = 0; levelIdx < levels.size() && (code = (String)this.getColumnValue(codeColumnName = columnsInfo.getCodeColumnInfo(level = levels.get(levelIdx)).getColumnName(), false, String.class)) != null; ++levelIdx) {
                String colValue;
                line.addLevelCode(code);
                for (ColumnInfo columnInfo : columnsInfo.getLabelColumnInfos(levelIdx)) {
                    colValue = (String)this.getColumnValue(columnInfo.getColumnName(), false, String.class);
                    if (colValue == null) continue;
                    line.addLabel(levelIdx, columnInfo.getLangCode(), colValue);
                }
                for (ColumnInfo columnInfo : columnsInfo.getDescriptionColumnInfos(levelIdx)) {
                    colValue = (String)this.getColumnValue(columnInfo.getColumnName(), false, String.class);
                    if (colValue == null) continue;
                    line.addDescription(levelIdx, columnInfo.getLangCode(), colValue);
                }
                ColumnInfo qualifiableColumnInfo = columnsInfo.getQualifiableColumnInfo(levelIdx);
                if (qualifiableColumnInfo == null) continue;
                String colValue2 = (String)this.getColumnValue(qualifiableColumnInfo.getColumnName(), false, String.class);
                boolean qualifiable = colValue2 != null && ("true".equalsIgnoreCase(colValue2) || "1".equals(colValue2));
                line.setQualifiable(levelIdx, qualifiable);
            }
            return line;
        }
    }
}

