/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.proxy.NodeDefinitionProxy;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;

public class EntityDefinitionProxy
extends NodeDefinitionProxy {
    private transient EntityDefinition entityDefinition;

    public EntityDefinitionProxy(EntityDefinitionProxy parent, EntityDefinition entityDefinition) {
        super(parent, (NodeDefinition)entityDefinition);
        this.entityDefinition = entityDefinition;
    }

    @ExternalizedProperty
    public List<NodeDefinitionProxy> getChildDefinitions() {
        return NodeDefinitionProxy.fromList(this, this.entityDefinition.getChildDefinitions());
    }

    @ExternalizedProperty
    public boolean isCountInSummaryList() {
        String annotation = this.entityDefinition.getAnnotation(CollectAnnotations.Annotation.COUNT_IN_SUMMARY_LIST.getQName());
        return annotation != null && Boolean.parseBoolean(annotation);
    }

    @ExternalizedProperty
    public boolean isEnumerable() {
        return this.entityDefinition.isMultiple() && this.entityDefinition.isEnumerable();
    }

    @ExternalizedProperty
    public boolean isEnumerate() {
        return this.entityDefinition.isEnumerate();
    }

    @ExternalizedProperty
    public String getLayout() {
        CollectSurvey survey = (CollectSurvey)this.entityDefinition.getSurvey();
        UIOptions uiOpts = survey.getUIOptions();
        UIOptions.Layout layout = uiOpts.getLayout(this.entityDefinition);
        return layout.name().toLowerCase(Locale.ENGLISH);
    }

    @ExternalizedProperty
    public UIOptions.Direction getDirection() {
        CollectSurvey survey = (CollectSurvey)this.entityDefinition.getSurvey();
        UIOptions uiOpts = survey.getUIOptions();
        UIOptions.Direction result = uiOpts.getDirection(this.entityDefinition);
        return result;
    }

    @ExternalizedProperty
    public boolean isShowRowNumbers() {
        String showRowNumbersString = this.entityDefinition.getAnnotation(CollectAnnotations.Annotation.SHOW_ROW_NUMBERS.getQName());
        if (StringUtils.isNotBlank((CharSequence)showRowNumbersString)) {
            boolean result = Boolean.parseBoolean(showRowNumbersString);
            return result;
        }
        return false;
    }

    @ExternalizedProperty
    public String getRootTabSetName() {
        if (this.parent != null) {
            return this.parent.getRootTabSetName();
        }
        String tabSetName = this.entityDefinition.getAnnotation(CollectAnnotations.Annotation.TAB_SET.getQName());
        return tabSetName;
    }

    @ExternalizedProperty
    public String getBackgroundColor() {
        return this.getAnnotations().getBackgroundColor((NodeDefinition)this.entityDefinition);
    }

    @ExternalizedProperty
    public Double getBackgroundAlpha() {
        return this.getAnnotations().getBackgroundAlpha((NodeDefinition)this.entityDefinition);
    }
}

