/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.List;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.proxy.AttributeDefinitionProxy;
import org.openforis.collect.metamodel.proxy.EntityDefinitionProxy;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.FileAttributeDefinition;

public class FileAttributeDefinitionProxy
extends AttributeDefinitionProxy {
    private static final String[] IMAGE_CONTENT_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "bmp"};
    private transient FileAttributeDefinition attributeDefinition;

    public FileAttributeDefinitionProxy(EntityDefinitionProxy parent, FileAttributeDefinition attributeDefinition) {
        super(parent, (AttributeDefinition)attributeDefinition);
        this.attributeDefinition = attributeDefinition;
    }

    @ExternalizedProperty
    public Integer getMaxSize() {
        return this.attributeDefinition.getMaxSize();
    }

    @ExternalizedProperty
    public List<String> getExtensions() {
        return this.attributeDefinition.getExtensions();
    }

    @ExternalizedProperty
    public boolean isImageContent() {
        CollectAnnotations.FileType fileType = this.getAnnotations().getFileType(this.attributeDefinition);
        return fileType == CollectAnnotations.FileType.IMAGE || FileAttributeDefinitionProxy.containsOne(this.attributeDefinition.getExtensions(), IMAGE_CONTENT_EXTENSIONS, true);
    }

    protected static boolean containsOne(List<String> list, String[] values, boolean caseSensitive) {
        for (String value : values) {
            if (!FileAttributeDefinitionProxy.contains(list, value, caseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected static boolean contains(List<String> list, String value, boolean caseSensitive) {
        if (caseSensitive) {
            return list.contains(value);
        }
        for (String item : list) {
            if (!item.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

