/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.ProxyContext;
import org.openforis.collect.metamodel.proxy.ModelVersionProxy;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.User;
import org.openforis.collect.model.proxy.BasicUserProxy;
import org.openforis.collect.model.proxy.UserProxy;
import org.openforis.collect.utils.Proxies;
import org.openforis.idm.metamodel.ModelVersion;

public class RecordSummaryProxy
implements Proxy {
    private transient CollectRecordSummary summary;
    private transient ProxyContext context;

    public RecordSummaryProxy(CollectRecordSummary summary, ProxyContext context) {
        this.summary = summary;
        this.context = context;
    }

    public static List<RecordSummaryProxy> fromList(List<CollectRecordSummary> summaries, ProxyContext context) {
        ArrayList<RecordSummaryProxy> result = new ArrayList<RecordSummaryProxy>();
        if (summaries != null) {
            for (CollectRecordSummary summary : summaries) {
                result.add(new RecordSummaryProxy(summary, context));
            }
        }
        return result;
    }

    @ExternalizedProperty
    public int getSurveyId() {
        return this.summary.getSurvey().getId();
    }

    @ExternalizedProperty
    public CollectRecord.Step getStep() {
        return this.summary.getStep();
    }

    @ExternalizedProperty
    public int getStepNumber() {
        return this.summary.getStep().getStepNumber();
    }

    @ExternalizedProperty
    public CollectRecord.State getState() {
        return null;
    }

    @ExternalizedProperty
    public Date getCreationDate() {
        return this.summary.getCreationDate();
    }

    @ExternalizedProperty
    public BasicUserProxy getCreatedBy() {
        User createdBy = this.summary.getCreatedBy();
        return createdBy == null ? null : new BasicUserProxy(createdBy);
    }

    @ExternalizedProperty
    public Date getModifiedDate() {
        return this.summary.getModifiedDate();
    }

    @ExternalizedProperty
    public Integer getId() {
        return this.summary.getId();
    }

    @ExternalizedProperty
    public BasicUserProxy getModifiedBy() {
        User modifiedBy = this.summary.getModifiedBy();
        return modifiedBy == null ? null : new BasicUserProxy(modifiedBy);
    }

    @ExternalizedProperty
    public ModelVersionProxy getVersion() {
        ModelVersion version = this.summary.getVersion();
        return version == null ? null : new ModelVersionProxy(version);
    }

    @ExternalizedProperty
    public List<String> getRootEntityKeys() {
        return this.summary.getRootEntityKeyValues();
    }

    @ExternalizedProperty
    public List<Integer> getEntityCounts() {
        return this.summary.getEntityCounts();
    }

    @ExternalizedProperty
    public boolean isEntryComplete() {
        if (this.summary.getStep() != null) {
            switch (this.summary.getStep()) {
                case ENTRY: {
                    return false;
                }
                case CLEANSING: 
                case ANALYSIS: {
                    return true;
                }
            }
        }
        return false;
    }

    @ExternalizedProperty
    public boolean isCleansingComplete() {
        if (this.summary.getStep() != null) {
            switch (this.summary.getStep()) {
                case ANALYSIS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @ExternalizedProperty
    public Map<CollectRecord.Step, CollectRecordSummary.StepSummary> getStepSummaries() {
        return this.summary.getStepSummaries();
    }

    @ExternalizedProperty
    public List<String> getSummaryValues() {
        return this.summary.getCurrentStepSummary().getSummaryValues();
    }

    @ExternalizedProperty
    public Integer getTotalErrors() {
        return this.summary.getCurrentStepSummary().getTotalErrors();
    }

    @ExternalizedProperty
    public Integer getErrors() {
        return this.summary.getCurrentStepSummary().getErrors();
    }

    @ExternalizedProperty
    public Integer getSkipped() {
        return this.summary.getCurrentStepSummary().getSkipped();
    }

    @ExternalizedProperty
    public Integer getMissing() {
        return this.summary.getCurrentStepSummary().getMissing();
    }

    @ExternalizedProperty
    public Integer getWarnings() {
        return this.summary.getCurrentStepSummary().getWarnings();
    }

    @ExternalizedProperty
    public Integer getMissingErrors() {
        return this.summary.getCurrentStepSummary().getMissingErrors();
    }

    @ExternalizedProperty
    public Integer getMissingWarnings() {
        return this.summary.getCurrentStepSummary().getMissingWarnings();
    }

    @ExternalizedProperty
    public UserProxy getOwner() {
        return Proxies.fromObject(this.summary.getOwner(), UserProxy.class);
    }

    @ExternalizedProperty
    public String getLockedBy() {
        return this.summary.getLockedBy();
    }
}

