/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.collect.model.proxy.SamplingDesignItemProxy;
import org.openforis.idm.metamodel.ReferenceDataSchema;

public class SamplingDesignSummariesProxy
implements Proxy {
    private transient SamplingDesignSummaries summaries;
    private transient CollectSurvey survey;

    public SamplingDesignSummariesProxy(CollectSurvey survey, SamplingDesignSummaries summaries) {
        this.survey = survey;
        this.summaries = summaries;
    }

    @ExternalizedProperty
    public List<SamplingDesignItemProxy> getRecords() {
        return SamplingDesignItemProxy.fromList(this.summaries.getRecords());
    }

    @ExternalizedProperty
    public int getTotalCount() {
        return this.summaries.getTotalCount();
    }

    @ExternalizedProperty
    public List<String> getInfoAttributes() {
        ReferenceDataSchema.SamplingPointDefinition samplingPoint;
        ReferenceDataSchema referenceDataSchema = this.survey.getReferenceDataSchema();
        ReferenceDataSchema.SamplingPointDefinition samplingPointDefinition = samplingPoint = referenceDataSchema == null ? null : referenceDataSchema.getSamplingPointDefinition();
        if (samplingPoint == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        List infoAttributes = samplingPoint.getAttributes(false);
        for (ReferenceDataSchema.ReferenceDataDefinition.Attribute attribute : infoAttributes) {
            result.add(attribute.getName());
        }
        return result;
    }
}

