/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import org.openforis.collect.manager.SamplingDesignManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.SamplingDesignSummaries;
import org.openforis.collect.model.proxy.SamplingDesignSummariesProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;

public class SamplingDesignService {
    @Autowired
    private SamplingDesignManager samplingDesignManager;
    @Autowired
    private SurveyManager surveyManager;

    @Secured(value={"ROLE_ADMIN"})
    public SamplingDesignSummariesProxy loadBySurvey(int surveyId, int offset, int maxRecords) {
        return this.loadBySurvey(false, surveyId, offset, maxRecords);
    }

    @Secured(value={"ROLE_ADMIN"})
    public SamplingDesignSummariesProxy loadBySurveyWork(int surveyId, int offset, int maxRecords) {
        return this.loadBySurvey(true, surveyId, offset, maxRecords);
    }

    protected SamplingDesignSummariesProxy loadBySurvey(boolean work, int surveyId, int offset, int maxRecords) {
        CollectSurvey survey = work ? this.surveyManager.loadSurvey(surveyId) : this.surveyManager.getById(surveyId);
        SamplingDesignSummaries summaries = this.samplingDesignManager.loadBySurvey(surveyId, offset, maxRecords);
        return new SamplingDesignSummariesProxy(survey, summaries);
    }
}

