/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service;

import java.util.List;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SpeciesManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.manager.TaxonSearchParameters;
import org.openforis.collect.metamodel.TaxonSummaries;
import org.openforis.collect.metamodel.proxy.TaxonSummariesProxy;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.CollectTaxonomy;
import org.openforis.collect.model.proxy.TaxonOccurrenceProxy;
import org.openforis.collect.model.proxy.TaxonomyProxy;
import org.openforis.collect.utils.Proxies;
import org.openforis.collect.web.session.SessionState;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.model.Node;
import org.openforis.idm.model.TaxonAttribute;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.annotation.Secured;

public class SpeciesService {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private SpeciesManager speciesManager;
    @Autowired
    @Qualifier(value="sessionManager")
    private SessionManager sessionManager;

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonomyProxy> loadTaxonomiesBySurvey(int surveyId, boolean work) {
        CollectSurvey survey = this.surveyManager.getOrLoadSurveyById(surveyId);
        List result = this.speciesManager.loadTaxonomiesBySurvey(survey);
        return Proxies.fromList(result, TaxonomyProxy.class);
    }

    @Secured(value={"ROLE_ADMIN"})
    public TaxonSummariesProxy loadTaxonSummaries(int taxonomyId, int offset, int maxRecords) {
        CollectSurvey survey = this.getActiveSurvey();
        TaxonSummaries summaries = this.speciesManager.loadTaxonSummaries(survey, taxonomyId, offset, maxRecords);
        return new TaxonSummariesProxy(summaries);
    }

    @Secured(value={"ROLE_ADMIN"})
    public TaxonomyProxy saveTaxonomy(TaxonomyProxy proxy) {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        Integer taxonomyId = proxy.getId();
        CollectTaxonomy taxonomy = taxonomyId == null ? new CollectTaxonomy() : this.speciesManager.loadTaxonomyById(survey, taxonomyId.intValue());
        String oldName = taxonomy.getName();
        String newName = proxy.getName();
        if (oldName != null && !oldName.equals(newName)) {
            this.updateTaxonAttributeDefinitions(oldName, newName);
        }
        proxy.copyPropertiesForUpdate(taxonomy);
        this.speciesManager.save(taxonomy);
        return new TaxonomyProxy(taxonomy);
    }

    protected void updateTaxonAttributeDefinitions(String oldName, String newName) {
        List<TaxonAttributeDefinition> defns = this.getTaxonAttributeDefinitionsForDesignerSurvey(oldName);
        if (!defns.isEmpty()) {
            for (TaxonAttributeDefinition defn : defns) {
                if (!defn.getTaxonomy().equals(oldName)) continue;
                defn.setTaxonomy(newName);
            }
            this.sessionManager.saveActiveDesignerSurvey();
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    public boolean isTaxonomyInUse(String taxonomyName) {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        Schema schema = survey.getSchema();
        List defns = schema.getTaxonAttributeDefinitions(taxonomyName);
        return !defns.isEmpty();
    }

    @Secured(value={"ROLE_ADMIN"})
    public void deleteTaxonomy(TaxonomyProxy proxy) {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        Integer taxonomyId = proxy.getId();
        CollectTaxonomy taxonomy = this.speciesManager.loadTaxonomyById(survey, taxonomyId.intValue());
        this.speciesManager.delete(taxonomy);
        this.deleteReferencingAttributes(taxonomy);
    }

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonOccurrenceProxy> findByFamilyCode(String taxonomyName, String searchString, int maxResults, TaxonSearchParameters parameters) {
        CollectTaxonomy taxonomy = this.loadTaxonomyByActiveSurvey(taxonomyName);
        List list = this.speciesManager.findByFamilyCode(taxonomy, searchString, maxResults, parameters);
        return Proxies.fromList(list, TaxonOccurrenceProxy.class);
    }

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonOccurrenceProxy> findByFamilyScientificName(String taxonomyName, String searchString, int maxResults, TaxonSearchParameters parameters) {
        CollectTaxonomy taxonomy = this.loadTaxonomyByActiveSurvey(taxonomyName);
        List list = this.speciesManager.findByFamilyScientificName(taxonomy, searchString, maxResults, parameters);
        return Proxies.fromList(list, TaxonOccurrenceProxy.class);
    }

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonOccurrenceProxy> findByCode(String taxonomyName, String searchString, int maxResults, TaxonSearchParameters parameters) {
        CollectTaxonomy taxonomy = this.loadTaxonomyByActiveSurvey(taxonomyName);
        List list = this.speciesManager.findByCode(taxonomy, searchString, maxResults, parameters);
        return Proxies.fromList(list, TaxonOccurrenceProxy.class);
    }

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonOccurrenceProxy> findByScientificName(String taxonomyName, String searchString, int maxResults, TaxonSearchParameters parameters) {
        CollectTaxonomy taxonomy = this.loadTaxonomyByActiveSurvey(taxonomyName);
        List list = this.speciesManager.findByScientificName(taxonomy, searchString, maxResults, parameters);
        return Proxies.fromList(list, TaxonOccurrenceProxy.class);
    }

    @Secured(value={"ROLE_ENTRY"})
    public List<TaxonOccurrenceProxy> findByVernacularName(String taxonomyName, int nodeId, String searchString, int maxResults, TaxonSearchParameters parameters) {
        CollectTaxonomy taxonomy = this.loadTaxonomyByActiveSurvey(taxonomyName);
        CollectRecord activeRecord = this.sessionManager.getActiveRecord();
        Node attr = activeRecord.getNodeByInternalId(nodeId);
        if (attr instanceof TaxonAttribute) {
            List list = this.speciesManager.findByVernacularName(taxonomy, (TaxonAttribute)attr, searchString, maxResults, parameters);
            return Proxies.fromList(list, TaxonOccurrenceProxy.class);
        }
        throw new IllegalArgumentException("TaxonAttribute expected, found: " + attr.getClass().getName());
    }

    private CollectSurvey getActiveSurvey() {
        SessionState sessionState = this.sessionManager.getSessionState();
        CollectSurvey activeSurvey = sessionState.getActiveSurvey();
        return activeSurvey;
    }

    protected CollectTaxonomy loadTaxonomyByActiveSurvey(String taxonomyName) {
        CollectSurvey activeSurvey = this.getActiveSurvey();
        return this.loadTaxonomy(activeSurvey, taxonomyName);
    }

    private CollectTaxonomy loadTaxonomy(CollectSurvey survey, String name) {
        return this.speciesManager.loadTaxonomyByName(survey, name);
    }

    protected List<TaxonAttributeDefinition> getTaxonAttributeDefinitionsForDesignerSurvey(String oldName) {
        CollectSurvey survey = this.sessionManager.getActiveDesignerSurvey();
        Schema schema = survey.getSchema();
        List defns = schema.getTaxonAttributeDefinitions(oldName);
        return defns;
    }

    protected void deleteReferencingAttributes(CollectTaxonomy taxonomy) {
        List<TaxonAttributeDefinition> defns = this.getTaxonAttributeDefinitionsForDesignerSurvey(taxonomy.getName());
        if (!defns.isEmpty()) {
            for (TaxonAttributeDefinition defn : defns) {
                EntityDefinition parent = (EntityDefinition)defn.getParentDefinition();
                parent.removeChildDefinition((NodeDefinition)defn);
            }
            this.sessionManager.saveActiveDesignerSurvey();
        }
    }
}

