/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service.recordindex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openforis.collect.manager.RecordIndexException;
import org.openforis.collect.manager.RecordIndexManager;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.remoting.service.RecordIndexProcess;
import org.openforis.collect.remoting.service.recordindex.VolatileRecordIndexManager;
import org.openforis.collect.utils.ExecutorServiceUtil;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.Schema;
import org.openforis.idm.metamodel.Survey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RecordIndexService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    @Qualifier(value="persistedRecordIndexManager")
    private transient RecordIndexManager persistedIndexManager;
    @Autowired
    @Qualifier(value="volatileRecordIndexManager")
    private transient VolatileRecordIndexManager volatileIndexManager;
    private transient RecordIndexProcess indexProcess;

    public List<String> search(RecordIndexManager.SearchType searchType, Survey survey, int attributeDefnId, int fieldIndex, String queryText, int maxResults) throws RecordIndexException {
        Schema schema = survey.getSchema();
        AttributeDefinition defn = (AttributeDefinition)schema.getDefinitionById(attributeDefnId);
        String indexName = defn.getAnnotation(CollectAnnotations.Annotation.AUTOCOMPLETE.getQName());
        if (StringUtils.isNotBlank((CharSequence)indexName)) {
            try {
                List tempResult = this.volatileIndexManager.search(searchType, survey, attributeDefnId, fieldIndex, queryText, maxResults);
                List committedResult = this.persistedIndexManager.search(searchType, survey, attributeDefnId, fieldIndex, queryText, maxResults);
                List<String> result = this.mergeSearchResults(maxResults, tempResult, committedResult);
                return result;
            }
            catch (Exception e) {
                throw new RecordIndexException((Throwable)e);
            }
        }
        throw new RecordIndexException("Index name is not defined for attribute with id: " + attributeDefnId);
    }

    public void temporaryIndex(CollectRecord record) throws RecordIndexException {
        this.volatileIndexManager.index(record);
    }

    public void permanentlyIndex(CollectRecord record) {
        if (this.indexProcess != null && this.indexProcess.isRunning()) {
            this.indexProcess.cancel();
        }
        this.indexProcess = new RecordIndexProcess(this.persistedIndexManager, record);
        ExecutorServiceUtil.executeInCachedPool((Runnable)this.indexProcess);
    }

    public boolean hasIndexableNodes(EntityDefinition rootEntityDefn) {
        return this.volatileIndexManager.hasIndexableNodes(rootEntityDefn);
    }

    protected List<String> mergeSearchResults(int maxResults, Collection<String> tempResult, Collection<String> committedResult) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(tempResult);
        result.addAll(committedResult);
        List<String> sortedList = this.sortResults(result);
        if (sortedList.size() > maxResults) {
            sortedList = sortedList.subList(0, maxResults - 1);
        }
        return sortedList;
    }

    protected List<String> sortResults(Collection<String> result) {
        ArrayList<String> sortedList = new ArrayList<String>(result);
        Collections.sort(sortedList);
        return sortedList;
    }

    public void cleanTemporaryIndex() throws RecordIndexException {
        this.volatileIndexManager.cleanIndex();
    }

    public boolean isInited() {
        return this.persistedIndexManager.isInited();
    }
}

