/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.io.metadata.codelist;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.io.metadata.codelist.CodeListImportTask;
import org.openforis.collect.io.metadata.parsing.ParsingError;
import org.openforis.collect.manager.CodeListManager;
import org.openforis.concurrency.Job;
import org.openforis.concurrency.Worker;
import org.openforis.idm.metamodel.CodeList;

public class CodeListImportJob
extends Job {
    private static final String IMPORTING_FILE_ERROR_MESSAGE_KEY = "codeListImport.error.internalErrorImportingFile";
    private static final String WRONG_FILE_TYPE_ERROR_MESSAGE_KEY = "codeListImport.error.wrongFileType";
    private CodeListManager codeListManager;
    private File file;
    private CodeList codeList;
    private boolean overwriteData;
    private InputStream is;

    protected void createInternalVariables() throws Throwable {
        super.createInternalVariables();
        this.is = new FileInputStream(this.file);
    }

    protected void validateInput() throws Throwable {
        if (!this.file.exists() && !this.file.canRead()) {
            this.setErrorMessage(IMPORTING_FILE_ERROR_MESSAGE_KEY);
            this.changeStatus(Worker.Status.FAILED);
        } else if (!this.validateFile()) {
            this.setErrorMessage(WRONG_FILE_TYPE_ERROR_MESSAGE_KEY);
            this.changeStatus(Worker.Status.FAILED);
        }
    }

    private boolean validateFile() {
        return true;
    }

    protected void buildTasks() throws Throwable {
        this.addTask((Worker)new CodeListImportTask());
    }

    protected void initializeTask(Worker task) {
        CodeListImportTask t = (CodeListImportTask)task;
        t.setCodeListManager(this.codeListManager);
        t.setInputStream(this.is);
        t.setCodeList(this.codeList);
        t.setOverwriteData(this.overwriteData);
        super.initializeTask((Worker)t);
    }

    protected void onEnd() {
        super.onEnd();
        IOUtils.closeQuietly((InputStream)this.is);
    }

    public List<ParsingError> getErrors() {
        return this.getTasks().isEmpty() ? null : ((CodeListImportTask)((Object)this.getTasks().get(0))).getErrors();
    }

    public void setCodeListManager(CodeListManager codeListManager) {
        this.codeListManager = codeListManager;
    }

    public void setCodeList(CodeList codeList) {
        this.codeList = codeList;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOverwriteData(boolean overwriteData) {
        this.overwriteData = overwriteData;
    }
}

