/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.metamodel.proxy.EntityDefinitionProxy;
import org.openforis.collect.metamodel.proxy.FieldLabelProxy;
import org.openforis.collect.metamodel.proxy.NodeDefinitionProxy;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.TextAttributeDefinition;

public abstract class AttributeDefinitionProxy
extends NodeDefinitionProxy
implements Proxy {
    private transient AttributeDefinition attributeDefinition;

    public AttributeDefinitionProxy(EntityDefinitionProxy parent, AttributeDefinition attributeDefinition) {
        super(parent, (NodeDefinition)attributeDefinition);
        this.attributeDefinition = attributeDefinition;
    }

    @ExternalizedProperty
    public boolean isKey() {
        return this.attributeDefinition.isKey();
    }

    @ExternalizedProperty
    public boolean isDefaultValueApplicable() {
        return !this.attributeDefinition.getAttributeDefaults().isEmpty();
    }

    @ExternalizedProperty
    public boolean isAutocomplete() {
        if (this.attributeDefinition instanceof TextAttributeDefinition) {
            String autoCompleteGroup = this.getAnnotations().getAutoCompleteGroup((TextAttributeDefinition)this.attributeDefinition);
            return StringUtils.isNotBlank((CharSequence)autoCompleteGroup);
        }
        return false;
    }

    @ExternalizedProperty
    public List<Integer> getVisibleFieldIndexes() {
        String[] fieldNames;
        ArrayList<Integer> result = new ArrayList<Integer>();
        UIOptions uiOptions = this.getUIOptions();
        for (String fieldName : fieldNames = uiOptions.getVisibleFields(this.attributeDefinition)) {
            int fieldIdx = this.attributeDefinition.getFieldNames().indexOf(fieldName);
            if (fieldIdx < 0) {
                throw new IllegalStateException(String.format("Field %s not found in attribute definition %s", fieldName, this.attributeDefinition.getName()));
            }
            result.add(fieldIdx);
        }
        return result;
    }

    protected boolean isFieldVisible(String field) {
        UIOptions uiOptions = this.getUIOptions();
        return uiOptions.isVisibleField(this.attributeDefinition, field);
    }

    @ExternalizedProperty
    public boolean isCalculated() {
        return this.attributeDefinition.isCalculated();
    }

    @ExternalizedProperty
    public List<FieldLabelProxy> getFieldLabels() {
        return FieldLabelProxy.fromFieldLabelList(this.attributeDefinition.getFieldLabels());
    }

    @ExternalizedProperty
    public boolean isEditable() {
        return this.getAnnotations().isEditable(this.attributeDefinition);
    }
}

