/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.designer.form;

import org.openforis.collect.designer.form.FormObject;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.model.CollectSurvey;
import org.springframework.util.StringUtils;

public class SurveyMainInfoFormObject
extends FormObject<CollectSurvey> {
    private String name;
    private boolean published;
    private String description;
    private String projectName;
    private String collectEarthSamplePoints;
    private String collectEarthPlotArea;
    private String bingMapsKey;
    private String planetMapsKey;
    private String extraMapUrl;
    private boolean openBingMaps;
    private boolean openEarthMap;
    private boolean openPlanetMaps;
    private boolean openYandexMaps;
    private boolean openGEEExplorer;
    private boolean openGEECodeEditor;
    private boolean openGEEApp;
    private boolean openSecureWatch;
    private boolean openStreetView;
    private String defaultDescription;
    private String defaultProjectName;
    private boolean keyChangeAllowed;

    @Override
    public void loadFrom(CollectSurvey source, String languageCode) {
        this.name = source.getName();
        this.description = source.getDescription(languageCode);
        this.published = source.isPublished();
        this.projectName = source.getProjectName(languageCode);
        this.defaultProjectName = source.getProjectName();
        this.defaultDescription = source.getDescription();
        CollectAnnotations annotations = source.getAnnotations();
        this.collectEarthPlotArea = this.toListitemValue(annotations.getCollectEarthPlotArea());
        this.collectEarthSamplePoints = String.valueOf(annotations.getCollectEarthSamplePoints());
        this.bingMapsKey = annotations.getBingMapsKey();
        this.planetMapsKey = annotations.getPlanetMapsKey();
        this.extraMapUrl = annotations.getExtraMapUrl();
        this.openBingMaps = annotations.isBingMapsEnabled();
        this.openEarthMap = annotations.isEarthMapEnabled();
        this.openPlanetMaps = annotations.isPlanetMapsEnabled();
        this.openYandexMaps = annotations.isYandexMapsEnabled();
        this.openStreetView = annotations.isStreetViewEnabled();
        this.openGEEExplorer = annotations.isGEEExplorerEnabled();
        this.openGEECodeEditor = annotations.isGEECodeEditorEnabled();
        this.openGEEApp = annotations.isGEEAppEnabled();
        this.openSecureWatch = annotations.isSecureWatchEnabled();
        this.keyChangeAllowed = annotations.isKeyChangeAllowed();
    }

    protected String toListitemValue(Double number) {
        return StringUtils.trimTrailingCharacter((String)StringUtils.trimTrailingCharacter((String)number.toString().replace('.', '_'), (char)'0'), (char)'_');
    }

    @Override
    public void saveTo(CollectSurvey dest, String languageCode) {
        dest.setName(this.name);
        dest.setDescription(languageCode, this.description);
        dest.setProjectName(languageCode, this.projectName);
        dest.setPublished(this.published);
        CollectAnnotations annotations = dest.getAnnotations();
        annotations.setCollectEarthPlotArea(Double.valueOf(this.fromListitemValueToDouble(this.collectEarthPlotArea)));
        annotations.setCollectEarthSamplePoints(Integer.valueOf(Integer.parseInt(this.collectEarthSamplePoints)));
        annotations.setBingMapsKey(this.bingMapsKey);
        annotations.setPlanetMapsKey(this.planetMapsKey);
        annotations.setExtraMapUrl(this.extraMapUrl);
        annotations.setBingMapsEnabled(this.openBingMaps);
        annotations.setEarthMapEnabled(this.openEarthMap);
        annotations.setPlanetMapsEnabled(this.openPlanetMaps);
        annotations.setYandexMapsEnabled(this.openYandexMaps);
        annotations.setStreetViewEnabled(this.openStreetView);
        annotations.setGEECodeEditorEnabled(this.openGEECodeEditor);
        annotations.setGEEAppEnabled(this.openGEEApp);
        annotations.setSecureWatchEnabled(this.openSecureWatch);
        annotations.setGEEExplorerEnabled(this.openGEEExplorer);
        annotations.setKeyChangeAllowed(this.keyChangeAllowed);
    }

    protected double fromListitemValueToDouble(String value) {
        return Double.parseDouble(value.replace('_', '.'));
    }

    @Override
    protected void reset() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPublished() {
        return this.published;
    }

    public String getPlanetMapsKey() {
        return this.planetMapsKey;
    }

    public void setPlanetMapsKey(String planetMapsKey) {
        this.planetMapsKey = planetMapsKey;
    }

    public boolean isOpenPlanetMaps() {
        return this.openPlanetMaps;
    }

    public void setOpenPlanetMaps(boolean openPlanetMaps) {
        this.openPlanetMaps = openPlanetMaps;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCollectEarthSamplePoints() {
        return this.collectEarthSamplePoints;
    }

    public void setCollectEarthSamplePoints(String collectEarthSamplePoints) {
        this.collectEarthSamplePoints = collectEarthSamplePoints;
    }

    public String getCollectEarthPlotArea() {
        return this.collectEarthPlotArea;
    }

    public void setCollectEarthPlotArea(String collectEarthPlotArea) {
        this.collectEarthPlotArea = collectEarthPlotArea;
    }

    public String getBingMapsKey() {
        return this.bingMapsKey;
    }

    public void setBingMapsKey(String bingMapsKey) {
        this.bingMapsKey = bingMapsKey;
    }

    public String getExtraMapUrl() {
        return this.extraMapUrl;
    }

    public void setExtraMapUrl(String extraMapUrl) {
        this.extraMapUrl = extraMapUrl;
    }

    public boolean isOpenBingMaps() {
        return this.openBingMaps;
    }

    public void setOpenBingMaps(boolean openBingMaps) {
        this.openBingMaps = openBingMaps;
    }

    public boolean isOpenEarthMap() {
        return this.openEarthMap;
    }

    public void setOpenEarthMap(boolean openEarthMap) {
        this.openEarthMap = openEarthMap;
    }

    public boolean isOpenYandexMaps() {
        return this.openYandexMaps;
    }

    public void setOpenYandexMaps(boolean openYandexMaps) {
        this.openYandexMaps = openYandexMaps;
    }

    public boolean isOpenGEEExplorer() {
        return this.openGEEExplorer;
    }

    public void setOpenGEEExplorer(boolean openGEEExplorer) {
        this.openGEEExplorer = openGEEExplorer;
    }

    public boolean isOpenGEECodeEditor() {
        return this.openGEECodeEditor;
    }

    public void setOpenGEECodeEditor(boolean openGEECodeEditor) {
        this.openGEECodeEditor = openGEECodeEditor;
    }

    public boolean isOpenGEEApp() {
        return this.openGEEApp;
    }

    public void setOpenGEEApp(boolean openGEEApp) {
        this.openGEEApp = openGEEApp;
    }

    public boolean isOpenSecureWatch() {
        return this.openSecureWatch;
    }

    public void setOpenSecureWatch(boolean openSecureWatch) {
        this.openSecureWatch = openSecureWatch;
    }

    public boolean isOpenStreetView() {
        return this.openStreetView;
    }

    public void setOpenStreetView(boolean openStreetView) {
        this.openStreetView = openStreetView;
    }

    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public boolean isKeyChangeAllowed() {
        return this.keyChangeAllowed;
    }

    public void setKeyChangeAllowed(boolean keyChangeAllowed) {
        this.keyChangeAllowed = keyChangeAllowed;
    }
}

