/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.metamodel.TaxonSummary;
import org.openforis.idm.model.species.Taxon;

public class TaxonSummaryProxy
implements Proxy {
    private transient TaxonSummary summary;

    public TaxonSummaryProxy(TaxonSummary summary) {
        this.summary = summary;
    }

    public static List<TaxonSummaryProxy> fromList(List<TaxonSummary> list) {
        ArrayList<TaxonSummaryProxy> proxies = new ArrayList<TaxonSummaryProxy>();
        if (list != null) {
            for (TaxonSummary item : list) {
                TaxonSummaryProxy proxy = new TaxonSummaryProxy(item);
                proxies.add(proxy);
            }
        }
        return proxies;
    }

    @ExternalizedProperty
    public String getCode() {
        return this.summary.getCode();
    }

    @ExternalizedProperty
    public Map<String, List<String>> getVernacularNamesByLanguage() {
        return this.summary.getLanguageToVernacularNames();
    }

    @ExternalizedProperty
    public Map<String, String> getInfoByName() {
        return this.summary.getInfoByName();
    }

    @ExternalizedProperty
    public Taxon.TaxonRank getRank() {
        return this.summary.getRank();
    }

    @ExternalizedProperty
    public String getScientificName() {
        return this.summary.getScientificName();
    }

    @ExternalizedProperty
    public Integer getTaxonId() {
        return this.summary.getTaxonId();
    }

    @ExternalizedProperty
    public long getTaxonSystemId() {
        return this.summary.getTaxonSystemId();
    }

    @ExternalizedProperty
    public List<String> getVernacularLanguages() {
        return this.summary.getVernacularLanguages();
    }
}

