/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.model.proxy;

import java.util.ArrayList;
import java.util.List;
import org.granite.messaging.amf.io.util.externalizer.annotation.ExternalizedProperty;
import org.openforis.collect.Proxy;
import org.openforis.collect.model.SamplingDesignItem;

public class SamplingDesignItemProxy
implements Proxy {
    private transient SamplingDesignItem item;
    private String srsId;
    private double x;
    private double y;

    public SamplingDesignItemProxy(SamplingDesignItem item) {
        this.item = item;
        this.srsId = item.getSrsId();
        this.x = item.getX();
        this.y = item.getY();
    }

    public static List<SamplingDesignItemProxy> fromList(List<SamplingDesignItem> list) {
        ArrayList<SamplingDesignItemProxy> result = new ArrayList<SamplingDesignItemProxy>();
        if (list != null) {
            for (SamplingDesignItem item : list) {
                SamplingDesignItemProxy proxy = new SamplingDesignItemProxy(item);
                result.add(proxy);
            }
        }
        return result;
    }

    @ExternalizedProperty
    public Long getId() {
        return this.item.getId();
    }

    @ExternalizedProperty
    public int getLevel() {
        return this.item.getLevel();
    }

    @ExternalizedProperty
    public List<String> getLevelCodes() {
        return this.item.getLevelCodes();
    }

    @ExternalizedProperty
    public List<String> getInfos() {
        return this.item.getInfoAttributes();
    }

    public String getSrsId() {
        return this.srsId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

