/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openforis.collect.command.AddAttributeCommand;
import org.openforis.collect.command.AddEntityCommand;
import org.openforis.collect.command.Command;
import org.openforis.collect.command.CommandDispatcher;
import org.openforis.collect.command.CreateRecordCommand;
import org.openforis.collect.command.CreateRecordPreviewCommand;
import org.openforis.collect.command.DeleteAttributeCommand;
import org.openforis.collect.command.DeleteEntityCommand;
import org.openforis.collect.command.DeleteRecordCommand;
import org.openforis.collect.command.RecordCommand;
import org.openforis.collect.command.UpdateAttributeCommand;
import org.openforis.collect.command.UpdateBooleanAttributeCommand;
import org.openforis.collect.command.UpdateCodeAttributeCommand;
import org.openforis.collect.command.UpdateCoordinateAttributeCommand;
import org.openforis.collect.command.UpdateDateAttributeCommand;
import org.openforis.collect.command.UpdateIntegerAttributeCommand;
import org.openforis.collect.command.UpdateRealAttributeCommand;
import org.openforis.collect.command.UpdateTextAttributeCommand;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.event.EventListener;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.manager.SessionManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.web.ws.AppWS;
import org.openforis.commons.web.Response;
import org.openforis.idm.metamodel.NumericAttributeDefinition;
import org.openforis.idm.metamodel.Unit;
import org.openforis.idm.model.BooleanValue;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.Date;
import org.openforis.idm.model.IntegerValue;
import org.openforis.idm.model.RealValue;
import org.openforis.idm.model.TextValue;
import org.openforis.idm.model.Value;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="session")
@RequestMapping(value={"api/command"})
public class CommandController {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CommandDispatcher commandDispatcher;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AppWS appWS;

    @RequestMapping(value={"record"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response createRecord(@RequestBody CreateRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record_preview"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public List<RecordEventView> createRecordPreview(@RequestBody CreateRecordPreviewCommand command) {
        return this.submitCommandSync((Command)command);
    }

    @RequestMapping(value={"record"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response deleteRecord(@RequestBody DeleteRecordCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attribute/new"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addAttribute(@RequestBody AddAttributeCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attributes"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Response addOrUpdateAttributes(@RequestBody UpdateAttributesCommandWrapper commandsWrapper) {
        List<UpdateAttributeCommandWrapper> commands = commandsWrapper.getCommands();
        if (!commands.isEmpty()) {
            CollectSurvey survey = this.getSurvey((RecordCommand)commands.get(0));
            commands.forEach(c -> {
                UpdateAttributeCommand<Value> command = c.toCommand(survey);
                this.submitCommand((Command)command);
            });
        }
        return new Response();
    }

    @RequestMapping(value={"record/attribute"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object updateAttribute(@RequestBody UpdateAttributeCommandWrapper commandWrapper) {
        CollectSurvey survey = this.getSurvey((RecordCommand)commandWrapper);
        UpdateAttributeCommand<Value> command = commandWrapper.toCommand(survey);
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/attiribute/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteAttribute(@RequestBody DeleteAttributeCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/entity"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object addEntity(@RequestBody AddEntityCommand command) {
        return this.submitCommand((Command)command);
    }

    @RequestMapping(value={"record/entity/delete"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Transactional
    @ResponseBody
    public Object deleteEntity(@RequestBody DeleteEntityCommand command) {
        return this.submitCommand((Command)command);
    }

    private Response submitCommand(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        this.commandDispatcher.submit(command, new EventListener(){

            public void onEvent(RecordEvent event) {
                CommandController.this.appWS.sendMessage(new AppWS.RecordEventMessage(new RecordEventView(event)));
            }
        });
        return new Response();
    }

    private List<RecordEventView> submitCommandSync(Command command) {
        if (command instanceof RecordCommand) {
            ((RecordCommand)command).setUsername(this.sessionManager.getLoggedUsername());
        }
        List events = this.commandDispatcher.submitSync(command);
        ArrayList<RecordEventView> result = new ArrayList<RecordEventView>(events.size());
        for (RecordEvent event : events) {
            result.add(new RecordEventView(event));
        }
        return result;
    }

    private CollectSurvey getSurvey(RecordCommand command) {
        return this.surveyManager.getOrLoadSurveyById(command.getSurveyId());
    }

    static class UpdateAttributeCommandWrapper
    extends UpdateAttributeCommand<Value> {
        private static final long serialVersionUID = 1L;
        AttributeType attributeType;
        NumericAttributeDefinition.Type numericType;
        Map<String, Object> valueByField;

        UpdateAttributeCommandWrapper() {
        }

        Value extractValue(CollectSurvey survey) {
            if (this.valueByField == null) {
                return null;
            }
            switch (this.attributeType) {
                case BOOLEAN: {
                    return new BooleanValue((Boolean)this.valueByField.get("value"));
                }
                case CODE: {
                    return new Code((String)this.valueByField.get("code"), (String)this.valueByField.get("qualifier"));
                }
                case COORDINATE: {
                    Number xValue = (Number)this.valueByField.get("x");
                    Number yValue = (Number)this.valueByField.get("y");
                    Number altitudeValue = (Number)this.valueByField.get("altitude");
                    Number accuracyValue = (Number)this.valueByField.get("accuracy");
                    String srsId = (String)this.valueByField.get("srs");
                    Double x = xValue == null ? null : Double.valueOf(xValue.doubleValue());
                    Double y = yValue == null ? null : Double.valueOf(yValue.doubleValue());
                    Double altitude = altitudeValue == null ? null : Double.valueOf(altitudeValue.doubleValue());
                    Double accuracy = accuracyValue == null ? null : Double.valueOf(accuracyValue.doubleValue());
                    return new Coordinate(x, y, srsId, altitude, accuracy);
                }
                case DATE: {
                    return new Date((Integer)this.valueByField.get("year"), (Integer)this.valueByField.get("month"), (Integer)this.valueByField.get("day"));
                }
                case NUMBER: {
                    Integer unitId = (Integer)this.valueByField.get("unit");
                    Unit unit = unitId == null ? null : survey.getUnit(unitId.intValue());
                    Number number = (Number)this.valueByField.get("value");
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? new IntegerValue(number == null ? null : Integer.valueOf(number.intValue()), unit) : new RealValue(number == null ? null : Double.valueOf(number.doubleValue()), unit);
                }
                case TEXT: {
                    return new TextValue((String)this.valueByField.get("value"));
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public UpdateAttributeCommand<Value> toCommand(CollectSurvey survey) {
            Class<UpdateAttributeCommand<?>> commandType = this.toCommandType();
            try {
                UpdateAttributeCommand<?> c = commandType.getConstructor(new Class[0]).newInstance(new Object[0]);
                BeanUtils.copyProperties((Object)((Object)this), c, (String[])new String[]{"attributeType", "value"});
                c.setValue(this.extractValue(survey));
                return c;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<? extends UpdateAttributeCommand<?>> toCommandType() {
            switch (this.attributeType) {
                case BOOLEAN: {
                    return UpdateBooleanAttributeCommand.class;
                }
                case CODE: {
                    return UpdateCodeAttributeCommand.class;
                }
                case COORDINATE: {
                    return UpdateCoordinateAttributeCommand.class;
                }
                case DATE: {
                    return UpdateDateAttributeCommand.class;
                }
                case NUMBER: {
                    return this.numericType == NumericAttributeDefinition.Type.INTEGER ? UpdateIntegerAttributeCommand.class : UpdateRealAttributeCommand.class;
                }
                case TEXT: {
                    return UpdateTextAttributeCommand.class;
                }
            }
            throw new IllegalStateException("Unsupported command type: " + (Object)((Object)this.attributeType));
        }

        public AttributeType getAttributeType() {
            return this.attributeType;
        }

        public void setAttributeType(AttributeType attributeType) {
            this.attributeType = attributeType;
        }

        public NumericAttributeDefinition.Type getNumericType() {
            return this.numericType;
        }

        public void setNumericType(NumericAttributeDefinition.Type numericType) {
            this.numericType = numericType;
        }

        public Map<String, Object> getValueByField() {
            return this.valueByField;
        }

        public void setValueByField(Map<String, Object> valueByField) {
            this.valueByField = valueByField;
        }
    }

    static class UpdateAttributesCommandWrapper {
        List<UpdateAttributeCommandWrapper> commands = new ArrayList<UpdateAttributeCommandWrapper>();

        UpdateAttributesCommandWrapper() {
        }

        public List<UpdateAttributeCommandWrapper> getCommands() {
            return this.commands;
        }

        public void setCommands(List<UpdateAttributeCommandWrapper> commands) {
            this.commands = commands;
        }
    }

    static class RecordEventView {
        private RecordEvent event;

        public RecordEventView(RecordEvent event) {
            this.event = event;
        }

        public String getEventType() {
            return this.event.getClass().getSimpleName();
        }

        public RecordEvent getEvent() {
            return this.event;
        }
    }
}

