/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.web.manager;

import java.util.HashMap;
import java.util.Map;
import org.openforis.collect.manager.CachedRecordProvider;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectSurvey;

public class RecordProviderSession
extends CachedRecordProvider {
    private CachedRecordProvider delegate;
    private Map<Integer, CollectRecord> recordsPreviewBySurvey = new HashMap<Integer, CollectRecord>();

    public RecordProviderSession(CachedRecordProvider cachedRecordProvider) {
        super(null);
        this.delegate = cachedRecordProvider;
    }

    public CollectRecord provide(CollectSurvey survey, Integer recordId, CollectRecord.Step recordStep) {
        if (recordId == null) {
            return this.recordsPreviewBySurvey.get(survey.getId());
        }
        return this.delegate.provide(survey, recordId, recordStep);
    }

    public void putRecord(CollectRecord record) {
        if (record.isPreview()) {
            this.recordsPreviewBySurvey.put(record.getSurvey().getId(), record);
        } else {
            this.delegate.putRecord(record);
        }
    }

    public void clearRecords(int surveyId) {
        this.delegate.clearRecords(surveyId);
        this.recordsPreviewBySurvey.remove(surveyId);
    }
}

