/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.metamodel.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openforis.collect.designer.metamodel.AttributeType;
import org.openforis.collect.metamodel.CollectAnnotations;
import org.openforis.collect.metamodel.ui.UIModelObject;
import org.openforis.collect.metamodel.ui.UIOptions;
import org.openforis.collect.metamodel.uiconfiguration.view.Views;
import org.openforis.collect.metamodel.view.AttributeDefView;
import org.openforis.collect.metamodel.view.CodeAttributeDefView;
import org.openforis.collect.metamodel.view.CodeListItemView;
import org.openforis.collect.metamodel.view.CodeListView;
import org.openforis.collect.metamodel.view.CoordinateAttributeDefView;
import org.openforis.collect.metamodel.view.EntityDefView;
import org.openforis.collect.metamodel.view.ModelVersionView;
import org.openforis.collect.metamodel.view.NodeDefView;
import org.openforis.collect.metamodel.view.NumberAttributeDefView;
import org.openforis.collect.metamodel.view.PrecisionView;
import org.openforis.collect.metamodel.view.SpatialReferenceSystemView;
import org.openforis.collect.metamodel.view.SurveyView;
import org.openforis.collect.metamodel.view.UnitView;
import org.openforis.collect.metamodel.view.ViewContext;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.UserGroup;
import org.openforis.collect.model.UserInGroup;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CodeList;
import org.openforis.idm.metamodel.CodeListItem;
import org.openforis.idm.metamodel.CodeListLabel;
import org.openforis.idm.metamodel.CodeListService;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.ModelVersion;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NodeDefinitionVisitor;
import org.openforis.idm.metamodel.NodeLabel;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.SpatialReferenceSystem;
import org.openforis.idm.metamodel.Unit;

public class SurveyViewGenerator {
    private boolean includeCodeListValues = false;
    private String languageCode;

    public SurveyViewGenerator(String languageCode) {
        this.languageCode = languageCode;
    }

    public List<SurveyView> generateViews(List<CollectSurvey> surveys) {
        ArrayList<SurveyView> result = new ArrayList<SurveyView>();
        for (CollectSurvey s : surveys) {
            result.add(this.generateView(s));
        }
        return result;
    }

    public SurveyView generateView(CollectSurvey survey) {
        return this.generateView(survey, null, null);
    }

    public SurveyView generateView(final CollectSurvey survey, UserGroup userGroup, UserInGroup.UserGroupRole userInSurveyGroupRole) {
        String defaultLanguage = survey.getDefaultLanguage();
        final CollectAnnotations annotations = survey.getAnnotations();
        final UIOptions uiOptions = survey.getUIOptions();
        final SurveyView surveyView = new SurveyView(survey, new ViewContext(this.languageCode));
        if (userGroup != null) {
            surveyView.setUserGroupQualifierName(userGroup.getQualifierName());
            surveyView.setUserGroupQualifierValue(userGroup.getQualifierValue());
            surveyView.setUserInGroupRole(userInSurveyGroupRole);
        }
        for (CodeList codeList : survey.getCodeLists()) {
            CodeListView codeListView = new CodeListView();
            codeListView.setId(codeList.getId());
            codeListView.setName(codeList.getName());
            codeListView.setLabel(codeList.getLabel(CodeListLabel.Type.ITEM, this.languageCode));
            if (this.includeCodeListValues && !codeList.isExternal()) {
                CodeListService service = survey.getContext().getCodeListService();
                List items = service.loadRootItems(codeList);
                for (CodeListItem item : items) {
                    codeListView.addItem(this.createCodeListItemView(item));
                }
            }
            surveyView.addCodeList(codeListView);
        }
        for (ModelVersion version : survey.getVersions()) {
            ModelVersionView versionView = new ModelVersionView();
            versionView.setId(version.getId());
            versionView.setName(version.getName());
            versionView.setLabel(version.getLabel(this.languageCode));
            versionView.setDate(version.getDate());
            surveyView.addModelVersion(versionView);
        }
        for (Unit unit : survey.getUnits()) {
            UnitView unitView = new UnitView();
            unitView.setId(unit.getId());
            unitView.setConversionFactor(unit.getConversionFactor());
            unitView.setAbbreviation(unit.getAbbreviation(this.languageCode, defaultLanguage));
            unitView.setLabel(unit.getLabel(this.languageCode, defaultLanguage));
            surveyView.addUnit(unitView);
        }
        for (SpatialReferenceSystem srs : survey.getSpatialReferenceSystems()) {
            SpatialReferenceSystemView srsView = new SpatialReferenceSystemView();
            srsView.setId(srs.getId());
            srsView.setLabel(srs.getLabel(this.languageCode, defaultLanguage));
            srsView.setDescription(srs.getDescription(this.languageCode, defaultLanguage));
            surveyView.addSpatialReferenceSystem(srsView);
        }
        final HashMap viewById = new HashMap();
        survey.getSchema().traverse(new NodeDefinitionVisitor(){

            public void visit(NodeDefinition def) {
                NodeDefView view;
                int id = def.getId();
                String name = def.getName();
                String label = SurveyViewGenerator.this.getLabel(def);
                if (def instanceof EntityDefinition) {
                    view = new EntityDefView(((EntityDefinition)def).isRoot(), id, name, label, def.isMultiple());
                } else {
                    CodeAttributeDefinition attrDef;
                    boolean qualifier = annotations.isQualifier((AttributeDefinition)def);
                    boolean showInSummary = annotations.isShowInSummary((AttributeDefinition)def);
                    if (def instanceof CodeAttributeDefinition) {
                        attrDef = (CodeAttributeDefinition)def;
                        int codeListId = attrDef.getList() == null ? -1 : attrDef.getList().getId();
                        view = new CodeAttributeDefView(id, name, label, AttributeType.valueOf((AttributeDefinition)attrDef), attrDef.getFieldNames(), attrDef.isKey(), attrDef.isMultiple(), showInSummary, qualifier, codeListId);
                    } else if (def instanceof CoordinateAttributeDefinition) {
                        attrDef = (CoordinateAttributeDefinition)def;
                        CoordinateAttributeDefView attrDefView = new CoordinateAttributeDefView(id, name, label, AttributeType.valueOf((AttributeDefinition)attrDef), attrDef.getFieldNames(), attrDef.isKey(), attrDef.isMultiple(), showInSummary, qualifier);
                        attrDefView.setFieldsOrder(uiOptions.getFieldsOrder((CoordinateAttributeDefinition)attrDef));
                        attrDefView.setShowSrsField(annotations.isShowSrsField((CoordinateAttributeDefinition)attrDef));
                        attrDefView.setIncludeAccuracyField(annotations.isIncludeCoordinateAccuracy((CoordinateAttributeDefinition)attrDef));
                        attrDefView.setIncludeAltitudeField(annotations.isIncludeCoordinateAltitude((CoordinateAttributeDefinition)attrDef));
                        view = attrDefView;
                    } else if (def instanceof NumberAttributeDefinition) {
                        attrDef = (NumberAttributeDefinition)def;
                        List precisions = attrDef.getPrecisionDefinitions();
                        List<PrecisionView> precisionViews = Views.fromObjects(precisions, PrecisionView.class);
                        NumberAttributeDefView attrDefView = new NumberAttributeDefView(id, name, label, AttributeType.valueOf((AttributeDefinition)attrDef), attrDef.getFieldNames(), attrDef.isKey(), attrDef.isMultiple(), showInSummary, qualifier);
                        attrDefView.setNumericType(attrDef.getType());
                        attrDefView.setPrecisions(precisionViews);
                        view = attrDefView;
                    } else {
                        attrDef = (AttributeDefinition)def;
                        view = new AttributeDefView(id, name, label, AttributeType.valueOf((AttributeDefinition)attrDef), attrDef.getFieldNames(), attrDef.isKey(), attrDef.isMultiple(), showInSummary, qualifier);
                    }
                    attrDef = (AttributeDefinition)def;
                    List fieldLabels = attrDef.getFieldLabels();
                    ArrayList<String> fieldLabelsView = new ArrayList<String>(fieldLabels.size());
                    for (String fieldName : ((AttributeDefinition)def).getFieldNames()) {
                        fieldLabelsView.add(attrDef.getFieldLabel(fieldName, SurveyViewGenerator.this.languageCode));
                    }
                    ((AttributeDefView)view).setFieldLabels(fieldLabelsView);
                }
                UIModelObject uiModelObject = survey.getUIConfiguration().getModelObjectByNodeDefinitionId(def.getId());
                view.setHideWhenNotRelevant(uiModelObject != null && uiModelObject.isHideWhenNotRelevant());
                NodeDefinition parentDef = def.getParentDefinition();
                if (parentDef == null) {
                    surveyView.getSchema().addRootEntity((EntityDefView)view);
                } else {
                    EntityDefView parentView = (EntityDefView)viewById.get(parentDef.getId());
                    parentView.addChild(view);
                }
                viewById.put(id, view);
            }
        });
        return surveyView;
    }

    private CodeListItemView createCodeListItemView(CodeListItem item) {
        CodeListService service = item.getSurvey().getContext().getCodeListService();
        CodeListItemView itemView = new CodeListItemView();
        itemView.id = item.getId();
        itemView.code = item.getCode();
        itemView.label = item.getLabel(this.languageCode);
        itemView.color = item.getColor();
        ArrayList<CodeListItemView> childItemsView = new ArrayList<CodeListItemView>();
        List childItems = service.loadChildItems(item);
        for (CodeListItem childItem : childItems) {
            childItemsView.add(this.createCodeListItemView(childItem));
        }
        itemView.items.addAll(childItemsView);
        return itemView;
    }

    private String getLabel(NodeDefinition def) {
        String label = def.getLabel(NodeLabel.Type.INSTANCE, this.languageCode);
        if (label == null && !def.getSurvey().isDefaultLanguage(this.languageCode)) {
            label = def.getLabel(NodeLabel.Type.INSTANCE);
        }
        return label;
    }

    public void setIncludeCodeListValues(boolean includeCodeListValues) {
        this.includeCodeListValues = includeCodeListValues;
    }
}

