/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.relational;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openforis.collect.event.AttributeCreatedEvent;
import org.openforis.collect.event.AttributeEvent;
import org.openforis.collect.event.AttributeValueUpdatedEvent;
import org.openforis.collect.event.BooleanAttributeUpdatedEvent;
import org.openforis.collect.event.CodeAttributeUpdatedEvent;
import org.openforis.collect.event.CoordinateAttributeUpdatedEvent;
import org.openforis.collect.event.DateAttributeUpdatedEvent;
import org.openforis.collect.event.EntityCreatedEvent;
import org.openforis.collect.event.EntityDeletedEvent;
import org.openforis.collect.event.NumberAttributeUpdatedEvent;
import org.openforis.collect.event.RangeAttributeUpdatedEvent;
import org.openforis.collect.event.RecordDeletedEvent;
import org.openforis.collect.event.RecordEvent;
import org.openforis.collect.event.RecordStep;
import org.openforis.collect.event.RecordTransaction;
import org.openforis.collect.event.TaxonAttributeUpdatedEvent;
import org.openforis.collect.event.TextAttributeUpdatedEvent;
import org.openforis.collect.event.TimeAttributeUpdatedEvent;
import org.openforis.collect.io.metadata.collectearth.NewMondrianSchemaGenerator;
import org.openforis.collect.manager.RecordManager;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectRecord;
import org.openforis.collect.model.CollectRecordSummary;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.model.RecordFilter;
import org.openforis.collect.relational.CollectLocalRDBStorageManager;
import org.openforis.collect.relational.CollectRdbException;
import org.openforis.collect.relational.RDBUpdater;
import org.openforis.collect.relational.data.ColumnValuePair;
import org.openforis.collect.relational.data.internal.DataTableDataExtractor;
import org.openforis.collect.relational.jooq.JooqDatabaseExporter;
import org.openforis.collect.relational.jooq.JooqRelationalSchemaCreator;
import org.openforis.collect.relational.model.Column;
import org.openforis.collect.relational.model.DataColumn;
import org.openforis.collect.relational.model.DataTable;
import org.openforis.collect.relational.model.RelationalSchema;
import org.openforis.collect.relational.model.RelationalSchemaConfig;
import org.openforis.collect.relational.model.RelationalSchemaGenerator;
import org.openforis.collect.reporting.MondrianSchemaStorageManager;
import org.openforis.collect.reporting.ReportingRepositories;
import org.openforis.collect.reporting.ReportingRepositoryInfo;
import org.openforis.collect.reporting.SaikuDatasourceStorageManager;
import org.openforis.concurrency.ProcessProgressListener;
import org.openforis.concurrency.ProcessStepProgressListener;
import org.openforis.concurrency.Progress;
import org.openforis.concurrency.ProgressListener;
import org.openforis.idm.metamodel.AttributeDefinition;
import org.openforis.idm.metamodel.CodeAttributeDefinition;
import org.openforis.idm.metamodel.CoordinateAttributeDefinition;
import org.openforis.idm.metamodel.EntityDefinition;
import org.openforis.idm.metamodel.FieldDefinition;
import org.openforis.idm.metamodel.NodeDefinition;
import org.openforis.idm.metamodel.NumberAttributeDefinition;
import org.openforis.idm.metamodel.RangeAttributeDefinition;
import org.openforis.idm.metamodel.Survey;
import org.openforis.idm.metamodel.TaxonAttributeDefinition;
import org.openforis.idm.model.BooleanValue;
import org.openforis.idm.model.Code;
import org.openforis.idm.model.Coordinate;
import org.openforis.idm.model.NumberValue;
import org.openforis.idm.model.NumericRange;
import org.openforis.idm.model.TaxonOccurrence;
import org.openforis.idm.model.TextValue;
import org.openforis.idm.model.Time;

public class RDBReportingRepositories
implements ReportingRepositories {
    private static final Logger LOG = LogManager.getLogger(RDBReportingRepositories.class);
    private static final String SQLITE_DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    private SurveyManager surveyManager;
    private RecordManager recordManager;
    private CollectLocalRDBStorageManager localRDBStorageManager;
    private MondrianSchemaStorageManager mondrianSchemaStorageManager;
    private SaikuDatasourceStorageManager saikuDatasourceStorageManager;
    private RelationalSchemaConfig rdbConfig = RelationalSchemaConfig.createDefault();
    private Map<String, RelationalSchema> relationalSchemaDefinitionBySurvey;
    private Map<String, String> mondrianSchemaDefinitionBySurvey;

    public RDBReportingRepositories(SurveyManager surveyManager, RecordManager recordManager, CollectLocalRDBStorageManager localRDBStorageManager, MondrianSchemaStorageManager mondrianSchemaStorageManager, SaikuDatasourceStorageManager saikuDatasourceStorageManager) {
        this.surveyManager = surveyManager;
        this.recordManager = recordManager;
        this.localRDBStorageManager = localRDBStorageManager;
        this.mondrianSchemaStorageManager = mondrianSchemaStorageManager;
        this.saikuDatasourceStorageManager = saikuDatasourceStorageManager;
        this.relationalSchemaDefinitionBySurvey = new HashMap<String, RelationalSchema>();
        this.mondrianSchemaDefinitionBySurvey = new HashMap<String, String>();
    }

    public void init() {
        this.initializeSchemaDefinitions();
    }

    private void initializeSchemaDefinitions() {
        List surveys = this.surveyManager.getAll();
        for (CollectSurvey survey : surveys) {
            this.initializeRelationalSchemaDefinition(survey);
            this.initializeMondrianSchemaDefinition(survey, survey.getDefaultLanguage());
        }
    }

    @Override
    public void createRepositories(String surveyName, String preferredLanguage, ProgressListener progressListener) {
        this.initializeRelationalSchemaDefinition(surveyName);
        ProcessProgressListener processProgressListener = new ProcessProgressListener(RecordStep.values().length);
        for (RecordStep step : RecordStep.values()) {
            try {
                this.createRepository(surveyName, step, preferredLanguage, (ProgressListener)new ProcessStepProgressListener(processProgressListener, progressListener));
                processProgressListener.stepCompleted();
            }
            catch (CollectRdbException e) {
                LOG.error("Error generating RDB for survey " + surveyName, (Throwable)e);
            }
        }
        this.updateMondrianSchemaFile(surveyName, preferredLanguage);
        this.writeSaikuDatasources(surveyName);
    }

    @Override
    public void createRepository(final String surveyName, final RecordStep recordStep, String preferredLanguage, final ProgressListener progressListener) {
        this.localRDBStorageManager.deleteRDBFile(surveyName, recordStep);
        this.updateMondrianSchemaFile(surveyName, preferredLanguage);
        if (this.saikuDatasourceStorageManager.isSaikuAvailable()) {
            this.writeSaikuDatasource(surveyName, recordStep);
        }
        final RelationalSchema relationalSchema = this.getOrInitializeRelationalSchemaDefinition(surveyName);
        this.withConnection(surveyName, recordStep, new Callback(){

            @Override
            public void execute(Connection connection) {
                JooqRelationalSchemaCreator relationalSchemaCreator = new JooqRelationalSchemaCreator();
                relationalSchemaCreator.createRelationalSchema(relationalSchema, connection);
                RDBReportingRepositories.this.insertRecords(surveyName, recordStep, relationalSchema, connection, progressListener);
                relationalSchemaCreator.addConstraints(relationalSchema, connection);
                relationalSchemaCreator.addIndexes(relationalSchema, connection);
            }
        });
    }

    private void updateMondrianSchemaFile(String surveyName, String preferredLanguage) {
        CollectSurvey survey = this.surveyManager.get(surveyName);
        this.initializeMondrianSchemaDefinition(survey, preferredLanguage);
        this.writeMondrianSchemaFile(surveyName);
    }

    private void writeSaikuDatasources(String surveyName) {
        if (this.saikuDatasourceStorageManager.isSaikuAvailable()) {
            for (RecordStep recordStep : RecordStep.values()) {
                this.writeSaikuDatasource(surveyName, recordStep);
            }
        }
    }

    private void writeSaikuDatasource(String surveyName, RecordStep recordStep) {
        this.saikuDatasourceStorageManager.writeDatasourceFile(surveyName, recordStep);
    }

    private void deleteSaikuDatasources(String surveyName) {
        if (this.saikuDatasourceStorageManager.isSaikuAvailable()) {
            for (RecordStep recordStep : RecordStep.values()) {
                this.saikuDatasourceStorageManager.deleteDatasourceFile(surveyName, recordStep);
            }
        }
    }

    private void writeMondrianSchemaFile(String surveyName) {
        try {
            this.mondrianSchemaStorageManager.createBackupCopy(surveyName);
            File file = this.mondrianSchemaStorageManager.getSchemaFile(surveyName);
            String schema = this.mondrianSchemaDefinitionBySurvey.get(surveyName);
            FileUtils.write((File)file, (CharSequence)schema, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating mondrian schema for survey : " + surveyName, e);
        }
    }

    private void insertRecords(String surveyName, RecordStep recordStep, RelationalSchema targetSchema, Connection targetConn, ProgressListener progressListener) throws CollectRdbException {
        ProcessProgressListener processProgressListener = new ProcessProgressListener(2);
        CollectSurvey survey = this.surveyManager.get(surveyName);
        JooqDatabaseExporter databaseUpdater = this.createRDBUpdater(targetSchema, targetConn);
        databaseUpdater.insertReferenceData((ProgressListener)new ProcessStepProgressListener(processProgressListener, progressListener));
        processProgressListener.stepCompleted();
        RecordFilter recordFilter = new RecordFilter(survey);
        CollectRecord.Step step = CollectRecord.Step.fromRecordStep((RecordStep)recordStep);
        recordFilter.setStepGreaterOrEqual(step);
        List summaries = this.recordManager.loadSummaries(recordFilter);
        ProcessStepProgressListener recordInsertProcessListener = new ProcessStepProgressListener(processProgressListener, progressListener);
        recordInsertProcessListener.progressMade(new Progress(0L, (long)summaries.size()));
        long processedRecords = 0L;
        for (CollectRecordSummary summary : summaries) {
            CollectRecord record = this.recordManager.load(survey, summary.getId().intValue(), step, false);
            databaseUpdater.insertRecordData(record, ProgressListener.NULL_PROGRESS_LISTENER);
            recordInsertProcessListener.progressMade(new Progress(++processedRecords, (long)summaries.size()));
        }
        IOUtils.closeQuietly((Closeable)databaseUpdater);
        processProgressListener.stepCompleted();
    }

    @Override
    public void updateRepositories(String surveyName, String preferredLanguage, ProgressListener progressListener) {
        this.createRepositories(surveyName, preferredLanguage, progressListener);
    }

    @Override
    public void deleteRepositories(String surveyName) {
        for (RecordStep step : RecordStep.values()) {
            this.localRDBStorageManager.deleteRDBFile(surveyName, step);
        }
        this.relationalSchemaDefinitionBySurvey.remove(surveyName);
        this.mondrianSchemaStorageManager.deleteSchemaFile(surveyName);
        this.deleteSaikuDatasources(surveyName);
    }

    @Override
    public void process(final RecordTransaction recordTransaction) {
        final RelationalSchema rdbSchema = this.getRelatedRelationalSchema(recordTransaction);
        final CollectSurvey survey = (CollectSurvey)rdbSchema.getSurvey();
        RecordStep step = recordTransaction.getRecordStep();
        this.withConnection(survey.getName(), step, new Callback(){

            @Override
            public void execute(Connection connection) {
                JooqDatabaseExporter rdbUpdater = RDBReportingRepositories.this.createRDBUpdater(rdbSchema, connection);
                for (RecordEvent recordEvent : recordTransaction.getEvents()) {
                    EventHandler handler = new EventHandler(recordEvent, rdbSchema, survey, (RDBUpdater)rdbUpdater);
                    handler.handle();
                }
            }
        });
    }

    @Override
    public List<String> getRepositoryPaths(String surveyName) {
        ArrayList<String> result = new ArrayList<String>();
        for (RecordStep recordStep : RecordStep.values()) {
            result.add(this.getRepositoryPath(surveyName, recordStep));
        }
        return result;
    }

    @Override
    public String getRepositoryPath(String surveyName, RecordStep recordStep) {
        File rdbFile = this.localRDBStorageManager.getRDBFile(surveyName, recordStep);
        String path = rdbFile.getAbsolutePath();
        return path;
    }

    @Override
    public ReportingRepositoryInfo getInfo(String surveyName) {
        Date rdbFileDate = this.localRDBStorageManager.getRDBFileDate(surveyName, RecordStep.ENTRY);
        if (rdbFileDate == null) {
            return null;
        }
        ReportingRepositoryInfo info = new ReportingRepositoryInfo();
        info.setLastUpdate(rdbFileDate);
        RecordFilter filter = new RecordFilter(this.surveyManager.get(surveyName));
        filter.setModifiedSince(rdbFileDate);
        info.setUpdatedRecordsSinceLastUpdate(this.recordManager.countRecords(filter));
        return info;
    }

    private RelationalSchema getOrInitializeRelationalSchemaDefinition(String surveyName) {
        if (!this.relationalSchemaDefinitionBySurvey.containsKey(surveyName)) {
            this.initializeRelationalSchemaDefinition(surveyName);
        }
        return this.relationalSchemaDefinitionBySurvey.get(surveyName);
    }

    private void withConnection(String surveyName, RecordStep recordStep, Callback job) {
        Connection connection = null;
        try {
            connection = this.createTargetConnection(surveyName, recordStep);
            connection.setAutoCommit(false);
            job.execute(connection);
            connection.commit();
        }
        catch (Exception e) {
            LOG.error("Error processing record events: " + e.getMessage(), (Throwable)e);
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                LOG.error("Rollback failed: " + e1.getMessage(), (Throwable)e1);
            }
            throw new RuntimeException("Error processing RDB generation events", e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Connection createTargetConnection(String surveyName, RecordStep step) throws CollectRdbException {
        try {
            String pathToDbFile = this.getRepositoryPath(surveyName, step);
            String connectionUrl = "jdbc:sqlite:" + pathToDbFile;
            Class.forName(SQLITE_DRIVER_CLASS_NAME);
            Connection c = DriverManager.getConnection(connectionUrl);
            return c;
        }
        catch (Exception e) {
            throw new CollectRdbException(String.format("Error creating connection to RDB for survey %s", surveyName), (Throwable)e);
        }
    }

    private RelationalSchema getRelatedRelationalSchema(RecordTransaction recordTransaction) {
        String surveyName = recordTransaction.getSurveyName();
        CollectSurvey survey = this.surveyManager.get(surveyName);
        return survey == null ? null : this.relationalSchemaDefinitionBySurvey.get(survey.getName());
    }

    private void initializeRelationalSchemaDefinition(String surveyName) {
        this.initializeRelationalSchemaDefinition(this.surveyManager.get(surveyName));
    }

    private void initializeRelationalSchemaDefinition(CollectSurvey survey) {
        try {
            RelationalSchemaGenerator schemaGenerator = new RelationalSchemaGenerator(this.rdbConfig);
            RelationalSchema relationalSchema = schemaGenerator.generateSchema((Survey)survey, survey.getName());
            this.relationalSchemaDefinitionBySurvey.put(survey.getName(), relationalSchema);
        }
        catch (CollectRdbException e) {
            LOG.error("Error generating relational schema for survey " + survey.getName(), (Throwable)e);
        }
    }

    private void initializeMondrianSchemaDefinition(CollectSurvey survey, String preferredLanguage) {
        try {
            boolean schemaLess = true;
            String schemaName = schemaLess ? "" : survey.getName();
            NewMondrianSchemaGenerator schemaGenerator = new NewMondrianSchemaGenerator(survey, (String)ObjectUtils.defaultIfNull((Object)preferredLanguage, (Object)survey.getDefaultLanguage()), schemaName, this.rdbConfig);
            String mondrianSchema = schemaGenerator.generateXMLSchema();
            this.mondrianSchemaDefinitionBySurvey.put(survey.getName(), mondrianSchema);
        }
        catch (CollectRdbException e) {
            LOG.error("Error generating relational schema for survey " + survey.getName(), (Throwable)e);
        }
    }

    private JooqDatabaseExporter createRDBUpdater(RelationalSchema schema, Connection targetConn) {
        return new JooqDatabaseExporter(schema, targetConn);
    }

    private class EventHandler {
        private RecordEvent recordEvent;
        private RelationalSchema rdbSchema;
        private CollectSurvey survey;
        private RDBUpdater rdbUpdater;

        public EventHandler(RecordEvent recordEvent, RelationalSchema rdbSchema, CollectSurvey survey, RDBUpdater rdbUpdater) {
            this.recordEvent = recordEvent;
            this.rdbSchema = rdbSchema;
            this.survey = survey;
            this.rdbUpdater = rdbUpdater;
        }

        public void handle() {
            if (this.recordEvent instanceof EntityCreatedEvent) {
                this.insertEntity();
            } else if (this.recordEvent instanceof AttributeEvent) {
                if (this.recordEvent instanceof AttributeCreatedEvent) {
                    this.insertAttribute();
                } else if (this.recordEvent instanceof AttributeValueUpdatedEvent) {
                    this.updateAttributeData();
                } else {
                    this.deleteAttribute();
                }
            } else if (this.recordEvent instanceof EntityDeletedEvent) {
                this.deleteEntity();
            } else if (this.recordEvent instanceof RecordDeletedEvent) {
                this.deleteRecord();
            }
        }

        private void insertEntity() {
            this.rdbUpdater.insertEntity(this.recordEvent.getRecordId().intValue(), this.getParentEntityId(), this.getNodeId(), this.getDefinitionId());
        }

        private void insertAttribute() {
            this.rdbUpdater.insertAttribute(this.recordEvent.getRecordId().intValue(), this.getParentEntityId(), this.getNodeId(), this.getDefinitionId());
        }

        private void updateAttributeData() {
            Integer rowNodeId;
            DataTable dataTable;
            AttributeDefinition def = (AttributeDefinition)this.survey.getSchema().getDefinitionById(this.getDefinitionId());
            if (def.isMultiple()) {
                dataTable = this.rdbSchema.getDataTable((NodeDefinition)def);
                rowNodeId = this.getNodeId();
            } else {
                EntityDefinition multipleEntityDef = def.getNearestAncestorMultipleEntity();
                dataTable = this.rdbSchema.getDataTable((NodeDefinition)multipleEntityDef);
                rowNodeId = this.getParentEntityId();
            }
            NodeDefinition tableNodeDef = dataTable.getNodeDefinition();
            BigInteger pkValue = DataTableDataExtractor.getTableArtificialPK((int)this.recordEvent.getRecordId(), (NodeDefinition)tableNodeDef, (int)rowNodeId);
            List<ColumnValuePair<DataColumn, ?>> columnValuePairs = this.toColumnValuePairs(dataTable, def);
            this.rdbUpdater.updateEntityData(dataTable, pkValue, columnValuePairs);
        }

        public List<ColumnValuePair<DataColumn, ?>> toColumnValuePairs(DataTable dataTable, AttributeDefinition attributeDef) {
            List dataColumns = dataTable.getDataColumns(attributeDef);
            List<Object> columnValuePairs = new ArrayList();
            if (this.recordEvent instanceof BooleanAttributeUpdatedEvent) {
                BooleanValue value = (BooleanValue)((BooleanAttributeUpdatedEvent)this.recordEvent).getValue();
                Boolean valueBoolean = value == null ? null : value.getValue();
                columnValuePairs.add(new ColumnValuePair((Column)dataColumns.get(0), (Object)valueBoolean));
            } else if (this.recordEvent instanceof CodeAttributeUpdatedEvent) {
                CodeAttributeUpdatedEvent evt = (CodeAttributeUpdatedEvent)this.recordEvent;
                Code value = (Code)evt.getValue();
                CodeAttributeDefinition codeAttrDef = (CodeAttributeDefinition)attributeDef;
                DataColumn codeColumn = dataTable.getDataColumn(codeAttrDef.getCodeFieldDefinition());
                DataColumn qualifierColumn = dataTable.getDataColumn(codeAttrDef.getQualifierFieldDefinition());
                String code = value == null ? null : value.getCode();
                columnValuePairs.add(new ColumnValuePair((Column)codeColumn, (Object)code));
                if (qualifierColumn != null) {
                    String qualifier = value == null ? null : value.getQualifier();
                    columnValuePairs.add(new ColumnValuePair((Column)qualifierColumn, (Object)qualifier));
                }
            } else if (this.recordEvent instanceof CoordinateAttributeUpdatedEvent) {
                CoordinateAttributeDefinition coordinateAttrDef = (CoordinateAttributeDefinition)attributeDef;
                CoordinateAttributeUpdatedEvent event = (CoordinateAttributeUpdatedEvent)this.recordEvent;
                Coordinate value = (Coordinate)event.getValue();
                Double x = value == null ? null : value.getX();
                Double y = value == null ? null : value.getY();
                String srsId = value == null ? null : value.getSrsId();
                DataColumn xColumn = dataTable.getDataColumn(coordinateAttrDef.getXField());
                DataColumn yColumn = dataTable.getDataColumn(coordinateAttrDef.getYField());
                DataColumn srsIdColumn = dataTable.getDataColumn(coordinateAttrDef.getSrsIdField());
                columnValuePairs = Arrays.asList(new ColumnValuePair((Column)xColumn, (Object)x), new ColumnValuePair((Column)yColumn, (Object)y), new ColumnValuePair((Column)srsIdColumn, (Object)srsId));
            } else if (this.recordEvent instanceof DateAttributeUpdatedEvent) {
                org.openforis.idm.model.Date value = (org.openforis.idm.model.Date)((DateAttributeUpdatedEvent)this.recordEvent).getValue();
                columnValuePairs.add(new ColumnValuePair((Column)dataColumns.get(0), (Object)(value == null ? null : value.toJavaDate())));
            } else if (this.recordEvent instanceof NumberAttributeUpdatedEvent) {
                NumberAttributeUpdatedEvent event = (NumberAttributeUpdatedEvent)this.recordEvent;
                NumberValue value = (NumberValue)event.getValue();
                NumberAttributeDefinition numberAttrDef = (NumberAttributeDefinition)attributeDef;
                FieldDefinition unitIdFieldDef = numberAttrDef.getUnitIdFieldDefinition();
                DataColumn unitColumn = dataTable.getDataColumn(unitIdFieldDef);
                if (unitColumn != null) {
                    Integer unitId = value.getUnit() == null ? null : Integer.valueOf(value.getUnit().getId());
                    columnValuePairs.add(new ColumnValuePair((Column)unitColumn, (Object)unitId));
                }
                DataColumn valueColumn = dataTable.getDataColumn(numberAttrDef.getValueFieldDefinition());
                Number numberValue = value == null ? (Number)null : (Number)value.getValue();
                columnValuePairs.add(new ColumnValuePair((Column)valueColumn, (Object)numberValue));
            } else if (this.recordEvent instanceof RangeAttributeUpdatedEvent) {
                NumericRange value = (NumericRange)((RangeAttributeUpdatedEvent)this.recordEvent).getValue();
                NumberAttributeDefinition numberAttrDef = (NumberAttributeDefinition)attributeDef;
                FieldDefinition unitIdFieldDef = numberAttrDef.getUnitIdFieldDefinition();
                DataColumn unitColumn = dataTable.getDataColumn(unitIdFieldDef);
                if (unitColumn != null) {
                    Integer unitId = value.getUnit() == null ? null : Integer.valueOf(value.getUnit().getId());
                    columnValuePairs.add(new ColumnValuePair((Column)unitColumn, (Object)unitId));
                }
                Number from = value == null ? (Number)null : (Number)value.getFrom();
                RangeAttributeDefinition rangeAttrDef = (RangeAttributeDefinition)attributeDef;
                DataColumn fromColumn = dataTable.getDataColumn(rangeAttrDef.getFromFieldDefinition());
                columnValuePairs.add(new ColumnValuePair((Column)fromColumn, (Object)from));
                Number to = value == null ? (Number)null : (Number)value.getTo();
                DataColumn toColumn = dataTable.getDataColumn(rangeAttrDef.getToFieldDefinition());
                columnValuePairs.add(new ColumnValuePair((Column)toColumn, (Object)to));
            } else if (this.recordEvent instanceof TaxonAttributeUpdatedEvent) {
                TaxonAttributeUpdatedEvent evt = (TaxonAttributeUpdatedEvent)this.recordEvent;
                TaxonOccurrence value = (TaxonOccurrence)evt.getValue();
                TaxonAttributeDefinition taxonAttrDef = (TaxonAttributeDefinition)attributeDef;
                DataColumn codeColumn = dataTable.getDataColumn(taxonAttrDef.getCodeFieldDefinition());
                DataColumn scientificNameColumn = dataTable.getDataColumn(taxonAttrDef.getScientificNameFieldDefinition());
                DataColumn vernacularNameColumn = dataTable.getDataColumn(taxonAttrDef.getVernacularNameFieldDefinition());
                DataColumn languageCodeColumn = dataTable.getDataColumn(taxonAttrDef.getLanguageCodeFieldDefinition());
                DataColumn languageVarietyColumn = dataTable.getDataColumn(taxonAttrDef.getLanguageVarietyFieldDefinition());
                String scientificName = value == null ? null : value.getScientificName();
                String vernacularName = value == null ? null : value.getVernacularName();
                String langCode = value == null ? null : value.getLanguageCode();
                String langVariety = value == null ? null : value.getLanguageVariety();
                columnValuePairs = Arrays.asList(new ColumnValuePair((Column)codeColumn, (Object)(value == null ? null : value.getCode())), new ColumnValuePair((Column)scientificNameColumn, (Object)scientificName), new ColumnValuePair((Column)vernacularNameColumn, (Object)vernacularName), new ColumnValuePair((Column)languageCodeColumn, (Object)langCode), new ColumnValuePair((Column)languageVarietyColumn, (Object)langVariety));
            } else if (this.recordEvent instanceof TextAttributeUpdatedEvent) {
                TextValue value = (TextValue)((TextAttributeUpdatedEvent)this.recordEvent).getValue();
                String valueText = value == null ? null : value.getValue();
                columnValuePairs.add(new ColumnValuePair((Column)dataColumns.get(0), (Object)valueText));
            } else if (this.recordEvent instanceof TimeAttributeUpdatedEvent) {
                Time value = (Time)((TimeAttributeUpdatedEvent)this.recordEvent).getValue();
                Date valueDate = value == null ? null : value.toJavaDate();
                columnValuePairs.add(new ColumnValuePair((Column)dataColumns.get(0), (Object)valueDate));
            } else {
                throw new UnsupportedOperationException("Unsupported record event type: " + this.recordEvent.getClass().getName());
            }
            return columnValuePairs;
        }

        private void deleteEntity() {
            this.rdbUpdater.deleteEntity(this.recordEvent.getRecordId().intValue(), this.getNodeId(), this.getDefinitionId());
        }

        private void deleteAttribute() {
            this.rdbUpdater.deleteAttribute(this.recordEvent.getRecordId().intValue(), this.getNodeId(), this.getDefinitionId());
        }

        private void deleteRecord() {
            this.rdbUpdater.deleteRecordData(this.recordEvent.getRecordId().intValue(), this.getDefinitionId());
        }

        private Integer getParentEntityId() {
            boolean isRootEntity;
            String definitionId = this.recordEvent.getDefinitionId();
            NodeDefinition def = this.survey.getSchema().getDefinitionById(Integer.parseInt(definitionId));
            boolean bl = isRootEntity = def instanceof EntityDefinition && ((EntityDefinition)def).isRoot();
            if (isRootEntity) {
                return null;
            }
            boolean inCollection = def.isMultiple();
            int parentIdx = inCollection ? 1 : 0;
            List ancestorIds = this.recordEvent.getAncestorIds();
            return Integer.parseInt((String)ancestorIds.get(parentIdx));
        }

        private int getNodeId() {
            return Integer.parseInt(this.recordEvent.getNodeId());
        }

        private int getDefinitionId() {
            return Integer.parseInt(this.recordEvent.getDefinitionId());
        }
    }

    private static interface Callback {
        public void execute(Connection var1);
    }
}

