/*
 * Decompiled with CFR 0.152.
 */
package org.openforis.collect.remoting.service.io.data.restore;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.openforis.collect.concurrency.CollectJobManager;
import org.openforis.collect.io.BackupFileExtractor;
import org.openforis.collect.io.SurveyBackupInfo;
import org.openforis.collect.io.data.DataRestoreJob;
import org.openforis.collect.io.data.DataRestoreTask;
import org.openforis.collect.manager.SurveyManager;
import org.openforis.collect.model.CollectSurvey;
import org.openforis.collect.remoting.service.io.data.restore.DataRestoreService;
import org.openforis.concurrency.Job;
import org.springframework.beans.factory.annotation.Autowired;

public class DataRestoreServiceImpl
implements DataRestoreService {
    @Autowired
    private SurveyManager surveyManager;
    @Autowired
    private CollectJobManager jobManager;

    @Override
    public String startSurveyDataRestore(String surveyName, File backupFile) {
        CollectSurvey survey = this.surveyManager.get(surveyName);
        String surveyUri = this.extractSurveyUri(backupFile);
        this.checkValidSurvey(surveyName, surveyUri);
        DataRestoreJob job = (DataRestoreJob)this.jobManager.createJob("dataRestoreJob", DataRestoreJob.class);
        job.setStoreRestoredFile(true);
        job.setPublishedSurvey(survey);
        job.setFile(backupFile);
        job.setRecordOverwriteStrategy(DataRestoreTask.OverwriteStrategy.OVERWRITE_ALL);
        job.setRestoreUploadedFiles(true);
        job.setCloseRecordProviderOnComplete(true);
        String lockId = surveyUri;
        this.jobManager.start((Job)job, lockId);
        return lockId;
    }

    private void checkValidSurvey(String surveyName, String surveyUri) {
        CollectSurvey expectedSurvey = this.surveyManager.get(surveyName);
        String expectedSurveyUri = expectedSurvey.getUri();
        if (!surveyUri.equals(expectedSurveyUri)) {
            throw new IllegalArgumentException("The backup file is not related to the specified survey");
        }
    }

    private String extractSurveyUri(File tempFile) {
        String string;
        BackupFileExtractor backupFileExtractor = null;
        try {
            String surveyUri;
            backupFileExtractor = new BackupFileExtractor(tempFile);
            File infoFile = backupFileExtractor.extractInfoFile();
            SurveyBackupInfo backupInfo = SurveyBackupInfo.parse((InputStream)new FileInputStream(infoFile));
            string = surveyUri = backupInfo.getSurveyUri();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(backupFileExtractor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)backupFileExtractor);
        return string;
    }
}

